/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnectionEvent;
import com.myjavaworld.ftp.ControlConnectionListener;
import com.myjavaworld.ftp.CustomSocketFactory;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConstants;
import com.myjavaworld.ftp.FTPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.swing.event.EventListenerList;

public class ControlConnection
implements FTPConstants {
    protected FTPClient client = null;
    protected Socket socket = null;
    protected BufferedReader reader = null;
    protected PrintStream writer = null;
    protected EventListenerList listenerList = null;

    public ControlConnection(FTPClient client) {
        this.client = client;
        this.listenerList = client.getListenerList();
    }

    public void connect(String host) throws ConnectionException, FTPException {
        this.connect(host, 21);
    }

    public void connect(String host, int port) throws ConnectionException, FTPException {
        try {
            CustomSocketFactory factory = new CustomSocketFactory(this.client);
            this.socket = ((SocketFactory)factory).createSocket(host, port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintStream(this.socket.getOutputStream(), true);
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (NoRouteToHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (SocketException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        try {
            this.socket.setSoTimeout(this.client.getTimeout());
            this.socket.setKeepAlive(true);
        }
        catch (SocketException exp) {
            this.stderr("Could not set timeout for the socket. Original exception below. \n" + exp.getMessage());
        }
        String reply = this.getReply();
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
    }

    public void sendCommand(String command) throws ConnectionException {
        try {
            this.writer.print(command + "\r\n");
            if (command.startsWith("PASS ")) {
                this.fireCommandSent(new ControlConnectionEvent(this.client, "PASS **********"));
            } else {
                this.fireCommandSent(new ControlConnectionEvent(this.client, command));
            }
            if (this.writer.checkError()) {
                throw new IOException("Could not send command: " + command);
            }
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public synchronized String getReply() throws ConnectionException {
        String line = null;
        try {
            line = this.reader.readLine();
            if (line == null) {
                throw new IOException("Connection Dropped. ");
            }
            String replyCode = "000";
            replyCode = line.substring(0, 3);
            StringBuffer buffer = new StringBuffer();
            buffer.append(line);
            if (line.charAt(3) == '-') {
                do {
                    buffer.append("\r\n");
                    line = this.reader.readLine();
                    buffer.append(line);
                } while (!line.startsWith(replyCode + " "));
            }
            String reply = buffer.toString();
            this.fireReplyReceived(new ControlConnectionEvent(this.client, reply));
            return reply;
        }
        catch (StringIndexOutOfBoundsException exp) {
            line = "000 Invalid Response Received from your FTP server. The actual response is: [" + line + "]";
            this.fireReplyReceived(new ControlConnectionEvent(this.client, line));
            return line;
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public String executeCommand(String command) throws ConnectionException {
        this.sendCommand(command);
        return this.getReply();
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.reader = null;
        this.writer = null;
        this.socket = null;
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRemoteIPAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public String getLocalHost() {
        return this.socket.getLocalAddress().getHostName();
    }

    public String getLocalIPAddress() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public boolean isSecured() {
        return this.socket != null && this.socket instanceof SSLSocket;
    }

    public SSLSession getSSLSession() {
        if (!this.isSecured()) {
            return null;
        }
        return ((SSLSocket)this.socket).getSession();
    }

    protected void fireCommandSent(ControlConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ControlConnectionListener.class) continue;
            ((ControlConnectionListener)listeners[i + 1]).commandSent(evt);
        }
    }

    protected void fireReplyReceived(ControlConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ControlConnectionListener.class) continue;
            ((ControlConnectionListener)listeners[i + 1]).replyReceived(evt);
        }
    }

    protected void stdout(String message) {
        System.out.println(message);
    }

    protected void stderr(String message) {
        System.err.println(message);
    }
}

