/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.FTPClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

class CustomSocketFactory
extends SocketFactory {
    private Proxy proxy = null;

    public CustomSocketFactory(FTPClient client) {
        this.proxy = client.getProxy();
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(host, port, null, 0);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.createSocket(address, port, null, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port, localAddress, localPort);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.proxy == null) {
            return new Socket(address, port, localAddress, localPort);
        }
        switch (this.proxy.type()) {
            case SOCKS: {
                Socket socket = new Socket(this.proxy);
                socket.bind(new InetSocketAddress(localAddress, localPort));
                socket.connect(new InetSocketAddress(address, port));
                return socket;
            }
            case DIRECT: {
                return new Socket(address, port, localAddress, localPort);
            }
        }
        throw new RuntimeException("Invalid or unimplemented proxy type: " + (Object)((Object)this.proxy.type()));
    }
}

