/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.CustomSocketFactory;
import com.myjavaworld.ftp.DataConnectionEvent;
import com.myjavaworld.ftp.DataConnectionListener;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConstants;
import com.myjavaworld.ftp.FTPUtil;
import com.myjavaworld.ftp.FromNetASCIIInputStream;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.ftp.ToNetASCIIInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import javax.net.SocketFactory;
import javax.swing.event.EventListenerList;

public class DataConnection
implements FTPConstants {
    protected FTPClient client = null;
    protected ServerSocket server = null;
    protected Socket socket = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected EventListenerList listenerList = null;
    protected boolean abort = false;

    public DataConnection(FTPClient client) {
        this.client = client;
        this.listenerList = client.getListenerList();
        this.abort = false;
    }

    public synchronized int bind() throws ConnectionException {
        try {
            this.server = new ServerSocket(0, 0, this.client.getLocalAddress());
            return this.server.getLocalPort();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public synchronized void accept() throws ConnectionException {
        try {
            this.server.setSoTimeout(this.client.getTimeout());
        }
        catch (SocketException exp) {
            // empty catch block
        }
        try {
            this.socket = this.server.accept();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        try {
            this.socket.setSoTimeout(this.client.getTimeout());
        }
        catch (SocketException exp) {
            // empty catch block
        }
        try {
            this.socket.setSendBufferSize(this.client.getBufferSize());
            this.socket.setReceiveBufferSize(this.client.getBufferSize());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public synchronized void connect(String ipAddress, int port) throws ConnectionException {
        try {
            if (this.client.isPassiveIPSubstitutionEnabled()) {
                this.connect(this.client.getRemoteAddress(), port);
            } else {
                this.connect(InetAddress.getByName(ipAddress), port);
            }
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public synchronized void connect(InetAddress address, int port) throws ConnectionException {
        try {
            CustomSocketFactory factory = new CustomSocketFactory(this.client);
            this.socket = ((SocketFactory)factory).createSocket(address, port);
            try {
                this.socket.setSoTimeout(this.client.getTimeout());
            }
            catch (SocketException exp) {
                // empty catch block
            }
            try {
                this.socket.setSendBufferSize(this.client.getBufferSize());
                this.socket.setReceiveBufferSize(this.client.getBufferSize());
            }
            catch (SocketException exp) {}
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (NoRouteToHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (SocketException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public void close() {
        FTPUtil.close(this.in);
        FTPUtil.close(this.out);
        FTPUtil.close(this.socket);
        FTPUtil.close(this.server);
    }

    public void abort() {
        this.abort = true;
    }

    public boolean isAborted() {
        return this.abort;
    }

    public RemoteFile[] list(RemoteFile dir) throws ConnectionException, ParseException {
        RemoteFile[] remoteFileArray;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()), this.client.getBufferSize());
            ListParser parser = this.client.getListParser();
            remoteFileArray = parser.parse(dir, reader);
        }
        catch (IOException exp) {
            try {
                throw new ConnectionException(exp.toString());
            }
            catch (Throwable throwable) {
                FTPUtil.close(reader);
                this.close();
                throw throwable;
            }
        }
        FTPUtil.close(reader);
        this.close();
        return remoteFileArray;
    }

    public void download(File destination, boolean append) throws IOException {
        this.abort = false;
        this.download(destination, append, this.client.getType() == 1);
    }

    public void upload(File source, long skip) throws IOException {
        this.abort = false;
        this.upload(source, skip, this.client.getType() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(File destination, boolean append, boolean ascii) throws IOException {
        long totalBytes = 0L;
        try {
            int bufferSize = this.client.getBufferSize();
            this.in = new BufferedInputStream(this.socket.getInputStream(), bufferSize);
            if (ascii) {
                this.in = new FromNetASCIIInputStream(this.in);
            }
            this.out = new BufferedOutputStream(new FileOutputStream(destination.getAbsolutePath(), append), bufferSize);
            byte[] bytes = new byte[bufferSize];
            int bytesRead = 0;
            this.fireDataTransferStarted(new DataConnectionEvent(this.client, 2, totalBytes));
            while ((bytesRead = this.in.read(bytes)) != -1) {
                if (this.abort) {
                    this.fireDataTransferAborted(new DataConnectionEvent(this, 2, totalBytes));
                    break;
                }
                this.out.write(bytes, 0, bytesRead);
                this.fireDataTransferProgress(new DataConnectionEvent(this.client, 2, totalBytes += (long)bytesRead));
            }
        }
        finally {
            this.fireDataTransferFinished(new DataConnectionEvent(this.client, 2, totalBytes));
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(File source, long skip, boolean ascii) throws IOException {
        long totalBytes = 0L;
        try {
            int bufferSize = this.client.getBufferSize();
            this.in = new BufferedInputStream(new FileInputStream(source), bufferSize);
            if (ascii) {
                this.in = new ToNetASCIIInputStream(this.in);
            }
            this.out = new BufferedOutputStream(this.socket.getOutputStream(), bufferSize);
            byte[] bytes = new byte[bufferSize];
            int bytesRead = 0;
            if (skip > 0L) {
                this.in.skip(skip);
            }
            this.fireDataTransferStarted(new DataConnectionEvent(this.client, 1, totalBytes));
            while ((bytesRead = this.in.read(bytes)) != -1) {
                if (this.abort) {
                    this.fireDataTransferAborted(new DataConnectionEvent(this, 2, totalBytes));
                    break;
                }
                this.out.write(bytes, 0, bytesRead);
                this.out.flush();
                this.fireDataTransferProgress(new DataConnectionEvent(this.client, 1, totalBytes += (long)bytesRead));
            }
        }
        finally {
            this.fireDataTransferFinished(new DataConnectionEvent(this.client, 1, totalBytes));
            this.close();
        }
    }

    protected void fireDataTransferStarted(DataConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataConnectionListener.class) continue;
            ((DataConnectionListener)listeners[i + 1]).dataTransferStarted(evt);
        }
    }

    protected void fireDataTransferFinished(DataConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataConnectionListener.class) continue;
            ((DataConnectionListener)listeners[i + 1]).dataTransferFinished(evt);
        }
    }

    protected void fireDataTransferAborted(DataConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataConnectionListener.class) continue;
            ((DataConnectionListener)listeners[i + 1]).dataTransferAborted(evt);
        }
    }

    protected void fireDataTransferProgress(DataConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataConnectionListener.class) continue;
            ((DataConnectionListener)listeners[i + 1]).dataTransferProgress(evt);
        }
    }

    protected void stdout(String message) {
        System.out.println(message);
    }
}

