/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnection;
import com.myjavaworld.ftp.ControlConnectionListener;
import com.myjavaworld.ftp.DataConnection;
import com.myjavaworld.ftp.DataConnectionListener;
import com.myjavaworld.ftp.ExplicitSSLControlConnection;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConnectionEvent;
import com.myjavaworld.ftp.FTPConnectionListener;
import com.myjavaworld.ftp.FTPConstants;
import com.myjavaworld.ftp.FTPException;
import com.myjavaworld.ftp.FTPHost;
import com.myjavaworld.ftp.FTPUtil;
import com.myjavaworld.ftp.ImplicitSSLControlConnection;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.ftp.SSLDataConnection;
import com.myjavaworld.util.Filter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.text.ParseException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.swing.event.EventListenerList;

public class DefaultFTPClient
implements FTPClient,
FTPConstants {
    protected int timeout = 300000;
    protected int bufferSize = 65536;
    protected int type = 2;
    protected int mode = 1;
    protected int structure = 1;
    protected boolean passive = false;
    protected boolean connected = false;
    protected boolean loggedIn = false;
    protected RemoteFile workingDirectory = null;
    protected String reply = "";
    protected ControlConnection controlConnection = null;
    protected DataConnection dataConnection = null;
    protected ListParser listParser = null;
    protected int sslUsage = 0;
    protected SSLContext sslContext = null;
    protected boolean dataChannelUnencrypted = false;
    protected String explicitSSLProtocol = "SSL";
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean passiveIPSubstitutionEnabled = false;
    protected Proxy proxy = null;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setListParser(ListParser listParser) {
        this.listParser = listParser;
    }

    public ListParser getListParser() {
        return this.listParser;
    }

    public void setSSLUsage(int sslUsage) {
        this.sslUsage = sslUsage;
    }

    public int getSSLUsage() {
        return this.sslUsage;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setDataChannelUnencrypted(boolean dataChannelUnencrypted) {
        this.dataChannelUnencrypted = dataChannelUnencrypted;
    }

    public boolean isDataChannelUnencrypted() {
        return this.dataChannelUnencrypted;
    }

    public boolean isSecured() {
        if (!this.loggedIn) {
            return false;
        }
        return this.controlConnection.isSecured();
    }

    public void setExplicitSSLProtocol(String protocol) {
        if (protocol == null) {
            throw new NullPointerException();
        }
        if (protocol.trim().length() == 0) {
            throw new IllegalArgumentException("protocol cannot be empty");
        }
        this.explicitSSLProtocol = protocol;
    }

    public String getExplicitSSLProtocol() {
        return this.explicitSSLProtocol;
    }

    public synchronized void connect(String host) throws FTPException, ConnectionException {
        this.connect(host, 21);
    }

    public synchronized void connect(String host, int port) throws FTPException, ConnectionException {
        this.controlConnection = this.sslUsage == 2 ? new ImplicitSSLControlConnection(this) : (this.sslUsage == 3 || this.sslUsage == 1 ? new ExplicitSSLControlConnection(this) : new ControlConnection(this));
        this.controlConnection.connect(host, port);
        this.connected = true;
    }

    public synchronized void connect(FTPHost ftpHost) throws FTPException, ConnectionException {
        this.connect(ftpHost.getHostName(), ftpHost.getPort());
        this.login(ftpHost.getUserName(), ftpHost.getPassword(), ftpHost.getAccount());
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void login(String user, String password) throws FTPException, ConnectionException {
        this.login(user, password, "");
    }

    public synchronized void login(String user, String password, String account) throws FTPException, ConnectionException {
        this.executeCommand("USER " + user);
        if (this.reply.charAt(0) == '3') {
            this.executeCommand("PASS " + password);
        }
        if (this.reply.charAt(0) == '3') {
            if (account.trim().length() > 0) {
                this.executeCommand("ACCT " + account);
            } else {
                throw new FTPException("Account information required to login. ");
            }
        }
        this.loggedIn = true;
        String connectionMessage = "Connected to " + this.getRemoteHost() + "/" + this.getRemoteIPAddress() + "\n";
        if (this.controlConnection.isSecured()) {
            SSLSession session = this.controlConnection.getSSLSession();
            connectionMessage = connectionMessage + "This is a secured FTP session \nProtocol: " + session.getProtocol() + "\n" + "Cipher Suite: " + session.getCipherSuite() + "\n" + "Data Channel Encryption: " + (this.isDataChannelUnencrypted() ? "OFF" : "ON") + "\n";
        }
        this.fireConnectionOpened(new FTPConnectionEvent(this, connectionMessage));
        this.setType(1);
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public synchronized RemoteFile setWorkingDirectory(RemoteFile dir) throws FTPException, ConnectionException {
        this.executeCommand("CWD " + dir.getNormalizedPath());
        this.executeCommand("PWD");
        this.workingDirectory = this.listParser.createRemoteFile(FTPUtil.parsePath(this.reply));
        return this.workingDirectory;
    }

    public synchronized RemoteFile setToParentDirectory() throws FTPException, ConnectionException {
        this.executeCommand("CDUP");
        this.executeCommand("PWD");
        this.workingDirectory = this.listParser.createRemoteFile(FTPUtil.parsePath(this.reply));
        return this.workingDirectory;
    }

    public synchronized RemoteFile getWorkingDirectory() throws FTPException, ConnectionException {
        if (this.workingDirectory == null) {
            this.executeCommand("PWD");
            this.workingDirectory = this.listParser.createRemoteFile(FTPUtil.parsePath(this.reply));
        }
        return this.workingDirectory;
    }

    public synchronized void setType(int type) throws FTPException, ConnectionException {
        if (this.type != type) {
            this.executeCommand("TYPE " + FTPUtil.getType(type));
            this.type = type;
        }
    }

    public int getType() {
        return this.type;
    }

    public synchronized void setStructure(int structure) throws FTPException, ConnectionException {
        if (this.structure != structure) {
            this.executeCommand("STRU " + FTPUtil.getStructure(structure));
            this.structure = structure;
        }
    }

    public int getStructure() {
        return this.structure;
    }

    public synchronized void setMode(int mode) throws FTPException, ConnectionException {
        if (this.mode != mode) {
            this.executeCommand("MODE " + FTPUtil.getMode(mode));
            this.mode = mode;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public synchronized void createDirectory(RemoteFile dir) throws FTPException, ConnectionException {
        this.executeCommand("MKD " + dir.getPath());
    }

    public synchronized void deleteDirectory(RemoteFile dir) throws FTPException, ConnectionException {
        this.executeCommand("RMD " + dir.getPath());
    }

    public synchronized void deleteFile(RemoteFile file) throws FTPException, ConnectionException {
        this.executeCommand("DELE " + file.getPath());
    }

    public synchronized void delete(RemoteFile path) throws FTPException, ConnectionException {
        if (path.isFile()) {
            this.deleteFile(path);
        } else {
            this.deleteDirectory(path);
        }
    }

    public synchronized void rename(RemoteFile from, RemoteFile to) throws FTPException, ConnectionException {
        this.executeCommand("RNFR " + from.getPath());
        this.executeCommand("RNTO " + to.getPath());
    }

    public synchronized void noop() throws FTPException, ConnectionException {
        this.executeCommand("NOOP");
    }

    public void abort() throws FTPException, ConnectionException {
        if (this.dataConnection != null) {
            this.dataConnection.abort();
        }
    }

    public synchronized void reinitialize() throws FTPException, ConnectionException {
        this.executeCommand("REIN");
        this.loggedIn = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws FTPException, ConnectionException {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.abort();
            }
            if (this.controlConnection != null) {
                this.executeCommand("QUIT");
                this.controlConnection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.connected = false;
            this.loggedIn = false;
            this.controlConnection = null;
            this.dataConnection = null;
            this.fireConnectionClosed(new FTPConnectionEvent(this, "Connection Closed. "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.abort();
            }
            if (this.controlConnection != null) {
                this.controlConnection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.connected = false;
            this.loggedIn = false;
            this.controlConnection = null;
            this.dataConnection = null;
            this.fireConnectionClosed(new FTPConnectionEvent(this, "Connection Closed. "));
        }
    }

    public synchronized void allocate(long bytes) throws FTPException, ConnectionException {
        this.executeCommand("ALLO " + bytes);
    }

    public synchronized void restart(long bytes) throws FTPException, ConnectionException {
        this.executeCommand("REST " + bytes);
    }

    public synchronized String getSystemInfo() throws FTPException, ConnectionException {
        return this.executeCommand("SYST");
    }

    public synchronized String getHelp() throws FTPException, ConnectionException {
        return this.executeCommand("HELP");
    }

    public synchronized void setSiteParameter(String param) throws FTPException, ConnectionException {
        this.executeCommand("SITE " + param);
    }

    public synchronized void mountStructure(String path) throws FTPException, ConnectionException {
        this.executeCommand("SMNT " + path);
    }

    public synchronized String executeCommand(String command) throws FTPException, ConnectionException {
        try {
            this.reply = this.controlConnection.executeCommand(command);
        }
        catch (ConnectionException exp) {
            this.close();
            throw exp;
        }
        if (this.reply.charAt(0) == '5' || this.reply.charAt(0) == '4') {
            throw new FTPException(this.reply);
        }
        return this.reply;
    }

    public InetAddress getRemoteAddress() {
        return this.controlConnection.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this.controlConnection.getRemoteHost();
    }

    public String getRemoteIPAddress() {
        return this.controlConnection.getRemoteIPAddress();
    }

    public int getRemotePort() {
        return this.controlConnection.getRemotePort();
    }

    public InetAddress getLocalAddress() {
        return this.controlConnection.getLocalAddress();
    }

    public String getLocalHost() {
        return this.controlConnection.getLocalHost();
    }

    public String getLocalIPAddress() {
        return this.controlConnection.getLocalIPAddress();
    }

    public int getLocalPort() {
        return this.controlConnection.getLocalPort();
    }

    public synchronized RemoteFile[] list() throws FTPException, ParseException, ConnectionException {
        this.setType(1);
        this.dataConnection = this.sslUsage == 0 || this.dataChannelUnencrypted ? new DataConnection(this) : new SSLDataConnection(this);
        if (this.passive) {
            this.executeCommand("PASV");
            String ip = FTPUtil.parseAddress(this.reply);
            int port = FTPUtil.parsePort(this.reply);
            this.dataConnection.connect(ip, port);
            this.executeCommand("LIST");
        } else {
            int port = this.dataConnection.bind();
            String portCommand = FTPUtil.getPortCommand(this.getLocalIPAddress(), port);
            this.executeCommand(portCommand);
            this.executeCommand("LIST");
            this.dataConnection.accept();
        }
        try {
            RemoteFile[] list = this.dataConnection.list(this.workingDirectory);
            this.reply = this.controlConnection.getReply();
            this.dataConnection = null;
            if (this.reply.charAt(0) == '5' || this.reply.charAt(0) == '\u0004') {
                throw new FTPException(this.reply);
            }
            return list;
        }
        catch (ParseException exp) {
            if (this.controlConnection != null) {
                this.reply = this.controlConnection.getReply();
            }
            this.dataConnection = null;
            throw exp;
        }
    }

    public synchronized RemoteFile[] list(Filter filter) throws FTPException, ParseException, ConnectionException {
        if (filter == null) {
            return this.list();
        }
        RemoteFile[] f = this.list();
        if (f == null) {
            return null;
        }
        ArrayList<RemoteFile> list = new ArrayList<RemoteFile>(f.length);
        for (int i = 0; i < f.length; ++i) {
            if (!filter.accept(f[i])) continue;
            list.add(f[i]);
        }
        RemoteFile[] children = new RemoteFile[list.size()];
        children = list.toArray(children);
        return children;
    }

    public synchronized RemoteFile[] list(RemoteFile dir) throws FTPException, ParseException, ConnectionException {
        return null;
    }

    public synchronized RemoteFile[] list(RemoteFile dir, Filter filter) throws FTPException, ParseException, ConnectionException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createFile(RemoteFile file) throws FTPException, ConnectionException {
        this.dataConnection = this.sslUsage == 0 || this.dataChannelUnencrypted ? new DataConnection(this) : new SSLDataConnection(this);
        try {
            if (this.passive) {
                this.executeCommand("PASV");
                String ip = FTPUtil.parseAddress(this.reply);
                int port = FTPUtil.parsePort(this.reply);
                this.dataConnection.connect(ip, port);
                this.executeCommand("STOR " + file.getPath());
            } else {
                int port = this.dataConnection.bind();
                String portCommand = FTPUtil.getPortCommand(this.getLocalIPAddress(), port);
                this.executeCommand(portCommand);
                this.executeCommand("STOR " + file.getPath());
                this.dataConnection.accept();
            }
            this.dataConnection.close();
            this.reply = this.controlConnection.getReply();
        }
        finally {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
            this.dataConnection = null;
            if (this.reply.charAt(0) == '5' || this.reply.charAt(0) == '\u0004') {
                throw new FTPException(this.reply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void download(RemoteFile source, File destination, int type, boolean append) throws FTPException, ConnectionException {
        this.setType(type);
        this.dataConnection = this.sslUsage == 0 || this.dataChannelUnencrypted ? new DataConnection(this) : new SSLDataConnection(this);
        boolean ftpException = true;
        String ioException = null;
        try {
            if (this.passive) {
                this.executeCommand("PASV");
                String ip = FTPUtil.parseAddress(this.reply);
                int port = FTPUtil.parsePort(this.reply);
                this.dataConnection.connect(ip, port);
                this.executeCommand("RETR " + source.getNormalizedPath());
            } else {
                int port = this.dataConnection.bind();
                String portCommand = FTPUtil.getPortCommand(this.getLocalIPAddress(), port);
                this.executeCommand(portCommand);
                this.executeCommand("RETR " + source.getNormalizedPath());
                this.dataConnection.accept();
            }
            ftpException = false;
            try {
                this.dataConnection.download(destination, append);
            }
            catch (IOException exp) {
                ioException = exp.getMessage();
            }
            Object var10_12 = null;
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
            this.dataConnection = null;
            if (ftpException || this.controlConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
            this.dataConnection = null;
            if (ftpException || this.controlConnection == null) throw throwable;
            this.reply = this.controlConnection.getReply();
            if (ioException != null) {
                throw new FTPException("599 " + ioException);
            }
            if (this.reply.charAt(0) != '5' && this.reply.charAt(0) != '4') throw throwable;
            throw new FTPException(this.reply);
        }
        this.reply = this.controlConnection.getReply();
        if (ioException != null) {
            throw new FTPException("599 " + ioException);
        }
        if (this.reply.charAt(0) != '5' && this.reply.charAt(0) != '4') return;
        throw new FTPException(this.reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void upload(File source, RemoteFile destination, int type, boolean append, long skip) throws FTPException, ConnectionException {
        this.setType(type);
        this.dataConnection = this.sslUsage == 0 || this.dataChannelUnencrypted ? new DataConnection(this) : new SSLDataConnection(this);
        boolean ftpException = true;
        String ioException = null;
        try {
            if (this.passive) {
                this.reply = this.executeCommand("PASV");
                String ip = FTPUtil.parseAddress(this.reply);
                int port = FTPUtil.parsePort(this.reply);
                this.dataConnection.connect(ip, port);
                String command = append ? "APPE " : "STOR ";
                this.executeCommand(command + destination.getPath());
            } else {
                int port = this.dataConnection.bind();
                String portCommand = FTPUtil.getPortCommand(this.getLocalIPAddress(), port);
                this.executeCommand(portCommand);
                String command = append ? "APPE " : "STOR ";
                this.executeCommand(command + destination.getPath());
                this.dataConnection.accept();
            }
            ftpException = false;
            try {
                this.dataConnection.upload(source, skip);
            }
            catch (IOException exp) {
                ioException = exp.getMessage();
            }
            Object var13_15 = null;
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
            this.dataConnection = null;
            if (ftpException || this.controlConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
            this.dataConnection = null;
            if (ftpException || this.controlConnection == null) throw throwable;
            this.reply = this.controlConnection.getReply();
            if (ioException != null) {
                throw new FTPException("599 " + ioException);
            }
            if (this.reply.charAt(0) != '5' && this.reply.charAt(1) != '4') throw throwable;
            throw new FTPException(this.reply);
        }
        this.reply = this.controlConnection.getReply();
        if (ioException != null) {
            throw new FTPException("599 " + ioException);
        }
        if (this.reply.charAt(0) != '5' && this.reply.charAt(1) != '4') return;
        throw new FTPException(this.reply);
    }

    public void addControlConnectionListener(ControlConnectionListener l) {
        this.listenerList.add(ControlConnectionListener.class, l);
    }

    public void removeControlConnectionListener(ControlConnectionListener l) {
        this.listenerList.remove(ControlConnectionListener.class, l);
    }

    public void addDataConnectionListener(DataConnectionListener l) {
        this.listenerList.add(DataConnectionListener.class, l);
    }

    public void removeDataConnectionListener(DataConnectionListener l) {
        this.listenerList.remove(DataConnectionListener.class, l);
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void addFTPConnectionListener(FTPConnectionListener l) {
        this.listenerList.add(FTPConnectionListener.class, l);
    }

    public void removeFTPConnectionListener(FTPConnectionListener l) {
        this.listenerList.remove(FTPConnectionListener.class, l);
    }

    public void setPassiveIPSubstitutionEnabled(boolean enable) {
        this.passiveIPSubstitutionEnabled = enable;
    }

    public boolean isPassiveIPSubstitutionEnabled() {
        return this.passiveIPSubstitutionEnabled;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected void fireConnectionOpened(FTPConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FTPConnectionListener.class) continue;
            ((FTPConnectionListener)listeners[i + 1]).connectionOpened(evt);
        }
    }

    protected void fireConnectionClosed(FTPConnectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FTPConnectionListener.class) continue;
            ((FTPConnectionListener)listeners[i + 1]).connectionClosed(evt);
        }
    }
}

