/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.DefaultRemoteFile;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DefaultListParser
implements ListParser {
    private static final int CURRENT_YEAR;
    private final SimpleDateFormat unixDateFormat = new SimpleDateFormat("MMM dd yyyy hh:mm", Locale.US);
    private static final long MILLIS_IN_YEAR;

    public RemoteFile[] parse(RemoteFile parent, BufferedReader reader) throws ParseException, IOException {
        RemoteFile[] list = new RemoteFile[]{};
        ArrayList<RemoteFile> l = new ArrayList<RemoteFile>(50);
        String line = null;
        line = reader.readLine();
        if (line != null && line.trim().length() > 0 && !line.trim().toLowerCase().startsWith("total")) {
            l.add(this.parse(parent, line));
        }
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            l.add(this.parse(parent, line));
        }
        list = new RemoteFile[l.size()];
        list = l.toArray(list);
        return list;
    }

    public RemoteFile parse(RemoteFile parent, String line) throws ParseException {
        String rawData = line;
        try {
            int spaceIndex = rawData.indexOf(32);
            String attributes = rawData.substring(0, spaceIndex);
            boolean dir = attributes.charAt(0) == 'd';
            int linkCount = 0;
            boolean gotLinkCount = false;
            if (attributes.length() > 10 && attributes.length() != 11) {
                char ch = attributes.charAt(10);
                if (Character.isDigit(ch)) {
                    linkCount = Integer.parseInt(attributes.substring(10));
                    attributes = attributes.substring(0, 10);
                } else {
                    linkCount = Integer.parseInt(attributes.substring(11));
                    attributes = attributes.substring(0, 11);
                }
                gotLinkCount = true;
            }
            rawData = rawData.substring(spaceIndex).trim();
            if (!gotLinkCount) {
                spaceIndex = rawData.indexOf(32);
                linkCount = Integer.parseInt(rawData.substring(0, spaceIndex));
                rawData = rawData.substring(spaceIndex).trim();
            }
            spaceIndex = rawData.indexOf(32);
            String owner = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String group = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            long size = Long.parseLong(rawData.substring(0, spaceIndex));
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String month = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String date = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String year = rawData.substring(0, spaceIndex);
            String name = rawData = rawData.substring(spaceIndex).trim();
            return new DefaultRemoteFile(parent.getPath(), name, dir, size, this.parseDate(month, date, year), attributes, linkCount, owner, group);
        }
        catch (Exception exp) {
            throw new ParseException(line, 0);
        }
    }

    public RemoteFile createRemoteFile(String path) {
        return this.createRemoteFile(path, true);
    }

    public RemoteFile createRemoteFile(String path, boolean dir) {
        return new DefaultRemoteFile(path, dir);
    }

    public RemoteFile createRemoteFile(String parent, String name) {
        return this.createRemoteFile(parent, name, true);
    }

    public RemoteFile createRemoteFile(String parent, String name, boolean dir) {
        return new DefaultRemoteFile(parent, name, dir);
    }

    public RemoteFile createRemoteFile(RemoteFile parent, String name) {
        return this.createRemoteFile(parent.getPath(), name, true);
    }

    public RemoteFile createRemoteFile(RemoteFile parent, String name, boolean dir) {
        return this.createRemoteFile(parent.getPath(), name, dir);
    }

    public String getName() {
        return "Default List Parser";
    }

    public String getDescription() {
        return "Parses standard UNIX style listing. ";
    }

    public String getVendor() {
        return "MyJavaWorld.com";
    }

    public String getVersion() {
        return "1.0";
    }

    private long parseDate(String month, String date, String year) throws ParseException {
        long millis = 0L;
        if (year.indexOf(58) >= 0) {
            millis = this.unixDateFormat.parse(month + " " + date + " " + CURRENT_YEAR + " " + year).getTime();
            if (millis - System.currentTimeMillis() > 0L) {
                millis -= MILLIS_IN_YEAR;
            }
        } else {
            millis = this.unixDateFormat.parse(month + " " + date + " " + year + " 00:00").getTime();
        }
        return millis;
    }

    public static void main(String[] args) throws ParseException {
        DefaultListParser parser = new DefaultListParser();
        RemoteFile parent = parser.createRemoteFile("/");
        RemoteFile file = parser.parse(parent, "drwxrwxrwx+ 329    root  analysts  9216  Sep 8 18:00   backup");
        System.out.println(file.getName() + "\t" + file.getLinkCount() + "\t" + file.getGroup() + "\t" + file.getOwner() + "\t" + file.getSize() + "\t" + new Date(file.getLastModified()) + "\t" + file.getAttributes());
    }

    static {
        GregorianCalendar gc = new GregorianCalendar();
        CURRENT_YEAR = Calendar.getInstance().get(1);
        MILLIS_IN_YEAR = gc.isLeapYear(CURRENT_YEAR) ? 31622400000L : 31536000000L;
    }
}

