/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.RemoteFile;
import java.io.Serializable;
import java.util.Hashtable;

public class DefaultRemoteFile
implements RemoteFile,
Serializable {
    private static final long serialVersionUID = 924667277483346705L;
    private static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = '/';
    private String path = null;
    private String name = null;
    private String extension = null;
    private long size = 0L;
    private long lastModified = 0L;
    private boolean dir = true;
    private String attributes = null;
    private int linkCount = 0;
    private String owner = null;
    private String group = null;

    public DefaultRemoteFile(String path) {
        this(path, true);
    }

    public DefaultRemoteFile(String path, boolean dir) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.dir = dir;
        this.attributes = "";
        this.name = this.computeName();
        this.extension = this.computeExtension();
    }

    public DefaultRemoteFile(String parent, String name) {
        this(parent, name, true);
    }

    public DefaultRemoteFile(String parent, String name, boolean dir) {
        this(parent, name, dir, 0L, 0L, "");
    }

    public DefaultRemoteFile(String parent, String name, boolean dir, long size, long lastModified, String attributes) {
        this(parent, name, dir, size, lastModified, attributes, 0, "", "");
    }

    public DefaultRemoteFile(String parent, String name, boolean dir, long size, long lastModified, String attributes, int linkCount, String owner, String group) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? (parent.endsWith(SEPARATOR) ? parent + name : parent + SEPARATOR + name) : name;
        this.dir = dir;
        this.size = size;
        this.lastModified = lastModified;
        this.attributes = attributes;
        this.linkCount = linkCount;
        this.owner = owner;
        this.group = group;
        this.name = this.computeName();
        this.extension = this.computeExtension();
    }

    public String getPath() {
        return this.path;
    }

    public String getNormalizedPath() {
        if (this.isLink()) {
            int index = this.path.indexOf(" -> ");
            if (index < 0) {
                return this.path;
            }
            return this.path.substring(0, index);
        }
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        if (this.isLink()) {
            int index = this.name.indexOf(" -> ");
            if (index < 0) {
                return this.name;
            }
            return this.name.substring(0, index);
        }
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getType() {
        if (this.extension == null) {
            return "Directory";
        }
        if (this.isLink()) {
            return "Link";
        }
        if (this.extension.length() == 0) {
            return "File";
        }
        return this.extension + " File";
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isDirectory() {
        return this.dir;
    }

    public boolean isFile() {
        return !this.dir;
    }

    public boolean isLink() {
        try {
            return this.attributes.charAt(0) == 'l';
        }
        catch (Exception exp) {
            return false;
        }
    }

    public String getAttributes() {
        return this.attributes;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return this.path;
    }

    public Hashtable getOtherProperties() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultRemoteFile)) {
            return false;
        }
        DefaultRemoteFile that = (DefaultRemoteFile)obj;
        return this.path.equals(that.path);
    }

    private String computeName() {
        if (this.isLink()) {
            int linkIndex = this.path.indexOf(" -> ");
            String beforeLink = this.path.substring(0, linkIndex);
            String afterLink = this.path.substring(linkIndex + 4);
            int index = beforeLink.lastIndexOf(47);
            if (index < 0 || beforeLink.endsWith(SEPARATOR)) {
                return beforeLink + " -> " + afterLink;
            }
            return beforeLink.substring(index + 1) + " -> " + afterLink;
        }
        int index = this.path.lastIndexOf(47);
        if (index < 0 || this.path.endsWith(SEPARATOR)) {
            return this.path;
        }
        return this.path.substring(index + 1);
    }

    private String computeExtension() {
        if (this.dir) {
            return null;
        }
        int index = this.name.lastIndexOf(46);
        if (index < 0 || this.name.endsWith(".")) {
            return "";
        }
        return this.name.substring(index + 1).toUpperCase();
    }
}

