/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.DefaultRemoteFile;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DosListParser
implements ListParser {
    private final SimpleDateFormat dosDateFormat = new SimpleDateFormat("MM-dd-yy hh:mma", Locale.US);

    public RemoteFile[] parse(RemoteFile parent, BufferedReader reader) throws ParseException, IOException {
        RemoteFile[] list = new RemoteFile[]{};
        ArrayList<RemoteFile> l = new ArrayList<RemoteFile>(50);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            l.add(this.parse(parent, line));
        }
        list = new RemoteFile[l.size()];
        list = l.toArray(list);
        return list;
    }

    public RemoteFile parse(RemoteFile parent, String rawData) throws ParseException {
        try {
            int spaceIndex = rawData.indexOf(32);
            String date = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String time = rawData.substring(0, spaceIndex);
            rawData = rawData.substring(spaceIndex).trim();
            spaceIndex = rawData.indexOf(32);
            String temp = rawData.substring(0, spaceIndex);
            boolean dir = false;
            long size = 0L;
            if (temp.equals("<DIR>")) {
                dir = true;
            } else {
                size = Long.parseLong(temp);
            }
            String name = rawData = rawData.substring(spaceIndex).trim();
            return new DefaultRemoteFile(parent.getPath(), name, dir, size, this.parseDate(date + " " + time), "");
        }
        catch (Exception exp) {
            throw new ParseException(exp.toString(), 0);
        }
    }

    public RemoteFile createRemoteFile(String path) {
        return this.createRemoteFile(path, true);
    }

    public RemoteFile createRemoteFile(String path, boolean dir) {
        return new DefaultRemoteFile(path, dir);
    }

    public RemoteFile createRemoteFile(String parent, String name) {
        return this.createRemoteFile(parent, name, true);
    }

    public RemoteFile createRemoteFile(String parent, String name, boolean dir) {
        return new DefaultRemoteFile(parent, name, dir);
    }

    public RemoteFile createRemoteFile(RemoteFile parent, String name) {
        return this.createRemoteFile(parent.getPath(), name, true);
    }

    public RemoteFile createRemoteFile(RemoteFile parent, String name, boolean dir) {
        return this.createRemoteFile(parent.getPath(), name, dir);
    }

    public String getName() {
        return "MS-DOS List Parser";
    }

    public String getDescription() {
        return "Parses MS-DOS style listing. ";
    }

    public String getVendor() {
        return "MyJavaWorld.com";
    }

    public String getVersion() {
        return "1.0";
    }

    private long parseDate(String date) throws ParseException {
        return this.dosDateFormat.parse(date).getTime();
    }
}

