/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnection;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConstants;
import com.myjavaworld.ftp.FTPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ExplicitSSLControlConnection
extends ControlConnection
implements FTPConstants {
    public ExplicitSSLControlConnection(FTPClient client) {
        super(client);
    }

    public void connect(String host, int port) throws ConnectionException, FTPException {
        super.connect(host, port);
        if (this.client.getSSLUsage() == 3) {
            this.sslConnect(host, port);
        } else if (this.client.getSSLUsage() == 1) {
            this.sslConnectIfAvailable(host, port);
        }
    }

    private void sslConnect(String host, int port) throws ConnectionException, FTPException {
        String reply = this.executeCommand("AUTH " + this.client.getExplicitSSLProtocol());
        if (reply.charAt(0) != '2') {
            throw new FTPException(reply);
        }
        SSLContext ctx = this.client.getSSLContext();
        SSLSocketFactory factory = ctx.getSocketFactory();
        try {
            this.socket = factory.createSocket(this.socket, host, port, true);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintStream(this.socket.getOutputStream(), true);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        reply = this.executeCommand("PBSZ 0");
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
        reply = this.executeCommand("PROT " + (this.client.isDataChannelUnencrypted() ? "C" : "P"));
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
    }

    private void sslConnectIfAvailable(String host, int port) throws ConnectionException, FTPException {
        String reply = this.executeCommand("AUTH " + this.client.getExplicitSSLProtocol());
        if (reply.charAt(0) != '2') {
            this.client.setDataChannelUnencrypted(true);
            return;
        }
        SSLContext ctx = this.client.getSSLContext();
        SSLSocketFactory factory = ctx.getSocketFactory();
        try {
            this.socket = factory.createSocket(this.socket, host, port, true);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintStream(this.socket.getOutputStream(), true);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        reply = this.executeCommand("PBSZ 0");
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
        reply = this.executeCommand("PROT " + (this.client.isDataChannelUnencrypted() ? "C" : "P"));
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
    }
}

