/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPUtil {
    public static final String[] TYPES = new String[]{"A", "I", "E"};
    public static final String[] TYPE_NAMES = new String[]{"ASCII", "Binary", "EBCDIC"};
    public static final String[] STRUCTURES = new String[]{"F", "R", "P"};
    public static final String[] MODES = new String[]{"S", "B", "C"};

    public static String getType(int type) {
        return TYPES[type - 1];
    }

    public static String getStructure(int structure) {
        return STRUCTURES[structure - 1];
    }

    public static String getMode(int mode) {
        return MODES[mode - 1];
    }

    public static String parsePath(String reply) {
        int index1 = reply.indexOf(34);
        int index2 = reply.lastIndexOf(34);
        if (index1 < 0 || index2 < 0 || index1 == index2) {
            return null;
        }
        String path = reply.substring(index1 + 1, index2);
        return path;
    }

    public static String parseAddress(String reply) {
        String[] tokens = FTPUtil.parsePassiveCommandReply(reply);
        return tokens[0] + "." + tokens[1] + "." + tokens[2] + "." + tokens[3];
    }

    public static int parsePort(String reply) {
        String[] tokens = FTPUtil.parsePassiveCommandReply(reply);
        int port = (Integer.parseInt(tokens[4]) << 8) + Integer.parseInt(tokens[5]);
        return port;
    }

    private static String[] parsePassiveCommandReply(String reply) {
        int index1 = reply.indexOf("(");
        int index2 = reply.indexOf(")", index1 + 1);
        if (index1 < 0 || index2 < 0) {
            return null;
        }
        reply = reply.substring(index1 + 1, index2);
        return reply.split(",");
    }

    public static String getPortCommand(String ip, int port) {
        String command = "PORT " + ip.replace('.', ',') + "," + (port >> 8) + "," + (port & 0xFF);
        return command;
    }

    public static String parseAttributes(String attributes) {
        int ownerPermissions = 0;
        ownerPermissions += attributes.charAt(0) == 'r' ? 4 : 0;
        ownerPermissions += attributes.charAt(1) == 'w' ? 2 : 0;
        ownerPermissions += attributes.charAt(2) == 'x' ? 1 : 0;
        int groupPermissions = 0;
        groupPermissions += attributes.charAt(3) == 'r' ? 4 : 0;
        groupPermissions += attributes.charAt(4) == 'w' ? 2 : 0;
        int publicPermissions = 0;
        publicPermissions += attributes.charAt(6) == 'r' ? 4 : 0;
        publicPermissions += attributes.charAt(7) == 'w' ? 2 : 0;
        return String.valueOf(ownerPermissions) + String.valueOf(groupPermissions += attributes.charAt(5) == 'x' ? 1 : 0) + String.valueOf(publicPermissions += attributes.charAt(8) == 'x' ? 1 : 0);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

