/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnection;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConstants;
import com.myjavaworld.ftp.FTPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ImplicitSSLControlConnection
extends ControlConnection
implements FTPConstants {
    public ImplicitSSLControlConnection(FTPClient client) {
        super(client);
        this.stdout("Implicit Control Connection");
    }

    public void connect(String host, int port) throws ConnectionException, FTPException {
        try {
            SSLContext ctx = this.client.getSSLContext();
            SSLSocketFactory factory = ctx.getSocketFactory();
            this.socket = factory.createSocket(host, port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintStream(this.socket.getOutputStream(), true);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (NoRouteToHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (SocketException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (Exception exp) {
            throw new ConnectionException(exp.toString());
        }
        try {
            this.socket.setSoTimeout(this.client.getTimeout());
        }
        catch (SocketException exp) {
            this.stderr("Could not set timeout for the socket. Original exception below. \n" + exp.getMessage());
        }
        String reply = this.getReply();
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
        reply = this.executeCommand("PBSZ 0");
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
        reply = this.executeCommand("PROT " + (this.client.isDataChannelUnencrypted() ? "C" : "P"));
        if (reply.charAt(0) == '5' || reply.charAt(0) == '4') {
            throw new FTPException(reply);
        }
    }
}

