/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.util.DateFilter;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.RegexFilter;

public class RemoteFileFilter
implements Filter {
    private RegexFilter regexFilter = null;
    private DateFilter dateFilter = null;
    private boolean exclusionFilter = false;

    public RemoteFileFilter(RegexFilter regexFilter, DateFilter dateFilter) {
        this(regexFilter, dateFilter, false);
    }

    public RemoteFileFilter(RegexFilter regexFilter, DateFilter dateFilter, boolean exclusionFilter) {
        this.setRegexFilter(regexFilter);
        this.setDateFilter(dateFilter);
        this.exclusionFilter = exclusionFilter;
    }

    public DateFilter getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(DateFilter dateFilter) {
        this.dateFilter = dateFilter;
    }

    public RegexFilter getRegexFilter() {
        return this.regexFilter;
    }

    public void setRegexFilter(RegexFilter regexFilter) {
        this.regexFilter = regexFilter;
    }

    public void setExclusionFilter(boolean exclusionFilter) {
        this.exclusionFilter = exclusionFilter;
    }

    public boolean isExclusionFilter() {
        return this.exclusionFilter;
    }

    public boolean accept(Object obj) {
        RemoteFile rf = (RemoteFile)obj;
        if (rf.isFile()) {
            if (this.regexFilter != null && !this.regexFilter.accept(rf.getName())) {
                return this.exclusionFilter;
            }
            if (this.dateFilter != null && !this.dateFilter.accept(new Long(rf.getLastModified()))) {
                return this.exclusionFilter;
            }
            return !this.exclusionFilter;
        }
        return true;
    }
}

