/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.DataConnection;
import com.myjavaworld.ftp.FTPClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLDataConnection
extends DataConnection {
    public SSLDataConnection(FTPClient client) {
        super(client);
    }

    public synchronized int bind() throws ConnectionException {
        try {
            SSLContext ctx = this.client.getSSLContext();
            SSLServerSocketFactory factory = ctx.getServerSocketFactory();
            this.server = factory.createServerSocket(0, 0, this.client.getLocalAddress());
            ((SSLServerSocket)this.server).setUseClientMode(true);
            return this.server.getLocalPort();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public synchronized void accept() throws ConnectionException {
        try {
            this.server.setSoTimeout(this.client.getTimeout());
        }
        catch (SocketException exp) {
            // empty catch block
        }
        try {
            this.socket = this.server.accept();
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
        try {
            this.socket.setSoTimeout(this.client.getTimeout());
        }
        catch (SocketException exp) {
            // empty catch block
        }
        try {
            this.socket.setSendBufferSize(this.client.getBufferSize());
            this.socket.setReceiveBufferSize(this.client.getBufferSize());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public synchronized void connect(String ipAddress, int port) throws ConnectionException {
        try {
            if (this.client.isPassiveIPSubstitutionEnabled()) {
                this.connect(this.client.getRemoteAddress(), port);
            } else {
                this.connect(InetAddress.getByName(ipAddress), port);
            }
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
    }

    public synchronized void connect(InetAddress address, int port) throws ConnectionException {
        try {
            SSLContext ctx = this.client.getSSLContext();
            SSLSocketFactory factory = ctx.getSocketFactory();
            this.socket = factory.createSocket(address, port);
            try {
                this.socket.setSoTimeout(this.client.getTimeout());
            }
            catch (SocketException exp) {
                // empty catch block
            }
            try {
                this.socket.setSendBufferSize(this.client.getBufferSize());
                this.socket.setReceiveBufferSize(this.client.getBufferSize());
            }
            catch (SocketException exp) {}
        }
        catch (UnknownHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (NoRouteToHostException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (SocketException exp) {
            throw new ConnectionException(exp.toString());
        }
        catch (IOException exp) {
            throw new ConnectionException(exp.toString());
        }
    }
}

