/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp.examples;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnectionEvent;
import com.myjavaworld.ftp.ControlConnectionListener;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConnectionEvent;
import com.myjavaworld.ftp.FTPConnectionListener;
import com.myjavaworld.ftp.FTPException;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DirList {
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance();

    public static void main(String[] args) throws InstantiationException, ClassNotFoundException, IllegalAccessException, FTPException, ParseException, ConnectionException {
        String ftpClientClassName = "com.myjavaworld.ftp.DefaultFTPClient";
        String listParserClassName = "com.myjavaworld.ftp.DefaultListParser";
        FTPClient client = (FTPClient)Class.forName(ftpClientClassName).newInstance();
        ListParser parser = (ListParser)Class.forName(listParserClassName).newInstance();
        client.setListParser(parser);
        client.addFTPConnectionListener(new FTPConnectionListener(){

            public void connectionOpened(FTPConnectionEvent evt) {
                System.out.println(evt.getMessage());
            }

            public void connectionClosed(FTPConnectionEvent evt) {
                System.out.println(evt.getMessage());
            }
        });
        client.addControlConnectionListener(new ControlConnectionListener(){

            public void commandSent(ControlConnectionEvent evt) {
                System.out.println(evt.getMessage());
            }

            public void replyReceived(ControlConnectionEvent evt) {
                System.out.println(evt.getMessage());
            }
        });
        client.setPassive(true);
        client.connect("ftp.netscape.com");
        client.login("anonymous", "you@yourcompany.com");
        RemoteFile workingDirectory = client.getWorkingDirectory();
        DirList.list(client);
        client.setWorkingDirectory(parser.createRemoteFile(workingDirectory, "pub", true));
        DirList.list(client);
        client.disconnect();
    }

    private static void list(FTPClient client) throws FTPException, ParseException, ConnectionException {
        RemoteFile[] children = client.list();
        for (int i = 0; i < children.length; ++i) {
            System.out.println(children[i].getAttributes() + "\t" + (children[i].isDirectory() ? "<DIR>" : "<FILE>") + "\t" + children[i].getSize() + "\t" + dateFormat.format(new Date(children[i].getLastModified())) + "\t" + children[i].getName());
        }
    }
}

