/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.ftp.examples;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnectionEvent;
import com.myjavaworld.ftp.ControlConnectionListener;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPException;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import java.io.File;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;

public class SSLDownload {
    public static void main(String[] args) throws InstantiationException, ClassNotFoundException, IllegalAccessException, FTPException, ConnectionException {
        String className = "com.myjavaworld.ftp.DefaultFTPClient";
        String hostName = "hostname_or_ipaddress";
        String user = "login_name";
        String password = "password";
        FTPClient client = (FTPClient)Class.forName("com.myjavaworld.ftp.DefaultFTPClient").newInstance();
        client.addControlConnectionListener(new ControlConnectionListener(){

            public void commandSent(ControlConnectionEvent evt) {
                System.out.println("Command    " + evt.getMessage());
            }

            public void replyReceived(ControlConnectionEvent evt) {
                System.out.println("Reply      " + evt.getMessage());
            }
        });
        ListParser parser = (ListParser)Class.forName("com.myjavaworld.ftp.DefaultListParser").newInstance();
        client.setListParser(parser);
        client.setSSLUsage(3);
        client.setSSLContext(SSLDownload.createSSLContext());
        System.out.println("Connecting...");
        client.connect("hostname_or_ipaddress");
        System.out.println("Connected. ");
        System.out.println("Logging in...");
        client.login("login_name", "password");
        System.out.println("Logged in. ");
        RemoteFile source = parser.createRemoteFile("/remote/test.txt", false);
        File destination = new File("/local/test.txt");
        System.out.println("Downloading: " + source);
        client.download(source, destination, 1, false);
        System.out.println("Done. ");
        System.out.println("Disconnecting...");
        client.disconnect();
        System.out.println("Disconnected. ");
    }

    private static SSLContext createSSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, null, new SecureRandom());
            return context;
        }
        catch (KeyManagementException e) {
            System.err.println("Failed to initialize SSLContext");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Failed to initialize SSLContext");
            e.printStackTrace();
        }
        return null;
    }
}

