/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.gui.MPopupMenu;
import com.myjavaworld.gui.MTextComponent;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class EditPopupMenu
extends MPopupMenu
implements ActionListener {
    private static EditPopupMenu instance = null;
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.gui.EditPopupMenu");
    private MTextComponent textComponent = null;
    private MMenuItem miUndo = null;
    private MMenuItem miRedo = null;
    private MMenuItem miCut = null;
    private MMenuItem miCopy = null;
    private MMenuItem miPaste = null;
    private MMenuItem miDelete = null;
    private MMenuItem miSelectAll = null;

    private EditPopupMenu() {
        this.initComponents();
    }

    public static synchronized EditPopupMenu getInstance() {
        if (instance == null) {
            instance = new EditPopupMenu();
        }
        return instance;
    }

    public void setTextComponent(MTextComponent textComponent) {
        this.textComponent = textComponent;
        this.miUndo.setEnabled(textComponent.canUndo());
        this.miRedo.setEnabled(textComponent.canRedo());
        this.miCut.setEnabled(textComponent.canCut());
        this.miCopy.setEnabled(textComponent.canCopy());
        this.miPaste.setEnabled(textComponent.canPaste());
        this.miDelete.setEnabled(textComponent.canDelete());
        this.miSelectAll.setEnabled(textComponent.canSelectAll());
    }

    public MTextComponent getTextCompoent() {
        return this.textComponent;
    }

    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof MTextComponent)) {
            throw new IllegalArgumentException("invoker must be an instance of MTextComponent");
        }
        this.setTextComponent((MTextComponent)((Object)invoker));
        super.show(invoker, x, y);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.textComponent == null) {
            return;
        }
        String command = evt.getActionCommand();
        if (command.equals("cmd.undo")) {
            this.textComponent.undo();
        } else if (command.equals("cmd.redo")) {
            this.textComponent.redo();
        } else if (command.equals("cmd.cut")) {
            this.textComponent.cut();
        } else if (command.equals("cmd.copy")) {
            this.textComponent.copy();
        } else if (command.equals("cmd.paste")) {
            this.textComponent.paste();
        } else if (command.equals("cmd.delete")) {
            this.textComponent.delete();
        } else if (command.equals("cmd.selectAll")) {
            this.textComponent.selectAll();
        }
    }

    private void initComponents() {
        this.miUndo = new MMenuItem(resources.getString("text.undo"));
        this.miUndo.setActionCommand("cmd.undo");
        this.miUndo.addActionListener(this);
        this.miRedo = new MMenuItem(resources.getString("text.redo"));
        this.miRedo.setActionCommand("cmd.redo");
        this.miRedo.addActionListener(this);
        this.miCut = new MMenuItem(resources.getString("text.cut"));
        this.miCut.setActionCommand("cmd.cut");
        this.miCut.addActionListener(this);
        this.miCopy = new MMenuItem(resources.getString("text.copy"));
        this.miCopy.setActionCommand("cmd.copy");
        this.miCopy.addActionListener(this);
        this.miPaste = new MMenuItem(resources.getString("text.paste"));
        this.miPaste.setActionCommand("cmd.paste");
        this.miPaste.addActionListener(this);
        this.miDelete = new MMenuItem(resources.getString("text.delete"));
        this.miDelete.setActionCommand("cmd.delete");
        this.miDelete.addActionListener(this);
        this.miSelectAll = new MMenuItem(resources.getString("text.selectAll"));
        this.miSelectAll.setActionCommand("cmd.selectAll");
        this.miSelectAll.addActionListener(this);
        this.add(this.miUndo);
        this.add(this.miRedo);
        this.addSeparator();
        this.add(this.miCut);
        this.add(this.miCopy);
        this.add(this.miPaste);
        this.add(this.miDelete);
        this.addSeparator();
        this.add(this.miSelectAll);
    }
}

