/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.SystemUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GUIUtil {
    public static final int ACCELERATOR_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static Point getCenterPointRelativeToScreen(Dimension size) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static boolean isSystemLookAndFeel() {
        String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        String currentLookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        return systemLookAndFeelClassName.equals(currentLookAndFeelClassName);
    }

    public static KeyStroke getHelpKeyStroke() {
        if (SystemUtil.isMac() && GUIUtil.isSystemLookAndFeel()) {
            return KeyStroke.getKeyStroke(47, ACCELERATOR_MASK + 1);
        }
        return KeyStroke.getKeyStroke(112, 0);
    }

    public static int getDeleteKey() {
        return SystemUtil.isMac() ? 8 : 127;
    }

    public static void showInformation(Component parent, String info) {
        GUIUtil.showInformation(parent, CommonResources.getString("title.info"), info, false);
    }

    public static void showInformation(Component parent, String info, boolean format) {
        GUIUtil.showInformation(parent, CommonResources.getString("title.info"), info, format);
    }

    public static void showInformation(Component parent, String title, String info) {
        GUIUtil.showInformation(parent, title, info, false);
    }

    public static void showInformation(Component parent, String title, String info, boolean format) {
        if (format) {
            info = GUIUtil.htmlFormat(info);
        }
        JOptionPane.showMessageDialog(parent, info, title, 1);
    }

    public static int showConfirmation(Component parent, String message) {
        return GUIUtil.showConfirmation(parent, CommonResources.getString("title.confirm"), message, false);
    }

    public static int showConfirmation(Component parent, String message, boolean format) {
        return GUIUtil.showConfirmation(parent, CommonResources.getString("title.confirm"), message, format);
    }

    public static int showConfirmation(Component parent, String title, String message) {
        return GUIUtil.showConfirmation(parent, title, message, false);
    }

    public static int showConfirmation(Component parent, String title, String message, boolean format) {
        if (format) {
            message = GUIUtil.htmlFormat(message);
        }
        return JOptionPane.showConfirmDialog(parent, message, title, 0, 3);
    }

    public static void showError(Component parent, String error) {
        GUIUtil.showError(parent, CommonResources.getString("title.error"), error, false);
    }

    public static void showError(Component parent, String title, String error) {
        GUIUtil.showError(parent, title, error, false);
    }

    public static void showError(Component parent, String title, String error, boolean format) {
        if (format) {
            error = GUIUtil.htmlFormat(error);
        }
        JOptionPane.showMessageDialog(parent, error, title, 0);
    }

    public static void showError(Component parent, Throwable t) {
        GUIUtil.showError(parent, CommonResources.getString("title.error"), t);
    }

    public static void showError(Component parent, String title, Throwable t) {
        MessageFormat mf = new MessageFormat(CommonResources.getString("error.exception"));
        GUIUtil.showError(parent, title, mf.format(new Object[]{t}), true);
        t.printStackTrace();
    }

    public static String htmlFormat(String input) {
        input = input.replaceAll("\n", "<br>");
        input = input.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        return "<html><body><table width=\"500\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>" + input + "</td></tr></table></body></html>";
    }
}

