/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ImageCellRenderer
extends JLabel
implements TableCellRenderer,
ListCellRenderer,
TreeCellRenderer {
    private static final Color TREE_SELECTION_FOREGROUND = UIManager.getColor("Tree.selectionForeground");
    private static final Color TREE_SELECTION_BACKGROUND = UIManager.getColor("Tree.selectionBackground");
    private static final Color TREE_BACKGROUND = UIManager.getColor("Tree.textBackground");
    private static final Color TREE_FOREGROUND = UIManager.getColor("Tree.textForeground");
    private Icon icon = null;

    public ImageCellRenderer() {
        this((Icon)null);
    }

    public ImageCellRenderer(Icon icon) {
        this.icon = icon;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        this.setText(value == null ? "null" : value.toString());
        if (this.icon != null) {
            this.setIcon(this.icon);
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setFont(list.getFont());
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setText(value == null ? "null" : value.toString());
        if (this.icon != null) {
            this.setIcon(this.icon);
        }
        this.setBackground(isSelected ? table.getSelectionForeground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.setFont(table.getFont());
        return this;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(String.valueOf(value));
        if (this.icon != null) {
            this.setIcon(this.icon);
        }
        this.setBackground(isSelected ? TREE_SELECTION_BACKGROUND : TREE_BACKGROUND);
        this.setForeground(isSelected ? TREE_SELECTION_FOREGROUND : TREE_FOREGROUND);
        this.setFont(tree.getFont());
        return this;
    }
}

