/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.gui.MTextField;
import com.myjavaworld.gui.SingleLineDocument;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class IntegerField
extends MTextField {
    public IntegerField() {
    }

    public IntegerField(int cols) {
        super(cols);
    }

    public void setValue(int value) {
        this.setText(String.valueOf(value));
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    static class IntegerDocument
    extends SingleLineDocument {
        IntegerDocument() {
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
            sb.insert(offset, str);
            try {
                Integer.parseInt(sb.toString());
                super.insertString(offset, str, a);
            }
            catch (NumberFormatException exp) {
                if (sb.toString().equals("-")) {
                    super.insertString(offset, str, a);
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

