/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDesktopPane
extends JDesktopPane {
    public void cascade() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames == null || allFrames.length == 0) {
            return;
        }
        Vector<JInternalFrame> v = new Vector<JInternalFrame>(allFrames.length);
        for (int i = allFrames.length - 1; i >= 0; --i) {
            if (allFrames[i].isIcon() || allFrames[i].isClosed()) continue;
            v.add(allFrames[i]);
        }
        JInternalFrame[] frames = new JInternalFrame[v.size()];
        if ((frames = v.toArray(frames)).length == 0) {
            return;
        }
        int n = Math.min(7, frames.length);
        Dimension desktopSize = this.getSize();
        int vSpacing = frames[0].getHeight() - frames[0].getRootPane().getHeight();
        Dimension spacing = new Dimension(25, vSpacing);
        Dimension maxSize = new Dimension(desktopSize.width - (n - 1) * spacing.width, desktopSize.height - (n - 1) * spacing.height);
        Point location = new Point(0, 0);
        int j = 0;
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setBounds(location.x, location.y, maxSize.width, maxSize.height);
            if (++j % n == 0) {
                location.x = 0;
                location.y = 0;
                continue;
            }
            location.x += spacing.width;
            location.y += spacing.height;
        }
    }

    public void tileHorizontally() {
        this.tile(true);
    }

    public void tileVertically() {
        this.tile(false);
    }

    private void tile(boolean horizontal) {
        int n;
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames == null || allFrames.length == 0) {
            return;
        }
        Vector<JInternalFrame> v = new Vector<JInternalFrame>(allFrames.length);
        for (int i = allFrames.length - 1; i >= 0; --i) {
            if (allFrames[i].isIcon() || allFrames[i].isClosed()) continue;
            v.add(allFrames[i]);
        }
        JInternalFrame[] frames = new JInternalFrame[v.size()];
        if ((frames = v.toArray(frames)).length == 0) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (horizontal) {
            r = new Rectangle(r.y, r.x, r.height, r.width);
        }
        int remainingWindows = n = frames.length;
        int columnCount = n;
        if (n > 3) {
            columnCount = (int)Math.sqrt(n);
        }
        int x = 0;
        int y = 0;
        int i = 0;
        for (int col = 0; col < columnCount; ++col) {
            int remainingColumns = columnCount - col;
            int rowCount = remainingWindows / remainingColumns;
            int columnWidth = (r.width - x) / remainingColumns;
            y = 0;
            for (int row = 0; row < rowCount; ++row) {
                int curx = x;
                int cury = y;
                int curw = columnWidth;
                int curh = (r.height - y) / (rowCount - row);
                if (horizontal) {
                    frames[i].setBounds(cury, curx, curh, curw);
                } else {
                    frames[i].setBounds(curx, cury, curw, curh);
                }
                y += curh;
                --remainingWindows;
                ++i;
            }
            x += columnWidth;
        }
    }
}

