/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.gui.EditPopupMenu;
import com.myjavaworld.gui.MTextComponent;
import com.myjavaworld.gui.SingleLineDocument;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class MLabelTextField
extends JTextField
implements MTextComponent,
MouseListener {
    private UndoManager undoManager = null;
    private boolean first = true;

    public MLabelTextField() {
        this.setup();
    }

    public MLabelTextField(int columns) {
        super(columns);
        this.setup();
    }

    public void setText(String text) {
        super.setText(text);
        this.setCaretPosition(0);
        if (this.first) {
            this.first = false;
            this.getDocument().addUndoableEditListener(this.undoManager);
        }
    }

    public void setDocument(Document model) {
        model.addUndoableEditListener(this.undoManager);
        super.setDocument(model);
    }

    public void setMaximumLength(int maxLength) {
        SingleLineDocument model = (SingleLineDocument)this.getDocument();
        model.setMaximumLength(maxLength);
    }

    public int getMaximumLength() {
        SingleLineDocument model = (SingleLineDocument)this.getDocument();
        return model.getMaximumLength();
    }

    public void setCharacterCase(int characterCase) {
        SingleLineDocument model = (SingleLineDocument)this.getDocument();
        model.setCharacterCase(characterCase);
    }

    public int getCharacterCase() {
        SingleLineDocument model = (SingleLineDocument)this.getDocument();
        return model.getCharacterCase();
    }

    public void setUndoLimit(int undoLimit) {
        this.undoManager.setLimit(undoLimit);
    }

    public int getUndoLimit() {
        return this.undoManager.getLimit();
    }

    public void delete() {
        Document model = this.getDocument();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (selectionStart >= 0 || selectionEnd >= 0) {
            try {
                model.remove(selectionStart, selectionEnd - selectionStart);
            }
            catch (BadLocationException exp) {
                System.err.println(exp);
                exp.printStackTrace();
            }
        }
    }

    public void undo() throws CannotUndoException {
        this.undoManager.undo();
    }

    public void redo() throws CannotRedoException {
        this.undoManager.redo();
    }

    public boolean canCut() {
        if (!this.isEditable()) {
            return false;
        }
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canCopy() {
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canPaste() {
        if (!this.isEditable()) {
            return false;
        }
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipBoard.getContents(this);
        return t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean canDelete() {
        if (!this.isEditable()) {
            return false;
        }
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canUndo() {
        if (!this.isEditable()) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        if (!this.isEditable()) {
            return false;
        }
        return this.undoManager.canRedo();
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.requestFocusInWindow();
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    protected Document createDefaultModel() {
        SingleLineDocument model = new SingleLineDocument();
        return model;
    }

    private void setup() {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.addMouseListener(this);
        this.setAppearance();
    }

    private void setAppearance() {
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
    }
}

