/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.gui.EditPopupMenu;
import com.myjavaworld.gui.MPlainDocument;
import com.myjavaworld.gui.MTextComponent;
import com.myjavaworld.gui.SingleLineDocument;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MPasswordField
extends JPasswordField
implements MTextComponent,
MouseListener {
    public MPasswordField() {
        this.setup();
    }

    public MPasswordField(int columns) {
        super(columns);
        this.setup();
    }

    public void setMaximumLength(int maximumLength) {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        model.setMaximumLength(maximumLength);
    }

    public int getMaximumLength() {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        return model.getMaximumLength();
    }

    public void setCharacterCase(int characterCase) {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        model.setCharacterCase(characterCase);
    }

    public int getCharacterCase() {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        return model.getCharacterCase();
    }

    public void setUndoLimit(int undoLimit) {
    }

    public int getUndoLimit() {
        return 0;
    }

    public void delete() {
        Document model = this.getDocument();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (selectionStart >= 0 || selectionEnd >= 0) {
            try {
                model.remove(selectionStart, selectionEnd - selectionStart);
            }
            catch (BadLocationException exp) {
                System.err.println(exp);
                exp.printStackTrace();
            }
        }
    }

    public void undo() throws CannotUndoException {
    }

    public void redo() throws CannotRedoException {
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canPaste() {
        if (!this.isEditable()) {
            return false;
        }
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipBoard.getContents(this);
        return t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean canDelete() {
        if (!this.isEditable()) {
            return false;
        }
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.requestFocusInWindow();
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    protected Document createDefaultModel() {
        SingleLineDocument model = new SingleLineDocument();
        return model;
    }

    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
        if (evt.getID() == 1004 && !evt.isTemporary()) {
            this.selectAll();
        } else if (evt.getID() == 1005 && !evt.isTemporary()) {
            this.select(0, 0);
        }
    }

    private void setup() {
        this.addMouseListener(this);
    }
}

