/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.gui;

import com.myjavaworld.gui.EditPopupMenu;
import com.myjavaworld.gui.MPlainDocument;
import com.myjavaworld.gui.MTextComponent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class MTextArea
extends JTextArea
implements MTextComponent,
MouseListener {
    private UndoManager undoManager = null;

    public MTextArea() {
        this.setup();
    }

    public MTextArea(int rows, int columns) {
        super(rows, columns);
        this.setup();
    }

    public void setMaximumLength(int maximumLength) {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        model.setMaximumLength(maximumLength);
    }

    public int getMaximumLength() {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        return model.getMaximumLength();
    }

    public void setCharacterCase(int characterCase) {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        model.setCharacterCase(characterCase);
    }

    public int getCharacterCase() {
        MPlainDocument model = (MPlainDocument)this.getDocument();
        return model.getCharacterCase();
    }

    public void setUndoLimit(int undoLimit) {
        this.undoManager.setLimit(undoLimit);
    }

    public int getUndoLimit() {
        return this.undoManager.getLimit();
    }

    public void delete() {
        Document model = this.getDocument();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (selectionStart >= 0 || selectionEnd >= 0) {
            try {
                model.remove(selectionStart, selectionEnd - selectionStart);
            }
            catch (BadLocationException exp) {
                System.err.println(exp);
                exp.printStackTrace();
            }
        }
    }

    public void undo() throws CannotUndoException {
        this.undoManager.undo();
    }

    public void redo() throws CannotRedoException {
        this.undoManager.redo();
    }

    public boolean canCut() {
        if (!this.isEditable()) {
            return false;
        }
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canCopy() {
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canPaste() {
        if (!this.isEditable()) {
            return false;
        }
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipBoard.getContents(this);
        return t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean canDelete() {
        if (!this.isEditable()) {
            return false;
        }
        return this.getSelectionEnd() - this.getSelectionStart() > 0;
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.requestFocusInWindow();
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            EditPopupMenu.getInstance().show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    protected Document createDefaultModel() {
        MPlainDocument model = new MPlainDocument();
        return model;
    }

    private void setup() {
        this.undoManager = new UndoManager();
        this.setUndoLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.addMouseListener(this);
    }
}

