/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import com.myjavaworld.util.SystemUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JSeparator;
import javax.swing.Timer;

public class AboutDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.AboutDlg");
    private static final String CREDITS_HELP_ID = "credits";
    private MLabel labTotalMemory = null;
    private MLabel labAvailableMemory = null;
    private MLabel labUsedMemory = null;
    private MButton butClose = null;
    private MButton butReleaseMemory = null;
    private MButton butCredits = null;
    private Timer timer = null;

    public AboutDlg(Frame parent) {
        super(parent, resources.getString("title.dialog"), false);
        this.getAccessibleContext().setAccessibleDescription("dialog.description");
        this.initComponents();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butClose) {
            this.timer.stop();
            this.dispose();
            System.gc();
        } else if (evt.getSource() == this.butReleaseMemory) {
            System.gc();
        } else if (evt.getSource() == this.timer) {
            this.recalculateMemory();
        }
    }

    protected void escape() {
        this.butClose.doClick();
    }

    private void recalculateMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        totalMemory = (totalMemory + 1023L) / 1024L;
        long availableMemory = Runtime.getRuntime().freeMemory();
        availableMemory = (availableMemory + 1023L) / 1024L;
        this.labTotalMemory.setText(totalMemory + " KB");
        this.labAvailableMemory.setText(availableMemory + " KB");
        this.labUsedMemory.setText(totalMemory - availableMemory + " KB");
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        MessageFormat mf = new MessageFormat(resources.getString("text.productInfo"));
        String[] mfArgs = new String[]{"JFTP", "5.0.1", "20120623", "jMethods, Inc.", "http://www.jMethods.com", "support@jMethods.com"};
        String productInfo = mf.format(mfArgs);
        MLabel labProductName = new MLabel(productInfo, 0);
        Icon logoIcon = JFTPUtil.getIcon("jftp32.gif");
        labProductName.setIcon(logoIcon);
        labProductName.setIconTextGap(20);
        this.getContentPane().add((Component)labProductName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.osName")), c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.getContentPane().add((Component)new MLabel(SystemUtil.getOSName()), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.osVersion")), c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.getContentPane().add((Component)new MLabel(SystemUtil.getOSVersion()), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.jreVersion")), c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.getContentPane().add((Component)new MLabel(SystemUtil.getJREVersion()), c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.jreVendor")), c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.getContentPane().add((Component)new MLabel(SystemUtil.getJREVendor()), c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.userHome")), c);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.getContentPane().add((Component)new MLabel(SystemUtil.getUserHome()), c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.totalMemory")), c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        long totalMemory = Runtime.getRuntime().totalMemory();
        totalMemory = (totalMemory + 1023L) / 1024L;
        this.labTotalMemory = new MLabel(totalMemory + " KB");
        this.getContentPane().add((Component)this.labTotalMemory, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.availableMemory")), c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        long availableMemory = Runtime.getRuntime().freeMemory();
        availableMemory = (availableMemory + 1023L) / 1024L;
        this.labAvailableMemory = new MLabel(availableMemory + " KB");
        this.getContentPane().add((Component)this.labAvailableMemory, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.usedMemory")), c);
        c.gridx = 1;
        c.gridy = 9;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        long usedMemory = totalMemory - availableMemory;
        this.labUsedMemory = new MLabel(usedMemory + " KB");
        this.getContentPane().add((Component)this.labUsedMemory, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)new MLabel(), c);
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weightx = 0.0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        c.anchor = 13;
        this.getContentPane().add(this.getCommandButtons(), c);
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butClose = new MButton(CommonResources.getString("text.close"));
        this.butClose.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butClose);
        this.butCredits = new MButton(resources.getString("text.credits"));
        JFTPHelp2.getInstance().enableHelp(this.butCredits, CREDITS_HELP_ID);
        this.butReleaseMemory = new MButton(resources.getString("text.releaseMemory"));
        this.butReleaseMemory.addActionListener(this);
        panel.add(this.butClose);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCredits);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butReleaseMemory);
        return panel;
    }
}

