/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.IntegerField;
import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class AdvancedConnectionPrefsPanel
extends JPanel {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.AdvancedConnectionPrefsPanel");
    private MComboBox comboFTPClient = null;
    private MComboBox comboListParser = null;
    private MCheckBox cbPassive = null;
    private IntegerField tfBufferSize = null;
    private IntegerField tfTimeout = null;

    public AdvancedConnectionPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    public boolean validateFields() {
        String error = null;
        IntegerField errorComponent = null;
        int bufferSize = -1;
        int timeout = -1;
        try {
            bufferSize = this.tfBufferSize.getValue();
            timeout = this.tfTimeout.getValue();
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        if (bufferSize <= 0) {
            error = resources.getString("error.bufferSize.invalid");
            errorComponent = this.tfBufferSize;
        } else if (timeout < 0) {
            error = resources.getString("error.timeout.invalid");
            errorComponent = this.tfTimeout;
        }
        if (error == null) {
            return true;
        }
        GUIUtil.showError((Component)this, error);
        ((Component)errorComponent).requestFocusInWindow();
        return false;
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        String ftpClient = JFTP.getClientName(prefs.getClient());
        this.comboFTPClient.setSelectedItem(ftpClient);
        String listParser = JFTP.getParserName(prefs.getListParser());
        this.comboListParser.setSelectedItem(listParser);
        this.cbPassive.setSelected(prefs.isPassive());
        this.tfBufferSize.setValue(prefs.getBufferSize() / 1024);
        this.tfTimeout.setValue(prefs.getTimeout() / 60000);
    }

    public void saveChanges() {
        String ftpClientClassName = JFTP.getClientClassName((String)this.comboFTPClient.getSelectedItem());
        JFTP.prefs.setClient(ftpClientClassName);
        String listParserClassName = JFTP.getParserClassName((String)this.comboListParser.getSelectedItem());
        JFTP.prefs.setListParser(listParserClassName);
        JFTP.prefs.setPassive(this.cbPassive.isSelected());
        JFTP.prefs.setBufferSize(this.tfBufferSize.getValue() * 1024);
        JFTP.prefs.setTimeout(this.tfTimeout.getValue() * 60000);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labFTPClient = new MLabel(resources.getString("text.ftpClient"));
        this.comboFTPClient = new MComboBox(JFTP.getInstalledClients());
        MLabel labListParser = new MLabel(resources.getString("text.listParser"));
        this.comboListParser = new MComboBox(JFTP.getInstalledParsers());
        this.cbPassive = new MCheckBox(resources.getString("text.passive"));
        MLabel labBufferSize = new MLabel(resources.getString("text.bufferSize"));
        this.tfBufferSize = new IntegerField(4);
        MLabel labBufferSizeUnit = new MLabel(resources.getString("text.kb"));
        MLabel labTimeout = new MLabel(resources.getString("text.timeout"));
        this.tfTimeout = new IntegerField(5);
        MLabel labTimeoutUnit = new MLabel(resources.getString("text.minutes"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)labFTPClient, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.comboFTPClient, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labListParser, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.comboListParser, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.cbPassive, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labBufferSize, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfBufferSize, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)labBufferSizeUnit, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labTimeout, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfTimeout, c);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)labTimeoutUnit, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new MLabel(), c);
        this.populateScreen();
    }
}

