/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class AutoUpdater
extends Thread {
    private static final String KEY_LATEST_VERSION = "latestVersion";
    private static final String KEY_INFO_URL = "infoURL";
    private static final String CHECK_URL = "http://www.jMethods.com/software/jftp/update.properties";
    private Component parent = null;
    private boolean delay = false;
    private boolean showNoUpdatesMessage = false;

    public AutoUpdater(Component parent, boolean delay, boolean ignoreIfNoUpdates) {
        super("Auto Updater Thread");
        this.parent = parent;
        this.delay = delay;
        this.showNoUpdatesMessage = ignoreIfNoUpdates;
    }

    public void run() {
        if (this.delay) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException exp) {
                // empty catch block
            }
        }
        while (true) {
            try {
                URL url = new URL(CHECK_URL);
                Properties props = new Properties();
                props.load(url.openStream());
                String latestVersion = props.getProperty(KEY_LATEST_VERSION);
                String currentVersion = "5.0.1";
                String infoURL = props.getProperty(KEY_INFO_URL);
                if (latestVersion != null && latestVersion.trim().length() > 0) {
                    ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.AutoUpdater");
                    String title = resources.getString("title.dialog");
                    if (latestVersion.compareTo(currentVersion) > 0) {
                        MessageFormat mf = new MessageFormat(resources.getString("message.updatesAvailable"));
                        String message = mf.format(new Object[]{"JFTP", currentVersion, latestVersion, infoURL});
                        GUIUtil.showInformation(this.parent, title, message, true);
                    } else if (this.showNoUpdatesMessage) {
                        GUIUtil.showInformation(this.parent, title, resources.getString("message.updatesNotAvailable"), false);
                    }
                }
                return;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

