/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class CertificatePrefsPanel
extends JPanel
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.CertificatePrefsPanel");
    private MTextField tfServerCertificates = null;
    private MTextField tfClientCertificates = null;
    private MButton butBrowseClientCertificates = null;
    private MButton butBrowseServerCertificates = null;

    public CertificatePrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    public void saveChanges() {
        JFTP.prefs.setServerCertificateStore(this.tfServerCertificates.getText());
        JFTP.prefs.setClientCertificateStore(this.tfClientCertificates.getText());
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butBrowseServerCertificates) {
            this.browseServerCertificateStore();
        } else if (evt.getSource() == this.butBrowseClientCertificates) {
            this.browseClientCertificateStore();
        }
    }

    private void browseServerCertificateStore() {
        int option;
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        String fileName = this.tfServerCertificates.getText();
        if (fileName.trim().length() > 0 && (file = new File(fileName)).exists() && file.isFile()) {
            fileChooser.setSelectedFile(file);
        }
        if ((option = fileChooser.showDialog(this, "Select")) != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        try {
            fileName = selectedFile.getCanonicalPath();
        }
        catch (IOException exp) {
            fileName = selectedFile.getAbsolutePath();
        }
        this.tfServerCertificates.setText(fileName);
    }

    private void browseClientCertificateStore() {
        int option;
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        String fileName = this.tfClientCertificates.getText();
        if (fileName.trim().length() > 0 && (file = new File(fileName)).exists() && file.isFile()) {
            fileChooser.setSelectedFile(file);
        }
        if ((option = fileChooser.showDialog(this, "Select")) != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        try {
            fileName = selectedFile.getCanonicalPath();
        }
        catch (IOException exp) {
            fileName = selectedFile.getAbsolutePath();
        }
        this.tfClientCertificates.setText(fileName);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MLabel labServerCertificates = new MLabel(resources.getString("labServerCertificates.text"));
        MLabel labClientCertificates = new MLabel(resources.getString("labClientCertificates.text"));
        this.tfServerCertificates = new MTextField(20);
        this.tfServerCertificates.setToolTipText(resources.getString("tfServerCertificates.tooltip"));
        this.tfClientCertificates = new MTextField(20);
        this.tfClientCertificates.setToolTipText(resources.getString("tfClientCertificates.tooltip"));
        this.butBrowseServerCertificates = new MButton(resources.getString("butBrowseServerCertificates.text"));
        this.butBrowseClientCertificates = new MButton(resources.getString("butBrowseClientCertificates.text"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)labServerCertificates, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.tfServerCertificates, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.butBrowseServerCertificates, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labClientCertificates, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfClientCertificates, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.butBrowseClientCertificates, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new MLabel(), c);
        this.tfServerCertificates.setText(JFTP.prefs.getServerCertificateStore());
        this.tfClientCertificates.setText(JFTP.prefs.getClientCertificateStore());
        this.butBrowseServerCertificates.addActionListener(this);
        this.butBrowseClientCertificates.addActionListener(this);
    }
}

