/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JTextField;

public class ChangeLocalDirectoryDlg
extends MDialog
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ChangeLocalDirectoryDlg");
    private static final String HELP_ID = "local.changeDirectory";
    private JTextField tfDirectory = null;
    private MButton butChange = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private boolean approved = false;

    public ChangeLocalDirectoryDlg(Frame parent) {
        super(parent, resources.getString("title.dialog"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public String getDirectory() {
        if (this.approved) {
            return this.tfDirectory.getText();
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butChange) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.close();
        } else if (evt.getSource() == this.butCancel) {
            this.close();
        }
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private void close() {
        this.setVisible(false);
    }

    private boolean validateInput() {
        String message = null;
        JTextField errorComponent = null;
        if (this.tfDirectory.getText().trim().length() == 0) {
            message = resources.getString("error.directory.required");
            errorComponent = this.tfDirectory;
        }
        if (message != null) {
            GUIUtil.showError((Component)this, message);
            if (errorComponent != null) {
                ((Component)errorComponent).requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labDirectory = new MLabel(resources.getString("text.directory"));
        this.tfDirectory = new MTextField(20);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)labDirectory, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.getContentPane().add((Component)this.tfDirectory, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)new MLabel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butChange = new MButton(resources.getString("text.change"));
        this.butChange.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butChange);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butChange);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

