/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.IntegerField;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MPasswordField;
import com.myjavaworld.gui.MRadioButton;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTextArea;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.RemoteHost;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ConnectionDlg
extends MDialog
implements ActionListener,
ComponentListener,
ItemListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ConnectionDlg");
    private static final String HELP_ID = "connect.connectionDialog";
    private JTabbedPane tabs = null;
    private MTextField tfHost = null;
    private IntegerField tfPort = null;
    private MTextField tfUser = null;
    private MPasswordField tfPassword = null;
    private MTextField tfAccount = null;
    private MButton butConnect = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private MComboBox comboFTPClient = null;
    private MComboBox comboListParser = null;
    private MTextField tfInitialLocalDirectory = null;
    private MTextField tfInitialRemoteDirectory = null;
    private MCheckBox cbPassive = null;
    private MTextArea taCommands = null;
    private MButton butBrowseLocalDirectory = null;
    private MRadioButton radioNoSSL = null;
    private MRadioButton radioUseSSLIfAvailable = null;
    private MRadioButton radioExplicitSSL = null;
    private MRadioButton radioImplicitSSL = null;
    private IntegerField tfImplicitSSLPort = null;
    private MCheckBox cbDataChannelEncryption = null;
    private RemoteHost remoteHost = null;
    private boolean approved = false;

    public ConnectionDlg(Frame frame) {
        super(frame, resources.getString("title.dialog"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public void setRemoteHost(RemoteHost remoteHost) {
        this.remoteHost = remoteHost == null ? new RemoteHost() : remoteHost;
        this.populateScreen();
    }

    public RemoteHost getRemoteHost() {
        if (this.approved) {
            return this.remoteHost;
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.butConnect)) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.connectButtonPressed();
            this.close();
        } else if (evt.getSource().equals(this.butCancel)) {
            this.cancelButtonPressed();
            this.close();
        } else if (evt.getSource().equals(this.butBrowseLocalDirectory)) {
            this.browseButtonPressed();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.radioNoSSL) {
            this.cbDataChannelEncryption.setEnabled(!this.radioNoSSL.isSelected());
            this.tfImplicitSSLPort.setEnabled(this.radioImplicitSSL.isSelected());
        } else if (evt.getSource() == this.radioImplicitSSL) {
            this.tfImplicitSSLPort.setEnabled(this.radioImplicitSSL.isSelected());
        }
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
        this.tabs.setSelectedIndex(0);
        this.tfHost.requestFocus();
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
    }

    private void close() {
        this.setVisible(false);
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        this.tabs = new JTabbedPane();
        this.tabs.addTab(resources.getString("text.general"), this.getGeneralTab());
        this.tabs.addTab(resources.getString("text.security"), this.getSSLTab());
        this.tabs.addTab(resources.getString("text.advanced"), this.getAdvancedTab());
        this.tabs.addTab(resources.getString("text.commands"), this.getCommandsTab());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)this.tabs, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(6, 12, 12, 12);
        this.getContentPane().add(this.getCommandButtons(), c);
        this.addComponentListener(this);
    }

    private Component getGeneralTab() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        JPanel panel = new JPanel(layout);
        MLabel labHost = new MLabel(resources.getString("text.host"));
        this.tfHost = new MTextField(20);
        MLabel labUser = new MLabel(resources.getString("text.user"));
        this.tfUser = new MTextField(10);
        MLabel labPassword = new MLabel(resources.getString("text.password"));
        this.tfPassword = new MPasswordField(10);
        MLabel labPort = new MLabel(resources.getString("text.port"));
        this.tfPort = new IntegerField(6);
        this.tfPort.setValue(21);
        MLabel labAccount = new MLabel(resources.getString("text.account"));
        this.tfAccount = new MTextField(20);
        c.insets = new Insets(12, 12, 12, 12);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)labHost, c);
        c.insets = new Insets(12, 0, 12, 12);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)this.tfHost, c);
        c.insets = new Insets(0, 12, 12, 12);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)labUser, c);
        c.insets = new Insets(0, 0, 12, 12);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)this.tfUser, c);
        c.insets = new Insets(0, 12, 12, 12);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)labPassword, c);
        c.insets = new Insets(0, 0, 12, 12);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)this.tfPassword, c);
        c.insets = new Insets(0, 12, 12, 12);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)labPort, c);
        c.insets = new Insets(0, 0, 12, 12);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)this.tfPort, c);
        c.insets = new Insets(0, 12, 12, 12);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)labAccount, c);
        c.insets = new Insets(0, 0, 12, 12);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 0.5;
        panel.add((Component)this.tfAccount, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)new MLabel(), c);
        return panel;
    }

    private Component getSSLTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        this.radioNoSSL = new MRadioButton(resources.getString("text.noSSL"));
        this.radioUseSSLIfAvailable = new MRadioButton(resources.getString("text.useSSLIfAvailable"));
        this.radioExplicitSSL = new MRadioButton(resources.getString("text.explicitSSL"));
        this.radioImplicitSSL = new MRadioButton(resources.getString("text.implicitSSL"));
        MLabel labImplicitSSLPort = new MLabel(resources.getString("text.implicitSSLPort"));
        this.tfImplicitSSLPort = new IntegerField(5);
        this.tfImplicitSSLPort.setValue(990);
        this.cbDataChannelEncryption = new MCheckBox(resources.getString("text.dataChannelEncryption"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioNoSSL);
        bg.add(this.radioUseSSLIfAvailable);
        bg.add(this.radioExplicitSSL);
        bg.add(this.radioImplicitSSL);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        panel.add((Component)this.radioNoSSL, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)this.radioUseSSLIfAvailable, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)this.radioExplicitSSL, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 6, 12);
        panel.add((Component)this.radioImplicitSSL, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 60, 12, 12);
        panel.add((Component)labImplicitSSLPort, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        panel.add((Component)this.tfImplicitSSLPort, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)this.cbDataChannelEncryption, c);
        this.radioNoSSL.addItemListener(this);
        this.radioImplicitSSL.addItemListener(this);
        this.radioNoSSL.setSelected(true);
        return panel;
    }

    private Component getAdvancedTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labFTPClient = new MLabel(resources.getString("text.ftpClient"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        panel.add((Component)labFTPClient, c);
        this.comboFTPClient = new MComboBox(JFTP.getInstalledClients());
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(12, 0, 12, 12);
        panel.add((Component)this.comboFTPClient, c);
        MLabel labListParser = new MLabel(resources.getString("text.listParser"));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)labListParser, c);
        this.comboListParser = new MComboBox(JFTP.getInstalledParsers());
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        panel.add((Component)this.comboListParser, c);
        MLabel labInitialLocalDirectory = new MLabel(resources.getString("text.initialLocalDirectory"));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)labInitialLocalDirectory, c);
        this.tfInitialLocalDirectory = new MTextField(20);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        panel.add((Component)this.tfInitialLocalDirectory, c);
        this.butBrowseLocalDirectory = new MButton(CommonResources.getString("text.browse"));
        this.butBrowseLocalDirectory.addActionListener(this);
        c.gridx = 3;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        panel.add((Component)this.butBrowseLocalDirectory, c);
        MLabel labInitialRemoteDirectory = new MLabel(resources.getString("text.initialRemoteDirectory"));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)labInitialRemoteDirectory, c);
        this.tfInitialRemoteDirectory = new MTextField(20);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 12);
        panel.add((Component)this.tfInitialRemoteDirectory, c);
        this.cbPassive = new MCheckBox(resources.getString("text.passive"), JFTP.prefs.isPassive());
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)this.cbPassive, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)new MLabel(), c);
        return panel;
    }

    private Component getCommandsTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labCommands = new MLabel(resources.getString("text.executeCommands"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        panel.add((Component)labCommands, c);
        this.taCommands = new MTextArea(4, 30);
        MScrollPane scroller = new MScrollPane(this.taCommands);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        panel.add((Component)scroller, c);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butConnect = new MButton(resources.getString("text.connect"));
        this.butConnect.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butConnect);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butConnect);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }

    private void populateScreen() {
        String temp = null;
        temp = this.remoteHost.getHostName();
        this.tfHost.setText(temp);
        temp = this.remoteHost.getUser();
        this.tfUser.setText(temp.trim().length() == 0 ? "anonymous" : temp);
        temp = this.remoteHost.getPassword();
        this.tfPassword.setText(temp.trim().length() == 0 ? JFTP.prefs.getEmail() : temp);
        this.tfPort.setValue(this.remoteHost.getPort());
        temp = this.remoteHost.getAccount();
        this.tfAccount.setText(temp);
        temp = this.remoteHost.getFTPClientClassName();
        this.comboFTPClient.setSelectedItem(JFTP.getClientName(temp));
        temp = this.remoteHost.getListParserClassName();
        this.comboListParser.setSelectedItem(JFTP.getParserName(temp));
        this.tfInitialLocalDirectory.setText(this.remoteHost.getInitialLocalDirectory());
        this.tfInitialRemoteDirectory.setText(this.remoteHost.getInitialRemoteDirectory());
        this.cbPassive.setSelected(this.remoteHost.isPassive());
        this.taCommands.setText(this.remoteHost.getCommandsAsString());
        int sslUsage = this.remoteHost.getSSLUsage();
        switch (sslUsage) {
            case 0: {
                this.radioNoSSL.setSelected(true);
                break;
            }
            case 1: {
                this.radioUseSSLIfAvailable.setSelected(true);
                break;
            }
            case 3: {
                this.radioExplicitSSL.setSelected(true);
                break;
            }
            case 2: {
                this.radioImplicitSSL.setSelected(true);
            }
        }
        this.tfImplicitSSLPort.setValue(this.remoteHost.getImplicitSSLPort());
        this.cbDataChannelEncryption.setSelected(this.remoteHost.isDataChannelUnencrypted());
    }

    private void connectButtonPressed() {
        this.remoteHost = new RemoteHost();
        this.remoteHost.setHostName(this.tfHost.getText());
        this.remoteHost.setPort(this.tfPort.getValue());
        this.remoteHost.setUser(this.tfUser.getText());
        this.remoteHost.setPassword(new String(this.tfPassword.getPassword()));
        this.remoteHost.setAccount(this.tfAccount.getText());
        this.remoteHost.setFTPClientClassName(JFTP.getClientClassName((String)this.comboFTPClient.getSelectedItem()));
        this.remoteHost.setListParserClassName(JFTP.getParserClassName((String)this.comboListParser.getSelectedItem()));
        this.remoteHost.setInitialLocalDirectory(this.tfInitialLocalDirectory.getText());
        this.remoteHost.setInitialRemoteDirectory(this.tfInitialRemoteDirectory.getText());
        this.remoteHost.setPassive(this.cbPassive.isSelected());
        this.remoteHost.setCommands(this.taCommands.getText());
        int sslUsage = 0;
        if (this.radioUseSSLIfAvailable.isSelected()) {
            sslUsage = 1;
        } else if (this.radioExplicitSSL.isSelected()) {
            sslUsage = 3;
        } else if (this.radioImplicitSSL.isSelected()) {
            sslUsage = 2;
            this.remoteHost.setImplicitSSLPort(this.tfImplicitSSLPort.getValue());
        }
        this.remoteHost.setSSLUsage(sslUsage);
        this.remoteHost.setDataChannelUnencrypted(this.cbDataChannelEncryption.isSelected());
    }

    private void cancelButtonPressed() {
        this.remoteHost = null;
    }

    private void browseButtonPressed() {
        int option;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(CommonResources.getString("title.selectDirectory"));
        fileChooser.setApproveButtonText(CommonResources.getString("text.select"));
        String dir = this.tfInitialLocalDirectory.getText();
        if (dir.trim().length() == 0) {
            dir = JFTP.prefs.getLocalDirectory();
        }
        File currentDirectory = null;
        if (dir.trim().length() > 0) {
            currentDirectory = new File(dir);
        }
        if (currentDirectory.exists() && currentDirectory.isDirectory()) {
            fileChooser.setSelectedFile(currentDirectory);
        }
        if ((option = fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        this.tfInitialLocalDirectory.setText(selectedFile.getAbsolutePath());
    }

    private boolean validateInput() {
        String message = null;
        int errorTab = 0;
        JTextField errorComponent = null;
        int port = -1;
        int implicitSSLPort = -1;
        try {
            port = this.tfPort.getValue();
            implicitSSLPort = this.tfImplicitSSLPort.getValue();
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        if (this.tfHost.getText().trim().length() == 0) {
            message = resources.getString("error.host.required");
            errorComponent = this.tfHost;
        } else if (this.tfUser.getText().trim().length() == 0) {
            message = resources.getString("error.user.required");
            errorComponent = this.tfUser;
        } else if (new String(this.tfPassword.getPassword()).trim().length() == 0) {
            message = resources.getString("error.password.required");
            errorComponent = this.tfPassword;
        } else if (port < 0 || port > 65535) {
            message = resources.getString("error.port.invalid");
            errorComponent = this.tfPort;
        } else if (this.radioImplicitSSL.isSelected() && (implicitSSLPort < 0 || implicitSSLPort > 65535)) {
            message = resources.getString("error.implicitSSLPort.invalid");
            errorTab = 1;
            errorComponent = this.tfImplicitSSLPort;
        }
        if (message == null) {
            return true;
        }
        GUIUtil.showError((Component)this, message);
        this.tabs.setSelectedIndex(errorTab);
        if (errorComponent != null) {
            ((Component)errorComponent).requestFocus();
        }
        return false;
    }
}

