/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.actions.DownloadAction;
import com.myjavaworld.jftp.actions.UploadAction;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DnDTransferHandler
extends TransferHandler {
    private static final Icon DOWNLOAD_ICON = JFTPUtil.getIcon("download16.gif");
    private static final Icon UPLOAD_ICON = JFTPUtil.getIcon("upload16.gif");
    private static final DataFlavor LOCAL_FILE_FLAVOR = new DataFlavor(LocalFile[].class, "localFileList");
    private static final DataFlavor REMOTE_FILE_FLAVOR = new DataFlavor(RemoteFile[].class, "remoteFileList");
    private JFTP jftp = null;

    public DnDTransferHandler(JFTP jftp) {
        this.jftp = jftp;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if ("localPane".equals(comp.getName())) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (!transferFlavors[i].equals(REMOTE_FILE_FLAVOR)) continue;
                return true;
            }
            return false;
        }
        if ("remotePane".equals(comp.getName())) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (!transferFlavors[i].equals(LOCAL_FILE_FLAVOR)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        if ("localPane".equals(c.getName())) {
            return new LocalFileTransferable(this.jftp.getCurrentSession().getSelectedLocalFiles());
        }
        if ("remotePane".equals(c.getName())) {
            return new RemoteFileTransferable(this.jftp.getCurrentSession().getSelectedRemoteFiles());
        }
        return null;
    }

    public boolean importData(JComponent comp, Transferable t) {
        if ("localPane".equals(comp.getName())) {
            DownloadAction.getInstance(this.jftp).actionPerformed(null);
            return true;
        }
        if ("remotePane".equals(comp.getName())) {
            UploadAction.getInstance(this.jftp).actionPerformed(null);
            return true;
        }
        return false;
    }

    public Icon getVisualRepresentation(Transferable t) {
        try {
            String data = (String)t.getTransferData(DataFlavor.stringFlavor);
            if ("cmd.upload".equals(data)) {
                return UPLOAD_ICON;
            }
            if ("cmd.download".equals(data)) {
                return DOWNLOAD_ICON;
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.getVisualRepresentation(t);
    }

    private class RemoteFileTransferable
    implements Transferable {
        final DataFlavor[] supportedFlavors = new DataFlavor[]{DnDTransferHandler.access$100()};
        private RemoteFile[] data = null;

        public RemoteFileTransferable(RemoteFile[] data) {
            this.data = data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(REMOTE_FILE_FLAVOR);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(REMOTE_FILE_FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class LocalFileTransferable
    implements Transferable {
        final DataFlavor[] supportedFlavors = new DataFlavor[]{DnDTransferHandler.access$000()};
        private LocalFile[] data = null;

        public LocalFileTransferable(LocalFile[] data) {
            this.data = data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(LOCAL_FILE_FLAVOR);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(LOCAL_FILE_FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

