/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MRadioButton;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class DownloadAndUnzipDlg
extends MDialog
implements ActionListener,
ItemListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.DownloadAndUnzipDlg");
    private static final String HELP_ID = "transfer.downloadAndUnzip";
    private JFTP jftp = null;
    private MRadioButton radioDownloadToTempDir = null;
    private MRadioButton radioDownloadToCurrentDir = null;
    private MRadioButton radioDownloadToOtherDir = null;
    private MTextField tfDownloadDir = null;
    private MButton butBrowseDownloadDir = null;
    private MRadioButton radioUnzipToCurrentDir = null;
    private MRadioButton radioUnzipToOtherDir = null;
    private MTextField tfUnzipDir = null;
    private MButton butBrowseUnzipDir = null;
    private MButton butDownload = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private RemoteFile remoteFile = null;
    private boolean approved = false;

    public DownloadAndUnzipDlg(JFTP jftp, RemoteFile remoteFile) {
        super(jftp);
        this.jftp = jftp;
        this.remoteFile = remoteFile;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
        this.pack();
    }

    public boolean isApproved() {
        return this.approved;
    }

    public File getUnzipDirectory() {
        File unzipDir = null;
        if (this.approved) {
            if (this.radioUnzipToCurrentDir.isSelected()) {
                return this.jftp.getCurrentSession().getLocalWorkingDirectory().getFile();
            }
            if (this.radioUnzipToOtherDir.isSelected()) {
                return new File(this.tfUnzipDir.getText().trim());
            }
        }
        return unzipDir;
    }

    public File getDownloadTo() {
        File downloadFile = null;
        if (this.approved) {
            if (this.radioDownloadToTempDir.isSelected()) {
                try {
                    downloadFile = File.createTempFile("jftp", ".zip");
                }
                catch (IOException exp) {
                    GUIUtil.showError((Component)this, exp);
                }
            } else if (this.radioDownloadToCurrentDir.isSelected()) {
                downloadFile = new File(this.jftp.getCurrentSession().getLocalWorkingDirectory().getFile(), this.remoteFile.getNormalizedName());
            } else if (this.radioDownloadToOtherDir.isSelected()) {
                downloadFile = new File(this.tfDownloadDir.getText().trim(), this.remoteFile.getNormalizedName());
            }
        }
        return downloadFile;
    }

    public boolean getDeleteOption() {
        return this.radioDownloadToTempDir.isSelected();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butDownload) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.setVisible(false);
        } else if (evt.getSource() == this.butCancel) {
            this.setVisible(false);
        } else if (evt.getSource() == this.butBrowseDownloadDir || evt.getSource() == this.radioDownloadToOtherDir && this.tfDownloadDir.getText().trim().length() == 0) {
            this.browseDownloadDir();
        } else if (evt.getSource() == this.butBrowseUnzipDir || evt.getSource() == this.radioUnzipToOtherDir && this.tfUnzipDir.getText().trim().length() == 0) {
            this.browseUnzipDir();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.radioUnzipToOtherDir) {
            this.tfUnzipDir.setEnabled(this.radioUnzipToOtherDir.isSelected());
            this.butBrowseUnzipDir.setEnabled(this.radioUnzipToOtherDir.isSelected());
        } else if (evt.getSource() == this.radioDownloadToOtherDir) {
            this.tfDownloadDir.setEnabled(this.radioDownloadToOtherDir.isSelected());
            this.butBrowseDownloadDir.setEnabled(this.radioDownloadToOtherDir.isSelected());
        }
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private void browseUnzipDir() {
        File dir = this.browse();
        if (dir != null) {
            this.tfUnzipDir.setText(dir.getAbsolutePath());
        }
    }

    private void browseDownloadDir() {
        File dir = this.browse();
        if (dir != null) {
            this.tfDownloadDir.setText(dir.getAbsolutePath());
        }
    }

    private File browse() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(CommonResources.getString("title.selectDirectory"));
        chooser.setApproveButtonText(CommonResources.getString("text.select"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            File selectedDir = chooser.getSelectedFile();
            return selectedDir;
        }
        return null;
    }

    private boolean validateInput() {
        String error = null;
        MTextField errorComponent = null;
        if (this.radioUnzipToOtherDir.isSelected() && this.tfUnzipDir.getText().trim().length() == 0) {
            error = resources.getString("error.unzipDir.required");
            errorComponent = this.tfUnzipDir;
        } else if (this.radioDownloadToOtherDir.isSelected() && this.tfDownloadDir.getText().trim().length() == 0) {
            error = resources.getString("error.downloadDir.required");
            errorComponent = this.tfDownloadDir;
        }
        if (error != null) {
            GUIUtil.showError((Component)this, error);
            if (errorComponent != null) {
                ((Component)errorComponent).requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add(this.getUnzipOptions(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getDownloadOptions(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        c.anchor = 14;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getUnzipOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("text.unzipOptions")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.radioUnzipToCurrentDir = new MRadioButton(resources.getString("text.unzipToCurrentDir"), true);
        this.radioUnzipToOtherDir = new MRadioButton(resources.getString("text.unzipToOtherDir"), false);
        this.tfUnzipDir = new MTextField(30);
        this.butBrowseUnzipDir = new MButton(CommonResources.getString("text.browse"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioUnzipToCurrentDir);
        bg.add(this.radioUnzipToOtherDir);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.radioUnzipToCurrentDir, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.radioUnzipToOtherDir, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 24, 3, 3);
        panel.add((Component)this.tfUnzipDir, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.butBrowseUnzipDir, c);
        this.radioUnzipToOtherDir.addItemListener(this);
        this.radioUnzipToOtherDir.addActionListener(this);
        this.butBrowseUnzipDir.addActionListener(this);
        this.tfUnzipDir.setEnabled(false);
        this.butBrowseUnzipDir.setEnabled(false);
        return panel;
    }

    private Component getDownloadOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("text.downloadOptions")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.radioDownloadToTempDir = new MRadioButton(resources.getString("text.downloadToTempDir"), true);
        this.radioDownloadToCurrentDir = new MRadioButton(resources.getString("text.downloadToCurrentDir"), false);
        this.radioDownloadToOtherDir = new MRadioButton(resources.getString("text.downloadToOtherDir"), false);
        this.tfDownloadDir = new MTextField(30);
        this.butBrowseDownloadDir = new MButton(CommonResources.getString("text.browse"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioDownloadToTempDir);
        bg.add(this.radioDownloadToCurrentDir);
        bg.add(this.radioDownloadToOtherDir);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.radioDownloadToTempDir, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.radioDownloadToCurrentDir, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.radioDownloadToOtherDir, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 24, 3, 3);
        panel.add((Component)this.tfDownloadDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.butBrowseDownloadDir, c);
        this.radioDownloadToOtherDir.addItemListener(this);
        this.radioDownloadToOtherDir.addActionListener(this);
        this.butBrowseDownloadDir.addActionListener(this);
        this.tfDownloadDir.setEnabled(false);
        this.butBrowseDownloadDir.setEnabled(false);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butDownload = new MButton(resources.getString("text.download"));
        this.butDownload.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butDownload);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butDownload);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

