/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Box;

public class DownloadAsDlg
extends MDialog
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.DownloadAsDlg");
    private static final String HELP_ID = "transfer.downloadAs";
    private MTextField tfFileName = null;
    private MButton butDownload = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private RemoteFile remoteFile = null;
    private boolean approved = false;

    public DownloadAsDlg(JFTP jftp, RemoteFile remoteFile) {
        super(jftp);
        this.remoteFile = remoteFile;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
        this.pack();
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getFileName() {
        if (this.approved) {
            return this.tfFileName.getText();
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butDownload) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.setVisible(false);
        }
        if (evt.getSource() == this.butCancel) {
            this.setVisible(false);
        }
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private boolean validateInput() {
        String error = null;
        MTextField errorComponent = null;
        if (this.tfFileName.getText().trim().length() < 1) {
            error = resources.getString("error.fileName.required");
            errorComponent = this.tfFileName;
        }
        if (error != null) {
            GUIUtil.showError((Component)this, error);
            if (errorComponent != null) {
                ((Component)errorComponent).requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MessageFormat formatter = new MessageFormat(resources.getString("text.fileName"));
        String label = formatter.format(new Object[]{this.remoteFile.getNormalizedName()});
        MLabel labFileName = new MLabel(label);
        this.tfFileName = new MTextField(30);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)labFileName, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.getContentPane().add((Component)this.tfFileName, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        c.anchor = 14;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butDownload = new MButton(resources.getString("text.download"));
        this.butDownload.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butDownload);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butDownload);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

