/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTextArea;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;

public class ExecuteCommandDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ExecuteCommandDlg");
    private static final String HELP_ID = "remote.executeCommands";
    private MTextArea taCommand = null;
    private MButton butExecute = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private boolean approved = false;

    public ExecuteCommandDlg(Frame parent) {
        super(parent, resources.getString("title.dialog"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public String[] getCommands() {
        if (!this.approved) {
            return null;
        }
        String command = this.taCommand.getText();
        if (command == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(command, "\r\n");
        ArrayList<String> commandList = new ArrayList<String>(5);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.trim().length() <= 0) continue;
            commandList.add(token);
        }
        String[] commandArray = new String[commandList.size()];
        commandArray = commandList.toArray(commandArray);
        return commandArray;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butExecute) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.close();
        } else if (evt.getSource() == this.butCancel) {
            this.close();
        }
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private void close() {
        this.setVisible(false);
    }

    private boolean validateInput() {
        String message = null;
        MTextArea errorComponent = null;
        if (this.taCommand.getText().trim().length() == 0) {
            message = resources.getString("error.commands.required");
            errorComponent = this.taCommand;
        }
        if (message != null) {
            GUIUtil.showError((Component)this, message);
            if (errorComponent != null) {
                this.taCommand.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MLabel labCommand = new MLabel(resources.getString("text.commands"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)labCommand, c);
        this.taCommand = new MTextArea(5, 30);
        MScrollPane commandScroller = new MScrollPane(this.taCommand);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)commandScroller, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butExecute = new MButton(resources.getString("text.execute"));
        this.butExecute.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butExecute);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butExecute);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

