/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.actions.AbortAction;
import com.myjavaworld.jftp.actions.ConnectAction;
import com.myjavaworld.jftp.actions.DisconnectAction;
import com.myjavaworld.jftp.actions.DownloadAction;
import com.myjavaworld.jftp.actions.DownloadAndUnzipAction;
import com.myjavaworld.jftp.actions.DownloadAsAction;
import com.myjavaworld.jftp.actions.NewSessionAction;
import com.myjavaworld.jftp.actions.ReconnectAction;
import com.myjavaworld.jftp.actions.UploadAction;
import com.myjavaworld.jftp.actions.UploadAsAction;
import com.myjavaworld.jftp.actions.ZipAndUploadAction;
import com.myjavaworld.util.ResourceLoader;
import com.myjavaworld.util.SystemUtil;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FTPMenu
extends MMenu
implements MenuListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.FTPMenu");
    private JFTP jftp = null;
    private MMenuItem miNewSession = null;
    private MMenuItem miCloseSession = null;
    private MMenuItem miConnect = null;
    private MMenuItem miDisconnect = null;
    private MMenuItem miReconnect = null;
    private MMenuItem miDownload1 = null;
    private MMenuItem miDownloadAs1 = null;
    private MMenuItem miDownloadAndUnzip1 = null;
    private MMenuItem miUpload1 = null;
    private MMenuItem miUploadAs1 = null;
    private MMenuItem miZipAndUpload1 = null;
    private MMenuItem miAbort = null;
    private MMenuItem miExit = null;

    public FTPMenu(JFTP jftp) {
        this.jftp = jftp;
        this.setText(resources.getString("text.ftp"));
        this.setMnemonic(resources.getString("mnemonic.ftp"), resources.getString("mnemonicIndex.ftp"));
        this.prepareMenuItems();
        this.addMenuListener(this);
    }

    private void prepareMenuItems() {
        this.miNewSession = new MMenuItem();
        this.miNewSession.setText(resources.getString("text.newSession"));
        this.miNewSession.setAccelerator(KeyStroke.getKeyStroke(78, GUIUtil.ACCELERATOR_MASK));
        this.miNewSession.setMnemonic(resources.getString("mnemonic.newSession"), resources.getString("mnemonicIndex.newSession"));
        this.miNewSession.addActionListener(NewSessionAction.getInstance(this.jftp));
        this.add(this.miNewSession);
        this.miCloseSession = new MMenuItem(resources.getString("text.closeSession"));
        this.miCloseSession.setAccelerator(KeyStroke.getKeyStroke(67, GUIUtil.ACCELERATOR_MASK + 1));
        this.miCloseSession.setMnemonic(resources.getString("mnemonic.closeSession"), resources.getString("mnemonicIndex.closeSession"));
        this.miCloseSession.setActionCommand("cmd.closeSession");
        this.miCloseSession.addActionListener(this.jftp);
        this.add(this.miCloseSession);
        this.addSeparator();
        this.miConnect = new MMenuItem();
        this.miConnect.setText(resources.getString("text.connect"));
        this.miConnect.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.miConnect.setMnemonic(resources.getString("mnemonic.connect"), resources.getString("mnemonicIndex.connect"));
        this.miConnect.addActionListener(ConnectAction.getInstance(this.jftp));
        this.add(this.miConnect);
        this.miDisconnect = new MMenuItem();
        this.miDisconnect.setText(resources.getString("text.disconnect"));
        this.miDisconnect.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.miDisconnect.setMnemonic(resources.getString("mnemonic.disconnect"), resources.getString("mnemonicIndex.disconnect"));
        this.miDisconnect.addActionListener(DisconnectAction.getInstance(this.jftp));
        this.add(this.miDisconnect);
        this.miReconnect = new MMenuItem();
        this.miReconnect.setText(resources.getString("text.reconnect"));
        this.miReconnect.setAccelerator(KeyStroke.getKeyStroke(114, GUIUtil.ACCELERATOR_MASK));
        this.miReconnect.setMnemonic(resources.getString("mnemonic.reconnect"), resources.getString("mnemonicIndex.reconnect"));
        this.miReconnect.addActionListener(ReconnectAction.getInstance(this.jftp));
        this.add(this.miReconnect);
        this.addSeparator();
        this.miDownload1 = new MMenuItem();
        this.miDownload1.setText(resources.getString("text.download"));
        this.miDownload1.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.miDownload1.setMnemonic(resources.getString("mnemonic.download"), resources.getString("mnemonicIndex.download"));
        this.miDownload1.addActionListener(DownloadAction.getInstance(this.jftp));
        this.add(this.miDownload1);
        this.miDownloadAs1 = new MMenuItem(resources.getString("text.downloadAs"));
        this.miDownloadAs1.setActionCommand("cmd.downloadAs");
        this.miDownloadAs1.setAccelerator(KeyStroke.getKeyStroke(118, GUIUtil.ACCELERATOR_MASK));
        this.miDownloadAs1.setMnemonic(resources.getString("mnemonic.downloadAs"), resources.getString("mnemonicIndex.downloadAs"));
        this.miDownloadAs1.addActionListener(DownloadAsAction.getInstance(this.jftp));
        this.add(this.miDownloadAs1);
        this.miDownloadAndUnzip1 = new MMenuItem(resources.getString("text.downloadAndUnzip"));
        this.miDownloadAndUnzip1.setAccelerator(KeyStroke.getKeyStroke(118, GUIUtil.ACCELERATOR_MASK + 1));
        this.miDownloadAndUnzip1.setMnemonic(resources.getString("mnemonic.downloadAndUnzip"), resources.getString("mnemonicIndex.downloadAndUnzip"));
        this.miDownloadAndUnzip1.addActionListener(DownloadAndUnzipAction.getInstance(this.jftp));
        this.add(this.miDownloadAndUnzip1);
        this.addSeparator();
        this.miUpload1 = new MMenuItem();
        this.miUpload1.setText(resources.getString("text.upload"));
        this.miUpload1.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.miUpload1.setMnemonic(resources.getString("mnemonic.upload"), resources.getString("mnemonicIndex.upload"));
        this.miUpload1.addActionListener(UploadAction.getInstance(this.jftp));
        this.add(this.miUpload1);
        this.miUploadAs1 = new MMenuItem();
        this.miUploadAs1.setText(resources.getString("text.uploadAs"));
        this.miUploadAs1.setAccelerator(KeyStroke.getKeyStroke(120, GUIUtil.ACCELERATOR_MASK));
        this.miUploadAs1.setMnemonic(resources.getString("mnemonic.uploadAs"), resources.getString("mnemonicIndex.uploadAs"));
        this.miUploadAs1.addActionListener(UploadAsAction.getInstance(this.jftp));
        this.add(this.miUploadAs1);
        this.miZipAndUpload1 = new MMenuItem();
        this.miZipAndUpload1.setText(resources.getString("text.zipAndUpload"));
        this.miZipAndUpload1.setAccelerator(KeyStroke.getKeyStroke(120, GUIUtil.ACCELERATOR_MASK + 1));
        this.miZipAndUpload1.setMnemonic(resources.getString("mnemonic.zipAndUpload"), resources.getString("mnemonicIndex.zipAndUpload"));
        this.miZipAndUpload1.addActionListener(ZipAndUploadAction.getInstance(this.jftp));
        this.add(this.miZipAndUpload1);
        this.addSeparator();
        this.miAbort = new MMenuItem();
        this.miAbort.setText(resources.getString("text.abort"));
        this.miAbort.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.miAbort.setMnemonic(resources.getString("mnemonic.abort"), resources.getString("mnemonicIndex.abort"));
        this.miAbort.addActionListener(AbortAction.getInstance(this.jftp));
        this.add(this.miAbort);
        this.miExit = new MMenuItem(resources.getString("text.exit"));
        this.miExit.setActionCommand("cmd.exit");
        this.miExit.setMnemonic(resources.getString("mnemonic.exit"), resources.getString("mnemonicIndex.exit"));
        this.miExit.addActionListener(this.jftp);
        if (!SystemUtil.isMac()) {
            this.addSeparator();
            this.add(this.miExit);
        }
    }

    public void menuSelected(MenuEvent e) {
        FTPSession session = this.jftp.getCurrentSession();
        boolean nullSession = session == null;
        boolean connected = !nullSession && session.isConnected();
        int selectionCount1 = 0;
        boolean isFile1 = false;
        if (!nullSession && (selectionCount1 = session.getLocalFileSelectionCount()) == 1) {
            LocalFile selectedFile = session.getSelectedLocalFile();
            isFile1 = selectedFile.isFile();
        }
        int selectionCount2 = 0;
        if (connected) {
            selectionCount2 = session.getRemoteFileSelectionCount();
        }
        boolean isFile2 = false;
        RemoteFile selectedFile2 = null;
        if (selectionCount2 == 1) {
            selectedFile2 = session.getSelectedRemoteFile();
            isFile2 = selectedFile2.isFile();
        }
        this.miCloseSession.setEnabled(!nullSession);
        this.miConnect.setEnabled(!nullSession);
        this.miDisconnect.setEnabled(connected);
        this.miReconnect.setEnabled(!nullSession && session.getRemoteHost() != null);
        this.miDownload1.setEnabled(connected && selectionCount2 > 0);
        this.miDownloadAs1.setEnabled(connected && selectionCount2 == 1);
        this.miDownloadAndUnzip1.setEnabled(connected && selectionCount2 == 1 && isFile2 && this.isZipFile(selectedFile2));
        this.miUpload1.setEnabled(connected && selectionCount1 > 0);
        this.miUploadAs1.setEnabled(connected && selectionCount1 == 1);
        this.miZipAndUpload1.setEnabled(connected && selectionCount1 > 0);
        this.miAbort.setEnabled(connected);
    }

    public void menuDeselected(MenuEvent e) {
        this.miCloseSession.setEnabled(true);
        this.miConnect.setEnabled(true);
        this.miDisconnect.setEnabled(true);
        this.miReconnect.setEnabled(true);
        this.miDownload1.setEnabled(true);
        this.miDownloadAs1.setEnabled(true);
        this.miDownloadAndUnzip1.setEnabled(true);
        this.miUpload1.setEnabled(true);
        this.miUploadAs1.setEnabled(true);
        this.miZipAndUpload1.setEnabled(true);
        this.miAbort.setEnabled(true);
    }

    public void menuCanceled(MenuEvent e) {
        this.miCloseSession.setEnabled(true);
        this.miConnect.setEnabled(true);
        this.miDisconnect.setEnabled(true);
        this.miReconnect.setEnabled(true);
        this.miDownload1.setEnabled(true);
        this.miDownloadAs1.setEnabled(true);
        this.miDownloadAndUnzip1.setEnabled(true);
        this.miUpload1.setEnabled(true);
        this.miUploadAs1.setEnabled(true);
        this.miZipAndUpload1.setEnabled(true);
        this.miAbort.setEnabled(true);
    }

    private boolean isZipFile(RemoteFile file) {
        String ext = file.getExtension();
        return "ZIP".equalsIgnoreCase(ext);
    }
}

