/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.ConnectionException;
import com.myjavaworld.ftp.ControlConnectionEvent;
import com.myjavaworld.ftp.ControlConnectionListener;
import com.myjavaworld.ftp.DataConnectionEvent;
import com.myjavaworld.ftp.DataConnectionListener;
import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.FTPConnectionEvent;
import com.myjavaworld.ftp.FTPConnectionListener;
import com.myjavaworld.ftp.FTPException;
import com.myjavaworld.ftp.FTPUtil;
import com.myjavaworld.ftp.ListParser;
import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.LocalFileFilter;
import com.myjavaworld.jftp.LocalPane;
import com.myjavaworld.jftp.RemoteHost;
import com.myjavaworld.jftp.RemotePane;
import com.myjavaworld.jftp.SessionPanel;
import com.myjavaworld.jftp.StatusBar;
import com.myjavaworld.jftp.StatusWindow;
import com.myjavaworld.jftp.TransferObject;
import com.myjavaworld.jftp.ssl.JFTPSSLContext;
import com.myjavaworld.util.FileChangeEvent;
import com.myjavaworld.util.FileChangeListener;
import com.myjavaworld.util.FileChangeMonitor;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.ProgressEvent;
import com.myjavaworld.util.ProgressListener;
import com.myjavaworld.util.ResourceLoader;
import com.myjavaworld.zip.ZipEvent;
import com.myjavaworld.zip.ZipListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;

public class FTPSession
extends SessionPanel
implements FTPConnectionListener,
ControlConnectionListener,
DataConnectionListener,
ActionListener,
FileChangeListener,
ProgressListener,
ZipListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.FTPSession");
    private LocalPane localPane = null;
    private JFTP jftp = null;
    private RemotePane remotePane = null;
    private FTPClient client = null;
    private ListParser listParser = null;
    private LocalFile lwd = null;
    private RemoteFile rwd = null;
    private StatusWindow statusWindow = null;
    private StatusBar statusBar = null;
    private Timer timer = null;
    private int timeElapsed = 0;
    private long bytesTransferred = 0L;
    private MessageFormat connectStatusFormat = null;
    private MessageFormat downloadStatusFormat = null;
    private MessageFormat uploadStatusFormat = null;
    private MessageFormat listStatusFormat = null;
    private String listParentStatus = null;
    private JSplitPane splitPane1 = null;
    private JSplitPane splitPane2 = null;
    private static int sessionId = 0;
    private int id = 0;
    private RemoteHost remoteHost = null;
    private int transferType = 2;
    private boolean autoDetect = true;
    private boolean abort = false;
    private Filter localFileFilter = null;
    private Filter remoteFileFilter = null;
    private FileChangeMonitor fileChangeMonitor = null;
    private Hashtable monitoredTransfers = null;
    private MessageFormat zipStatusFormat = null;
    private MessageFormat unzipStatusFormat = null;
    private Timer progressTimer = null;
    private int progress = 0;

    public FTPSession(JFTP jftp) {
        this.jftp = jftp;
        this.id = ++sessionId;
        this.setName("cmd.session" + this.id);
        this.updateTitle();
        this.localFileFilter = new LocalFileFilter(null, null, false);
        this.connectStatusFormat = new MessageFormat(resources.getString("status.connect"));
        this.downloadStatusFormat = new MessageFormat(resources.getString("status.download"));
        this.uploadStatusFormat = new MessageFormat(resources.getString("status.upload"));
        this.listStatusFormat = new MessageFormat(resources.getString("status.list"));
        this.listParentStatus = resources.getString("status.listParent");
        this.timer = new Timer(1000, this);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add(this.getCenterPanel(), "Center");
        this.getContentPane().add(this.getSouthPanel(), "South");
        File lwd = new File(JFTP.prefs.getLocalDirectory());
        if (!lwd.exists() || !lwd.isDirectory()) {
            lwd = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        this.setLocalWorkingDirectory(new LocalFile(lwd));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent arg0) {
                FTPSession.this.splitPane1.setDividerLocation(0.5);
                FTPSession.this.splitPane2.setDividerLocation(0.2);
            }
        });
        this.fileChangeMonitor = new FileChangeMonitor();
        this.fileChangeMonitor.addFileChangeListener(this);
        this.monitoredTransfers = new Hashtable();
        this.zipStatusFormat = new MessageFormat(resources.getString("status.zip"));
        this.unzipStatusFormat = new MessageFormat(resources.getString("status.unzip"));
        this.progressTimer = new Timer(1000, this);
    }

    public void fileChanged(FileChangeEvent evt) {
        File file = evt.getFile();
        TransferObject transferObject = (TransferObject)this.monitoredTransfers.get(file);
        if (transferObject == null) {
            return;
        }
        final LocalFile localFile = transferObject.getLocalFile();
        final RemoteFile remoteFile = transferObject.getRemoteFile();
        MessageFormat formatter = new MessageFormat(resources.getString("confirm.uploadChangedFile"));
        String message = formatter.format(new Object[]{remoteFile, this.getRemoteHost()});
        int confirm = GUIUtil.showConfirmation(this, message);
        if (confirm != 0) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){
            private RemoteFile[] children = null;

            public Object construct() {
                FTPSession.this.upload(localFile, remoteFile);
                try {
                    this.children = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                return null;
            }

            public void finished() {
                FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.children);
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public int getId() {
        return this.id;
    }

    public void setBusy(boolean busy) {
        super.setBusy(busy);
    }

    public void setTransferType(int transferType) {
        this.transferType = transferType;
    }

    public int getTransferType() {
        return this.transferType;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    public boolean isAutoDetect() {
        return this.autoDetect;
    }

    public int getTransferType(String ext) {
        if (this.autoDetect) {
            Object obj = JFTP.prefs.getTransferTypes().get(ext);
            if (obj == null) {
                return JFTP.prefs.getDefaultTransferType();
            }
            return (Integer)obj;
        }
        return this.transferType;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.timer) {
            ++this.timeElapsed;
            this.statusBar.setProgress((int)this.bytesTransferred);
            this.statusBar.setSpeed(this.bytesTransferred / (long)this.timeElapsed);
            this.statusBar.setTimeElapsed(JFTPUtil.getTimeString(this.timeElapsed));
        } else if (source == this.progressTimer) {
            ++this.timeElapsed;
            this.statusBar.setProgress(this.progress);
            this.statusBar.setTimeElapsed(JFTPUtil.getTimeString(this.timeElapsed));
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public void setLocalFileFilter(Filter filter) {
        this.localFileFilter = filter;
        this.localPane.refresh();
    }

    public Filter getLocalFileFilter() {
        return this.localFileFilter;
    }

    public void setRemoteFileFilter(Filter filter) {
        this.remoteFileFilter = filter;
        this.remotePane.refresh();
    }

    public Filter getRemoteFileFilter() {
        return this.remoteFileFilter;
    }

    private void updateTitle() {
        this.jftp.updateSessionTitle(this);
    }

    private Component getCenterPanel() {
        this.localPane = new LocalPane(this);
        this.remotePane = new RemotePane(this);
        this.statusWindow = new StatusWindow();
        MScrollPane scroller = new MScrollPane(this.statusWindow);
        this.splitPane1 = new JSplitPane(1, this.localPane, this.remotePane);
        this.splitPane1.setOneTouchExpandable(true);
        this.splitPane1.setResizeWeight(0.5);
        this.splitPane1.setContinuousLayout(true);
        this.splitPane2 = new JSplitPane(0, scroller, this.splitPane1);
        this.splitPane2.setOneTouchExpandable(true);
        this.splitPane2.setContinuousLayout(true);
        this.splitPane2.setResizeWeight(0.2);
        return this.splitPane2;
    }

    private Component getSouthPanel() {
        this.statusBar = new StatusBar();
        return this.statusBar;
    }

    public void closeSession() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (FTPException exp) {
                this.ftpException(exp);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        this.fileChangeMonitor.stopMonitor();
        this.cleanup();
        System.gc();
    }

    public RemoteHost getRemoteHost() {
        return this.remoteHost;
    }

    public FTPClient getFTPClient() {
        return this.client;
    }

    public void setLocalWorkingDirectory(String dir) {
        File file = new File(dir);
        if (!file.isAbsolute()) {
            file = new File(this.lwd.getFile(), dir);
        }
        this.setLocalWorkingDirectory(new LocalFile(file));
    }

    public void setLocalWorkingDirectory(final LocalFile dir) {
        if (dir == null || !dir.isDirectory() || !dir.canRead()) {
            GUIUtil.showError((Component)this, resources.getString("error.changeLocalDirectory"));
            return;
        }
        this.setBusy(true);
        new SwingWorker(){
            LocalFile[] data = null;

            public Object construct() {
                this.data = dir.list(FTPSession.this.localFileFilter);
                FTPSession.this.lwd = dir;
                return null;
            }

            public void finished() {
                FTPSession.this.localPane.setData(dir, this.data);
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public LocalFile getLocalWorkingDirectory() {
        return this.lwd;
    }

    public void upLocalWorkingDirectory() {
        if (this.lwd == null) {
            return;
        }
        LocalFile parent = this.lwd.getParent();
        if (parent == null) {
            return;
        }
        this.setLocalWorkingDirectory(parent);
    }

    public void refreshLocalPane() {
        this.localPane.refresh();
    }

    public void setRemoteWorkingDirectory(String name) {
        RemoteFile dir = this.listParser.createRemoteFile(name, true);
        this.setRemoteWorkingDirectory(dir);
    }

    public RemoteFile getRemoteWorkingDirectory() {
        return this.rwd;
    }

    public void setRemoteWorkingDirectory(final RemoteFile dir) {
        if (dir == null || !dir.isDirectory() && !dir.isLink()) {
            return;
        }
        Object[] args = new Object[]{dir.getName()};
        String status = this.listStatusFormat.format(args);
        this.statusBar.setStatus(status);
        this.statusBar.setIndeterminate(true);
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    FTPSession.this.client.setWorkingDirectory(dir);
                    RemoteFile wd = FTPSession.this.client.getWorkingDirectory();
                    FTPSession.this.rwd = wd;
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ParseException exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> Could not parse the LIST command output. The original data returned by the server is: \n" + exp.getMessage());
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                FTPSession.this.statusBar.reset();
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void upRemoteWorkingDirectory() {
        if (!this.isConnected()) {
            return;
        }
        this.statusBar.setStatus(this.listParentStatus);
        this.statusBar.setIndeterminate(true);
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    FTPSession.this.client.setToParentDirectory();
                    RemoteFile wd = FTPSession.this.client.getWorkingDirectory();
                    FTPSession.this.rwd = wd;
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ParseException exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> Could not parse the LIST command output. The original data returned by the server is: \n" + exp.getMessage());
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                FTPSession.this.statusBar.reset();
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void refreshRemotePane() {
        this.remotePane.refresh();
    }

    public int getLocalFileSelectionCount() {
        return this.localPane.getSelectionCount();
    }

    public LocalFile getSelectedLocalFile() {
        return this.localPane.getSelectedFile();
    }

    public LocalFile[] getSelectedLocalFiles() {
        return this.localPane.getSelectedFiles();
    }

    public int getRemoteFileSelectionCount() {
        return this.remotePane.getSelectionCount();
    }

    public RemoteFile getSelectedRemoteFile() {
        return this.remotePane.getSelectedFile();
    }

    public RemoteFile[] getSelectedRemoteFiles() {
        return this.remotePane.getSelectedFiles();
    }

    public void connectionOpened(FTPConnectionEvent evt) {
        this.statusWindow.addStatus("<STATUS> " + evt.getMessage());
        this.statusBar.setSecured(this.client.isSecured());
        this.jftp.updateToolBar();
    }

    public void connectionClosed(FTPConnectionEvent evt) {
        this.setBusy(false);
        this.statusWindow.addStatus("<STATUS> " + evt.getMessage());
        this.jftp.updateToolBar();
        this.timer.stop();
        this.timeElapsed = 0;
        this.bytesTransferred = 0L;
        this.statusBar.reset();
        this.statusBar.setSecured(false);
        this.remotePane.clearAll();
        this.updateTitle();
    }

    public void commandSent(ControlConnectionEvent evt) {
        this.statusWindow.addCommand("<COMMAND> " + evt.getMessage());
    }

    public void replyReceived(ControlConnectionEvent evt) {
        this.statusWindow.addReply("<REPLY> " + evt.getMessage());
    }

    public void connectionDropped(ControlConnectionEvent evt) {
        this.statusWindow.addStatus("<STATUS>" + evt.getMessage());
    }

    public void dataTransferStarted(DataConnectionEvent evt) {
    }

    public void dataTransferFinished(DataConnectionEvent evt) {
        this.statusBar.setProgress(0);
    }

    public void dataTransferProgress(DataConnectionEvent evt) {
        this.bytesTransferred = evt.getBytesTransferred();
    }

    public void dataTransferAborted(DataConnectionEvent evt) {
        this.statusWindow.addStatus("<STATUS> Data transfer aborted by the user. ");
        this.timer.stop();
        this.timeElapsed = 0;
        this.bytesTransferred = 0L;
        this.statusBar.reset();
    }

    public void dataTransferError(DataConnectionEvent evt) {
    }

    public void ftpException(Exception exp) {
        this.statusWindow.addError(exp.getMessage());
    }

    public void exception(Throwable t) {
        this.statusWindow.addError(t.toString());
        t.printStackTrace();
    }

    public void connectionException(Exception exp) {
        this.setBusy(false);
        this.statusWindow.addError(exp.getMessage());
        this.jftp.updateToolBar();
        this.timer.stop();
        this.timeElapsed = 0;
        this.bytesTransferred = 0L;
        this.statusBar.reset();
        this.remotePane.clearAll();
        this.updateTitle();
        exp.printStackTrace();
    }

    public void connect(final RemoteHost remoteHost) {
        if (this.isConnected()) {
            MessageFormat format = new MessageFormat(resources.getString("confirm.reconnect"));
            int option = GUIUtil.showConfirmation(this, format.format(new Object[]{this.remoteHost, remoteHost}));
            if (option != 0) {
                return;
            }
            this.disconnect();
        }
        this.remoteHost = remoteHost;
        Object[] args = new Object[]{remoteHost.getHostName(), remoteHost.getSSLUsage() == 2 ? new Integer(remoteHost.getImplicitSSLPort()) : new Integer(remoteHost.getPort())};
        String status = this.connectStatusFormat.format(args);
        this.statusBar.setStatus(status);
        this.statusBar.setIndeterminate(true);
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    FTPSession.this.client = (FTPClient)Class.forName(remoteHost.getFTPClientClassName()).newInstance();
                    FTPSession.this.listParser = (ListParser)Class.forName(remoteHost.getListParserClassName()).newInstance();
                    FTPSession.this.client.setListParser(FTPSession.this.listParser);
                    FTPSession.this.client.setPassive(remoteHost.isPassive());
                    FTPSession.this.client.setTimeout(JFTP.prefs.getTimeout());
                    FTPSession.this.client.setBufferSize(JFTP.prefs.getBufferSize());
                    FTPSession.this.client.setSSLUsage(remoteHost.getSSLUsage());
                    FTPSession.this.client.setDataChannelUnencrypted(remoteHost.isDataChannelUnencrypted());
                    if (remoteHost.getSSLUsage() != 0) {
                        FTPSession.this.client.setSSLContext(JFTPSSLContext.getSSLContext(FTPSession.this.jftp, remoteHost.getHostName()));
                    }
                    FTPSession.this.client.addControlConnectionListener(FTPSession.this);
                    FTPSession.this.client.addDataConnectionListener(FTPSession.this);
                    FTPSession.this.client.addFTPConnectionListener(FTPSession.this);
                    try {
                        int port = 0;
                        port = remoteHost.getSSLUsage() == 2 ? remoteHost.getImplicitSSLPort() : remoteHost.getPort();
                        FTPSession.this.client.connect(remoteHost.getHostName(), port);
                        FTPSession.this.client.login(remoteHost.getUser(), remoteHost.getPassword(), remoteHost.getAccount());
                    }
                    catch (FTPException exp) {
                        FTPSession.this.ftpException(exp);
                        FTPSession.this.client.disconnect();
                        FTPSession.this.client = null;
                        Object var2_7 = null;
                        return null;
                    }
                    String[] commands = remoteHost.getCommands();
                    for (int i = 0; i < commands.length; ++i) {
                        FTPSession.this.client.executeCommand(commands[i]);
                    }
                    String initialRemoteDirectory = remoteHost.getInitialRemoteDirectory();
                    if (initialRemoteDirectory != null && initialRemoteDirectory.trim().length() > 0) {
                        RemoteFile remoteDir = FTPSession.this.listParser.createRemoteFile(initialRemoteDirectory);
                        FTPSession.this.client.setWorkingDirectory(remoteDir);
                    }
                    RemoteFile dir = FTPSession.this.client.getWorkingDirectory();
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    FTPSession.this.rwd = dir;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp.getMessage());
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (FTPSession.this.client != null && FTPSession.this.client.isConnected()) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                    FTPSession.this.updateTitle();
                }
                FTPSession.this.statusBar.reset();
                FTPSession.this.setBusy(false);
                String initialLocalDirectory = remoteHost.getInitialLocalDirectory();
                FTPSession.this.setLocalWorkingDirectory(initialLocalDirectory);
            }
        }.start();
    }

    public void reconnect() {
        if (this.remoteHost != null) {
            this.connect(this.remoteHost);
        }
    }

    public void download() {
        if (!this.isConnected()) {
            return;
        }
        final RemoteFile[] selectedFiles = this.remotePane.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        this.abort = false;
        this.setBusy(true);
        new SwingWorker(){
            LocalFile[] children = null;

            public Object construct() {
                for (int i = 0; i < selectedFiles.length && FTPSession.this.client.isConnected() && !FTPSession.this.abort; ++i) {
                    FTPSession.this.download(FTPSession.this.rwd, FTPSession.this.lwd.getFile(), selectedFiles[i]);
                }
                this.children = FTPSession.this.lwd.list(FTPSession.this.localFileFilter);
                return null;
            }

            public void finished() {
                FTPSession.this.localPane.setData(FTPSession.this.lwd, this.children);
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void download(RemoteFile sourceDir, File targetDir, RemoteFile source) {
        this.download(sourceDir, targetDir, source, null);
    }

    public void download(RemoteFile sourceDir, File targetDir, RemoteFile source, String targetName) {
        if (this.client == null || !this.client.isConnected() || this.abort) {
            return;
        }
        if (source.isDirectory() && (source.getName().equals(".") || source.getName().equals(".."))) {
            return;
        }
        if (targetName == null) {
            targetName = source.getNormalizedName();
        }
        if (source.isFile()) {
            File destination = new File(targetDir, targetName);
            this.downloadDataFile(source, destination);
        } else if (source.isDirectory()) {
            File target = new File(targetDir, targetName);
            if (!target.exists()) {
                target.mkdirs();
            }
            RemoteFile[] children = null;
            try {
                this.client.setWorkingDirectory(source);
                children = this.client.list(this.remoteFileFilter);
            }
            catch (FTPException exp) {
                this.ftpException(exp);
            }
            catch (ConnectionException exp) {
                this.connectionException(exp);
            }
            catch (Exception exp) {
                this.statusWindow.addError("<ERROR> " + exp);
                exp.printStackTrace();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.download(source, target, children[i], null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDataFile(RemoteFile source, File target) {
        int type = this.getTransferType(source.getExtension());
        Object[] args = new Object[]{source.getName()};
        this.statusBar.setStatus(this.downloadStatusFormat.format(args));
        this.statusBar.setMaximum((int)source.getSize());
        this.timeElapsed = 0;
        this.timer.start();
        try {
            this.client.download(source, target, type, false);
        }
        catch (FTPException exp) {
            this.ftpException(exp);
        }
        catch (ConnectionException exp) {
            this.connectionException(exp);
        }
        catch (Exception exp) {
            this.statusWindow.addError("<ERROR> " + exp);
            exp.printStackTrace();
        }
        finally {
            this.timer.stop();
            this.timeElapsed = 0;
            this.statusBar.reset();
        }
    }

    public void upload() {
        if (!this.isConnected()) {
            return;
        }
        final LocalFile[] selectedFiles = this.localPane.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        this.abort = false;
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] children = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                for (int i = 0; i < selectedFiles.length && FTPSession.this.client.isConnected() && !FTPSession.this.abort; ++i) {
                    FTPSession.this.upload(FTPSession.this.lwd, FTPSession.this.rwd, selectedFiles[i]);
                }
                try {
                    this.children = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.children;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.children);
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void upload(LocalFile sourceDir, RemoteFile targetDir, LocalFile source) {
        this.upload(sourceDir, targetDir, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(LocalFile sourceDir, RemoteFile targetDir, LocalFile source, String targetName) {
        if (this.client == null || !this.client.isConnected() || this.abort) {
            return;
        }
        if (source.isDirectory() && (source.getName().equals(".") || source.getName().equals(".."))) {
            return;
        }
        if (targetName == null) {
            targetName = source.getName();
        }
        if (source.isFile()) {
            RemoteFile destination = this.listParser.createRemoteFile(targetDir, targetName, false);
            int type = this.getTransferType(source.getExtension());
            Object[] args = new Object[]{destination.getName()};
            this.statusBar.setStatus(this.uploadStatusFormat.format(args));
            this.statusBar.setMaximum((int)source.getSize());
            this.timeElapsed = 0;
            this.timer.start();
            try {
                this.client.upload(source.getFile(), destination, type, false, 0L);
            }
            catch (FTPException exp) {
                this.ftpException(exp);
            }
            catch (ConnectionException exp) {
                this.connectionException(exp);
            }
            catch (Exception exp) {
                this.statusWindow.addError("<ERROR> " + exp);
                exp.printStackTrace();
            }
            finally {
                this.timer.stop();
                this.timeElapsed = 0;
                this.statusBar.reset();
            }
        } else if (source.isDirectory()) {
            RemoteFile destination = this.listParser.createRemoteFile(targetDir, targetName, true);
            try {
                this.client.createDirectory(destination);
            }
            catch (FTPException exp) {
                this.ftpException(exp);
            }
            catch (ConnectionException exp) {
                this.connectionException(exp);
            }
            catch (Exception exp) {
                this.statusWindow.addError("<ERROR> " + exp);
                exp.printStackTrace();
            }
            LocalFile[] children = source.list(this.localFileFilter);
            for (int i = 0; i < children.length; ++i) {
                this.upload(source, destination, children[i], null);
            }
        }
    }

    public void upload(LocalFile localFile, String remoteFileName) {
        RemoteFile remoteFile = this.listParser.createRemoteFile(this.rwd, remoteFileName);
        this.upload(localFile, remoteFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(LocalFile localFile, RemoteFile destination) {
        int type = this.getTransferType(localFile.getExtension());
        Object[] args = new Object[]{destination.getName()};
        this.statusBar.setStatus(this.uploadStatusFormat.format(args));
        this.statusBar.setMaximum((int)localFile.getSize());
        this.timeElapsed = 0;
        this.timer.start();
        try {
            this.client.upload(localFile.getFile(), destination, type, false, 0L);
        }
        catch (FTPException exp) {
            this.ftpException(exp);
        }
        catch (ConnectionException exp) {
            this.connectionException(exp);
        }
        catch (Exception exp) {
            this.statusWindow.addError("<ERROR> " + exp);
            exp.printStackTrace();
        }
        finally {
            this.timer.stop();
            this.timeElapsed = 0;
            this.statusBar.reset();
        }
    }

    public void createRemoteDirectory(final String directory) {
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                RemoteFile dir = FTPSession.this.listParser.createRemoteFile(directory, true);
                try {
                    FTPSession.this.client.createDirectory(dir);
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp.getMessage());
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (this.data != null) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void createRemoteFile(final String file) {
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                RemoteFile newFile = FTPSession.this.listParser.createRemoteFile(file, false);
                try {
                    FTPSession.this.client.createFile(newFile);
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp.getMessage());
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (this.data != null) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void renameRemoteFile(final String fromName, final String toName) {
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                RemoteFile from = FTPSession.this.listParser.createRemoteFile(fromName);
                RemoteFile to = FTPSession.this.listParser.createRemoteFile(toName);
                try {
                    FTPSession.this.client.rename(from, to);
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (Exception exp) {
                    System.err.println(exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (this.data != null) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void changeRemoteFilePermissions(final RemoteFile oldFile, final RemoteFile newFile, final boolean recursive) {
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    String newAttributes = newFile.getAttributes();
                    newAttributes = newAttributes.substring(1);
                    if (recursive) {
                        FTPSession.this.changeRemoteFilePermissions(oldFile, FTPUtil.parseAttributes(newAttributes));
                    } else {
                        String fileName = oldFile.getNormalizedPath();
                        FTPSession.this.client.executeCommand("SITE CHMOD " + FTPUtil.parseAttributes(newAttributes) + " " + fileName);
                    }
                    FTPSession.this.client.setWorkingDirectory(FTPSession.this.rwd);
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (Exception exp) {
                    System.err.println(exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (this.data != null) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    private void changeRemoteFilePermissions(RemoteFile file, String attributes) {
        if (this.client == null || !this.client.isConnected() || this.abort) {
            return;
        }
        if (file.isDirectory() && (file.getName().equals(".") || file.getName().equals(".."))) {
            return;
        }
        String fileName = file.getNormalizedPath();
        try {
            this.client.executeCommand("SITE CHMOD " + attributes + " " + fileName);
        }
        catch (FTPException exp) {
            this.ftpException(exp);
        }
        catch (ConnectionException exp) {
            this.connectionException(exp);
        }
        if (file.isDirectory()) {
            RemoteFile[] children = null;
            try {
                this.client.setWorkingDirectory(file);
                children = this.client.list(this.remoteFileFilter);
            }
            catch (FTPException exp) {
                this.ftpException(exp);
            }
            catch (ConnectionException exp) {
                this.connectionException(exp);
            }
            catch (Exception exp) {
                this.statusWindow.addError("<ERROR> " + exp);
                exp.printStackTrace();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.changeRemoteFilePermissions(children[i], attributes);
                }
            }
        }
    }

    public void updateRemoteFile(final RemoteFile oldFile, final RemoteFile newFile) {
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    String newAttributes;
                    String oldAttributes;
                    boolean reload = false;
                    String oldName = oldFile.getName();
                    String newName = newFile.getName();
                    if (!oldName.equals(newName)) {
                        FTPSession.this.client.rename(oldFile, newFile);
                        reload = true;
                    }
                    if (!(oldAttributes = oldFile.getAttributes()).equals(newAttributes = newFile.getAttributes())) {
                        newAttributes = newAttributes.substring(1);
                        FTPSession.this.client.executeCommand("SITE CHMOD " + newName + " " + FTPUtil.parseAttributes(newAttributes));
                        reload = true;
                    }
                    if (reload) {
                        this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                        return this.data;
                    }
                }
                catch (Exception exp) {
                    System.err.println(exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (this.data != null) {
                    FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void deleteRemoteFiles() {
        final RemoteFile[] selectedFiles = this.remotePane.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        int option = GUIUtil.showConfirmation(this.jftp, resources.getString("confirm.deleteRemoteFiles"));
        if (option != 0) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){
            RemoteFile[] data = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                for (int i = 0; i < selectedFiles.length; ++i) {
                    FTPSession.this.delete(selectedFiles[i]);
                }
                try {
                    FTPSession.this.client.setWorkingDirectory(FTPSession.this.rwd);
                    this.data = FTPSession.this.client.list(FTPSession.this.remoteFileFilter);
                    return this.data;
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.remotePane.setData(FTPSession.this.rwd, this.data);
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    private void delete(RemoteFile file) {
        if (this.client == null || !this.client.isConnected()) {
            return;
        }
        if (file.isDirectory() && (file.getName().equals(".") || file.getName().equals(".."))) {
            return;
        }
        try {
            if (file.isFile()) {
                this.client.delete(file);
            } else if (file.isDirectory()) {
                RemoteFile[] children = null;
                this.client.setWorkingDirectory(file);
                children = this.client.list(this.remoteFileFilter);
                for (int i = 0; i < children.length; ++i) {
                    this.delete(children[i]);
                }
                this.client.setToParentDirectory();
                this.client.delete(file);
            }
        }
        catch (FTPException exp) {
            this.ftpException(exp);
        }
        catch (ConnectionException exp) {
            this.connectionException(exp);
        }
        catch (Exception exp) {
            this.statusWindow.addError("<ERROR> " + exp);
            exp.printStackTrace();
        }
    }

    public void createLocalDirectory(final String dir) {
        this.setBusy(true);
        new SwingWorker(){
            LocalFile[] data = null;
            boolean created = true;

            public Object construct() {
                File file = new File(dir);
                if (!file.isAbsolute()) {
                    file = new File(FTPSession.this.lwd.getFile(), dir);
                }
                this.created = file.mkdirs();
                if (this.created) {
                    this.data = FTPSession.this.lwd.list(FTPSession.this.localFileFilter);
                }
                return null;
            }

            public void finished() {
                if (!this.created) {
                    GUIUtil.showError((Component)FTPSession.this.jftp, resources.getString("error.createLocalDirectory"));
                } else {
                    FTPSession.this.localPane.setData(FTPSession.this.lwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void createLocalFile(final String fileName) {
        this.setBusy(true);
        new SwingWorker(){
            LocalFile[] data = null;
            boolean created = true;

            public Object construct() {
                File file = new File(fileName);
                if (!file.isAbsolute()) {
                    file = new File(FTPSession.this.lwd.getFile(), fileName);
                }
                try {
                    this.created = file.createNewFile();
                    if (this.created) {
                        this.data = FTPSession.this.lwd.list(FTPSession.this.localFileFilter);
                    }
                }
                catch (Exception exp) {
                    GUIUtil.showError((Component)FTPSession.this.jftp, exp);
                }
                return null;
            }

            public void finished() {
                if (!this.created) {
                    GUIUtil.showError((Component)FTPSession.this.jftp, resources.getString("error.createLocalFile"));
                } else {
                    FTPSession.this.localPane.setData(FTPSession.this.lwd, this.data);
                }
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void renameLocalFile(String fromName, String toName) {
        boolean renamed;
        File fromFile = new File(fromName);
        File toFile = new File(toName);
        if (!fromFile.isAbsolute()) {
            fromFile = new File(this.lwd.getFile(), fromName);
        }
        if (!toFile.isAbsolute()) {
            toFile = new File(this.lwd.getFile(), toName);
        }
        if (renamed = fromFile.renameTo(toFile)) {
            LocalFile[] children = this.lwd.list(this.localFileFilter);
            this.localPane.setData(this.lwd, children);
        } else {
            GUIUtil.showError((Component)this, resources.getString("error.renameLocalFile"));
        }
    }

    public void deleteLocalFiles() {
        final LocalFile[] selectedFiles = this.localPane.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        int option = GUIUtil.showConfirmation(this, resources.getString("conform.deleteLocalFiles"));
        if (option != 0) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){
            LocalFile[] data = null;

            public Object construct() {
                for (int i = 0; i < selectedFiles.length; ++i) {
                    FTPSession.this.delete(selectedFiles[i]);
                }
                this.data = FTPSession.this.lwd.list(FTPSession.this.localFileFilter);
                return null;
            }

            public void finished() {
                FTPSession.this.setBusy(false);
                FTPSession.this.localPane.setData(FTPSession.this.lwd, this.data);
            }
        }.start();
    }

    private void delete(LocalFile file) {
        if (file.isDirectory() && (file.getName().equals(".") || file.getName().equals(".."))) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            LocalFile[] children = file.list(this.localFileFilter);
            for (int i = 0; i < children.length; ++i) {
                this.delete(children[i]);
            }
            file.delete();
        }
    }

    public void executeCommand(final String command) {
        if (this.client == null || !this.client.isConnected()) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    FTPSession.this.client.executeCommand(command);
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError(exp.toString());
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void executeCommands(final String[] commands) {
        if (commands == null || this.client == null || !this.client.isConnected()) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    for (int i = 0; i < commands.length; ++i) {
                        String command = commands[i].toUpperCase();
                        if (command.startsWith("LIST") || command.startsWith("NLST") || command.startsWith("RETR") || command.startsWith("STOR") || command.startsWith("STOU") || command.startsWith("APPE") || command.startsWith("PASV") || command.startsWith("PORT") || command.startsWith("DATA") || command.startsWith("CWD") || command.startsWith("CDUP")) continue;
                        FTPSession.this.client.executeCommand(commands[i]);
                    }
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError(exp.toString());
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public void disconnect() {
        if (this.client == null || !this.client.isConnected()) {
            return;
        }
        this.setBusy(true);
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    FTPSession.this.client.disconnect();
                }
                catch (FTPException exp) {
                    FTPSession.this.ftpException(exp);
                }
                catch (ConnectionException exp) {
                    FTPSession.this.connectionException(exp);
                }
                catch (Exception exp) {
                    FTPSession.this.statusWindow.addError("<ERROR> " + exp);
                    exp.printStackTrace();
                }
                finally {
                    return null;
                }
            }

            public void finished() {
                if (FTPSession.this.timer.isRunning()) {
                    FTPSession.this.timer.stop();
                }
                FTPSession.this.statusBar.reset();
                FTPSession.this.bytesTransferred = 0L;
                FTPSession.this.timeElapsed = 0;
                FTPSession.this.remotePane.clearAll();
                FTPSession.this.updateTitle();
                FTPSession.this.setBusy(false);
            }
        }.start();
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    private void cleanup() {
        this.localPane = null;
        this.remotePane = null;
        this.client = null;
        this.listParser = null;
        this.lwd = null;
        this.rwd = null;
        this.statusWindow = null;
        this.statusBar = null;
        this.timer = null;
        this.downloadStatusFormat = null;
        this.uploadStatusFormat = null;
        this.listStatusFormat = null;
        this.splitPane1 = null;
        this.splitPane2 = null;
        this.remoteHost = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadToTempFile(RemoteFile source, boolean monitor) {
        if (!source.isFile()) {
            return null;
        }
        File destination = null;
        try {
            destination = File.createTempFile("jftp", "." + source.getExtension());
            destination.deleteOnExit();
        }
        catch (IOException exp) {
            this.statusWindow.addError("<ERROR> " + exp);
            exp.printStackTrace();
            return null;
        }
        int type = this.getTransferType(source.getExtension());
        Object[] args = new Object[]{source.getName()};
        this.statusBar.setStatus(this.downloadStatusFormat.format(args));
        this.statusBar.setMaximum((int)source.getSize());
        this.timeElapsed = 0;
        this.timer.start();
        try {
            this.client.download(source, destination, type, false);
            if (monitor) {
                this.fileChangeMonitor.add(destination);
                this.monitoredTransfers.put(destination, new TransferObject(TransferObject.UPLOAD, new LocalFile(destination), source));
            }
            File file = destination;
            return file;
        }
        catch (FTPException exp) {
            this.ftpException(exp);
            File file = null;
            return file;
        }
        catch (ConnectionException exp) {
            this.connectionException(exp);
            File file = null;
            return file;
        }
        catch (Exception exp) {
            this.statusWindow.addError("<ERROR> " + exp);
            exp.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            this.timer.stop();
            this.timeElapsed = 0;
            this.statusBar.reset();
        }
    }

    public void updateToolBar() {
        this.jftp.updateToolBar();
    }

    public void setAbortFlag(boolean abort) {
        this.abort = abort;
    }

    public void clearAbortFlag() {
        this.abort = false;
    }

    public JFTP getJFTP() {
        return this.jftp;
    }

    public void setStatus(String status) {
        this.statusBar.setStatus(status);
    }

    public void resetStatusBar() {
        this.statusBar.reset();
    }

    public void setProgress(int progress) {
        this.statusBar.setProgress(progress);
    }

    public void progressChanged(ProgressEvent evt) {
        this.progress = evt.getProgress();
    }

    public void beginFile(ZipEvent evt) {
        Object[] args = new Object[]{evt.getFile()};
        if (evt.getType() == 1) {
            this.statusBar.setStatus(this.zipStatusFormat.format(args));
        } else if (evt.getType() == 2) {
            this.statusBar.setStatus(this.unzipStatusFormat.format(args));
        }
        this.progressTimer.start();
    }

    public void endFile(ZipEvent evt) {
        this.progressTimer.stop();
        this.timeElapsed = 0;
        this.statusBar.reset();
    }

    public void selectAllLocalFiles() {
        this.localPane.selectAll();
    }

    public void invertLocalFileSelection() {
        this.localPane.invertSelection();
    }

    public void selectAllRemoteFiles() {
        this.remotePane.selectAll();
    }

    public void invertRemoteFileSelection() {
        this.remotePane.invertSelection();
    }
}

