/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.ImageCellRenderer;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MList;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.Favorite;
import com.myjavaworld.jftp.FavoritePropertiesDlg;
import com.myjavaworld.jftp.FavoritesManager;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.RemoteHost;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FavoritesDlg
extends MDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.FavoritesDlg");
    private static final String HELP_ID = "favorites.favoritesManager";
    private JFTP jftp = null;
    private MList listFavorites = null;
    private FavoritesListModel model = null;
    private MButton butAdd = null;
    private MButton butEdit = null;
    private MButton butDelete = null;
    private MButton butConnect = null;
    private MButton butClose = null;
    private MButton butHelp = null;

    public FavoritesDlg(JFTP jftp) {
        super(jftp);
        this.jftp = jftp;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.loadFavorites();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butAdd) {
            this.addButtonPressed();
        } else if (evt.getSource() == this.butEdit) {
            this.editButtonPressed();
        } else if (evt.getSource() == this.butDelete) {
            this.deleteButtonPressed();
        } else if (evt.getSource() == this.butClose) {
            this.saveFavorites();
            this.setVisible(false);
        } else if (evt.getSource() == this.butConnect) {
            this.connectButtonPressed();
        }
    }

    public void windowClosing(WindowEvent evt) {
        this.saveFavorites();
        super.windowClosing(evt);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] selectedIndices = this.listFavorites.getSelectedIndices();
        if (selectedIndices == null || selectedIndices.length == 0) {
            this.butAdd.setEnabled(true);
            this.butEdit.setEnabled(false);
            this.butDelete.setEnabled(false);
            this.butConnect.setEnabled(false);
        } else if (selectedIndices.length == 1) {
            this.butAdd.setEnabled(true);
            this.butEdit.setEnabled(true);
            this.butDelete.setEnabled(true);
            this.butConnect.setEnabled(true);
        } else if (selectedIndices.length > 1) {
            this.butAdd.setEnabled(true);
            this.butEdit.setEnabled(false);
            this.butDelete.setEnabled(true);
            this.butConnect.setEnabled(false);
        }
    }

    public void windowOpened(WindowEvent evt) {
        this.valueChanged(null);
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.listFavorites.locationToIndex(evt.getPoint());
            if (index < 0) {
                return;
            }
            this.connectButtonPressed();
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    protected void escape() {
        this.butClose.doClick();
    }

    private void addButtonPressed() {
        FavoritePropertiesDlg dlg = new FavoritePropertiesDlg((Dialog)this, 1);
        Favorite favorite = new Favorite();
        favorite.setFTPClientClassName(JFTP.prefs.getClient());
        favorite.setListParserClassName(JFTP.prefs.getListParser());
        favorite.setPassive(JFTP.prefs.isPassive());
        dlg.setFavorite(favorite);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        favorite = dlg.getFavorite();
        dlg.dispose();
        if (favorite != null) {
            if (!this.model.contains(favorite)) {
                this.model.add(favorite);
                this.listFavorites.setSelectedValue(favorite, true);
            } else {
                GUIUtil.showError((Component)this, resources.getString("error.duplicateFavorite"));
                this.listFavorites.clearSelection();
            }
        }
    }

    private void editButtonPressed() {
        int selectedIndex = this.listFavorites.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        Favorite selectedFavorite = (Favorite)this.model.get(selectedIndex);
        FavoritePropertiesDlg dlg = new FavoritePropertiesDlg((Dialog)this, 2);
        dlg.setFavorite(selectedFavorite);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        Favorite favorite = dlg.getFavorite();
        dlg.dispose();
        if (favorite != null) {
            if (!this.model.contains(favorite) || favorite.getName().equalsIgnoreCase(selectedFavorite.getName())) {
                this.model.set(selectedIndex, favorite);
                this.listFavorites.setSelectedValue(favorite, true);
            } else {
                GUIUtil.showError((Component)this, resources.getString("error.duplicateFavorite"));
                this.listFavorites.clearSelection();
            }
        }
    }

    private void deleteButtonPressed() {
        Object[] selectedObjects = this.listFavorites.getSelectedValues();
        if (selectedObjects == null || selectedObjects.length == 0) {
            return;
        }
        int option = GUIUtil.showConfirmation(this, resources.getString("confirm.deleteFavorites"));
        if (option != 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(selectedObjects.length);
        for (int i = 0; i < selectedObjects.length; ++i) {
            list.add(selectedObjects[i]);
        }
        this.model.delete(list);
        this.listFavorites.clearSelection();
    }

    private void connectButtonPressed() {
        int selectedIndex = this.listFavorites.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        RemoteHost selectedHost = (RemoteHost)this.model.get(selectedIndex);
        FTPSession session = this.jftp.getCurrentSession();
        if (session == null) {
            this.jftp.newSession();
            session = this.jftp.getCurrentSession();
            if (session == null) {
                return;
            }
        }
        this.saveFavorites();
        this.setVisible(false);
        session.connect(selectedHost);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(12, 12, 12, 12);
        this.model = new FavoritesListModel();
        this.listFavorites = new MList((ListModel)this.model);
        this.listFavorites.setVisibleRowCount(15);
        this.listFavorites.setCellRenderer(new ImageCellRenderer(JFTPUtil.getIcon("server16.gif")));
        this.listFavorites.setPrototypeCellValue("ftp.jMethods.com");
        MScrollPane listScroller = new MScrollPane(this.listFavorites);
        this.getContentPane().add((Component)listScroller, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        this.getContentPane().add(this.getCommandButtons(), c);
        this.listFavorites.addListSelectionListener(this);
        this.listFavorites.addMouseListener(this);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butAdd = new MButton(CommonResources.getString("text.add"));
        this.butAdd.addActionListener(this);
        this.butEdit = new MButton(CommonResources.getString("text.edit"));
        this.butEdit.addActionListener(this);
        this.butDelete = new MButton(CommonResources.getString("text.delete"));
        this.butDelete.addActionListener(this);
        this.butConnect = new MButton(resources.getString("text.connect"));
        this.butConnect.addActionListener(this);
        this.butClose = new MButton(CommonResources.getString("text.close"));
        this.butClose.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        this.getRootPane().setDefaultButton(this.butConnect);
        panel.add(this.butAdd);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.butEdit);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.butDelete);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.butConnect);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.butClose);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.butHelp);
        return panel;
    }

    private void loadFavorites() {
        List favorites = new ArrayList();
        try {
            favorites = FavoritesManager.getFavorites();
            this.model.setFavorites(favorites);
        }
        catch (Exception exp) {
            GUIUtil.showError((Component)this, exp);
        }
    }

    private void saveFavorites() {
        List favorites = this.model.getFavorites();
        try {
            FavoritesManager.saveFavorites(favorites);
        }
        catch (Exception exp) {
            GUIUtil.showError((Component)this, exp);
        }
    }

    class FavoritesListModel
    extends AbstractListModel {
        private List favorites = null;

        public FavoritesListModel() {
            this(new ArrayList());
        }

        public FavoritesListModel(List favorites) {
            this.setFavorites(favorites);
        }

        public void setFavorites(List favorites) {
            if (favorites == null) {
                favorites = new ArrayList();
            }
            this.favorites = favorites;
            Collections.sort(this.favorites);
            this.fireContentsChanged(this, 0, this.favorites.size());
        }

        public List getFavorites() {
            return this.favorites;
        }

        public int getSize() {
            return this.favorites.size();
        }

        public Object getElementAt(int index) {
            return this.favorites.get(index);
        }

        public void add(Object obj) {
            this.favorites.add(obj);
            Collections.sort(this.favorites);
            this.fireContentsChanged(this, 0, this.favorites.size());
        }

        public void set(int index, Object obj) {
            this.favorites.set(index, obj);
            Collections.sort(this.favorites);
            this.fireContentsChanged(this, 0, this.favorites.size());
        }

        public Object get(int index) {
            return this.favorites.get(index);
        }

        public void delete(Collection objects) {
            this.favorites.removeAll(objects);
            this.fireContentsChanged(this, 0, this.favorites.size());
        }

        public boolean contains(Object obj) {
            return this.favorites.contains(obj);
        }
    }
}

