/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.RemoteHost;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.spec.SecretKeySpec;

public class FavoritesManager {
    private static final File FAV_FILE = new File(JFTP.DATA_HOME, "favorites.ser");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getFavorites() throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        List favorites = new ArrayList();
        FileInputStream fin = null;
        ObjectInputStream in = null;
        try {
            FavoritesManager.checkFavFile();
            fin = new FileInputStream(FAV_FILE);
            if (fin.available() > 0) {
                in = new ObjectInputStream(fin);
                Object obj = in.readObject();
                if (obj instanceof List) {
                    favorites = (List)obj;
                    FavoritesManager.saveFavorites(favorites);
                } else {
                    SealedObject so = (SealedObject)obj;
                    favorites = (List)so.getObject(FavoritesManager.getCipher(2));
                }
            }
            ArrayList arrayList = favorites;
            return arrayList;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exp) {}
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException exp) {}
            in = null;
            fin = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFavorites(List favorites) throws IOException, IllegalBlockSizeException {
        if (favorites == null) {
            favorites = new ArrayList();
        }
        FavoritesManager.checkDataHome();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(FAV_FILE));
            Cipher cipher = FavoritesManager.getCipher(1);
            if (cipher == null) {
                out.writeObject(favorites);
            } else {
                SealedObject so = new SealedObject(favorites, cipher);
                out.writeObject(so);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            out = null;
        }
    }

    public static void addFavorite(RemoteHost host) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        List favorites = FavoritesManager.getFavorites();
        favorites.add(host);
        FavoritesManager.saveFavorites(favorites);
    }

    private static void checkDataHome() {
        if (!JFTP.DATA_HOME.exists() || !JFTP.DATA_HOME.isDirectory()) {
            JFTP.DATA_HOME.mkdirs();
        }
    }

    private static void checkFavFile() throws IOException {
        FavoritesManager.checkDataHome();
        if (!FAV_FILE.exists() || !FAV_FILE.isFile()) {
            FAV_FILE.createNewFile();
        }
    }

    private static Cipher getCipher(int mode) {
        byte[] encodedKey = new byte[]{28, -9, -23, 35, -93, -47, -28, 55, -83, -82, 101, -79, 36, 59, 77, -121};
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES");
            SecretKeySpec spec = new SecretKeySpec(encodedKey, "AES");
            cipher.init(mode, spec);
            return cipher;
        }
        catch (InvalidKeyException exp) {
            exp.printStackTrace();
        }
        catch (NoSuchAlgorithmException exp) {
            exp.printStackTrace();
        }
        catch (NoSuchPaddingException exp) {
            exp.printStackTrace();
        }
        return null;
    }
}

