/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GeneralConnectionPrefsPanel
extends JPanel
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.GeneralConnectionPrefsPanel");
    private MTextField tfEmailAddress = null;
    private MTextField tfDefaultLocalDirectory = null;
    private MButton butBrowse = null;

    public GeneralConnectionPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    public boolean validateFields() {
        String error = null;
        MTextField errorComponent = null;
        if (this.tfEmailAddress.getText().trim().length() == 0) {
            error = resources.getString("error.email.required");
            errorComponent = this.tfEmailAddress;
        } else if (this.tfDefaultLocalDirectory.getText().trim().length() == 0) {
            error = resources.getString("error.defaultLocalDirectory.required");
            errorComponent = this.tfDefaultLocalDirectory;
        }
        if (error == null) {
            return true;
        }
        GUIUtil.showError((Component)this, error);
        ((Component)errorComponent).requestFocusInWindow();
        return false;
    }

    public void populateScreen(JFTPPreferences prefs) {
        this.tfEmailAddress.setText(prefs.getEmail());
        this.tfDefaultLocalDirectory.setText(prefs.getLocalDirectory());
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void saveChanges() {
        JFTP.prefs.setEmail(this.tfEmailAddress.getText());
        JFTP.prefs.setLocalDirectory(this.tfDefaultLocalDirectory.getText());
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butBrowse) {
            this.browseButtonPressed();
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labEmailAddress = new MLabel(resources.getString("text.email"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)labEmailAddress, c);
        this.tfEmailAddress = new MTextField(15);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.tfEmailAddress, c);
        MLabel labDefaultLocalDirectory = new MLabel(resources.getString("text.defaultLocalDirectory"));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labDefaultLocalDirectory, c);
        this.tfDefaultLocalDirectory = new MTextField(15);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.tfDefaultLocalDirectory, c);
        this.butBrowse = new MButton(CommonResources.getString("text.browse"));
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.butBrowse, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        this.add((Component)new JLabel(), c);
        this.populateScreen();
        this.butBrowse.addActionListener(this);
    }

    private void browseButtonPressed() {
        int option;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(CommonResources.getString("text.select"));
        String dir = this.tfDefaultLocalDirectory.getText();
        if (dir.trim().length() == 0) {
            dir = JFTP.prefs.getLocalDirectory();
        }
        File currentDirectory = null;
        currentDirectory = dir.trim().length() > 0 ? new File(dir) : JFTP.USER_HOME;
        if (currentDirectory.exists() && currentDirectory.isDirectory()) {
            fileChooser.setSelectedFile(currentDirectory);
        }
        if ((option = fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        this.tfDefaultLocalDirectory.setText(selectedFile.getAbsolutePath());
    }
}

