/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.LicenseAgreementDlg;
import com.myjavaworld.gui.MFrame;
import com.myjavaworld.jftp.AboutDlg;
import com.myjavaworld.jftp.AutoUpdater;
import com.myjavaworld.jftp.ExecuteCommandDlg;
import com.myjavaworld.jftp.FTPMenu;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.Favorite;
import com.myjavaworld.jftp.FavoritePropertiesDlg;
import com.myjavaworld.jftp.FavoritesManager;
import com.myjavaworld.jftp.HelpMenu;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.jftp.JFTPToolBar;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.LocalFileFilterDlg;
import com.myjavaworld.jftp.LocalFilePropertiesDlg;
import com.myjavaworld.jftp.LocalSystemMenu;
import com.myjavaworld.jftp.PreferencesDlg;
import com.myjavaworld.jftp.RemoteFileFilterDlg;
import com.myjavaworld.jftp.RemoteFilePropertiesDlg;
import com.myjavaworld.jftp.RemoteHost;
import com.myjavaworld.jftp.RemoteSystemMenu;
import com.myjavaworld.jftp.ToolsMenu;
import com.myjavaworld.jftp.TransferModeMenu;
import com.myjavaworld.jftp.ssl.CertificateManagerDlg;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JFTP
extends MFrame
implements WindowListener,
ActionListener,
ChangeListener {
    private static ResourceBundle resources = null;
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File DATA_HOME = new File(USER_HOME, ".jftp" + File.separator + "data");
    private static final Map THEMES;
    private static final Map PARSERS;
    private static final Map CLIENTS;
    private static Map transferTypes;
    public static JFTPPreferences prefs;
    private JFTPToolBar toolBar = null;
    private JTabbedPane tabs = null;
    private boolean applet = false;

    public JFTP() {
        this(false);
    }

    public JFTP(boolean applet) {
        super("JFTP");
        this.applet = applet;
        if (resources == null && resources == null) {
            resources = ResourceLoader.getBundle("com.myjavaworld.jftp.JFTP");
        }
        this.setIconImage(JFTPUtil.getImage("jftp16.gif"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setJMenuBar(this.prepareMenuBar());
        this.addWindowListener(this);
        this.setBounds(this.getPreferredBounds());
        this.tabs = new JTabbedPane(1);
        this.tabs.addChangeListener(this);
        this.toolBar = new JFTPToolBar(this);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.tabs, "Center");
    }

    public void newSession() {
        FTPSession session = new FTPSession(this);
        String title = resources.getString("text.notConnected");
        this.tabs.addTab(title, session);
        this.tabs.setSelectedComponent(session);
    }

    public void windowOpened(WindowEvent evt) {
        if (prefs.getWindowBounds() == null) {
            this.setExtendedState(6);
        }
        if (prefs.getCheckForUpdates()) {
            AutoUpdater updater = new AutoUpdater(this, true, false);
            updater.start();
        }
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        this.exit();
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void stateChanged(ChangeEvent evt) {
        this.updateToolBar();
    }

    public void closeSession() {
        FTPSession session = (FTPSession)this.tabs.getSelectedComponent();
        if (session != null) {
            session.closeSession();
            this.tabs.remove(session);
        }
    }

    public void exit() {
        int sessionCount = this.tabs.getTabCount();
        for (int i = 0; i < sessionCount; ++i) {
            FTPSession session = (FTPSession)this.tabs.getComponentAt(i);
            session.closeSession();
        }
        Rectangle windowBounds = this.getBounds();
        prefs.setWindowBounds(windowBounds);
        try {
            JFTP.savePreferences(prefs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
        System.gc();
        if (!this.applet) {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("cmd.closeSession")) {
            this.closeSession();
        } else if (command.equals("cmd.exit")) {
            this.exit();
        } else if (command.equals("cmd.refreshLocalPane")) {
            FTPSession session = this.getCurrentSession();
            if (session != null) {
                session.refreshLocalPane();
            }
        } else if (command.equals("cmd.refreshRemotePane")) {
            FTPSession session = this.getCurrentSession();
            if (session != null) {
                session.refreshRemotePane();
            }
        } else if (command.equals("cmd.manageCertificates")) {
            this.manageCertificates();
        } else if (command.equals("cmd.addToFavorites")) {
            this.addToFavorites();
        } else if (command.equals("cmd.preferences")) {
            this.showPreferencesDialog();
        } else if (command.equals("cmd.newSession")) {
            this.newSession();
        } else if (command.equals("cmd.transferType.autoDetect")) {
            FTPSession session = this.getCurrentSession();
            if (session != null) {
                session.setAutoDetect(true);
            }
        } else if (command.equals("cmd.transferType.ascii")) {
            FTPSession session = this.getCurrentSession();
            if (session != null) {
                session.setAutoDetect(false);
                session.setTransferType(1);
            }
        } else if (command.equals("cmd.transferType.binary")) {
            FTPSession session = this.getCurrentSession();
            if (session != null) {
                session.setAutoDetect(false);
                session.setTransferType(2);
            }
        } else if (command.equals("cmd.help")) {
            this.executeCommand("HELP");
        } else if (command.equals("cmd.stat")) {
            this.executeCommand("STAT");
        } else if (command.equals("cmd.syst")) {
            this.executeCommand("SYST");
        } else if (command.equals("cmd.noop")) {
            this.executeCommand("NOOP");
        } else if (command.equals("cmd.other")) {
            this.executeCustomCommand();
        } else if (command.equals("cmd.remoteFileProperties")) {
            this.showRemoteFileProperties();
        } else if (command.equals("cmd.localFileProperties")) {
            this.showLocalFileProperties();
        } else if (command.equals("cmd.applyLocalFileFilter")) {
            this.showLocalFileFilter();
        } else if (command.equals("cmd.clearLocalFileFilter")) {
            this.clearLocalFileFilter();
        } else if (command.equals("cmd.applyRemoteFileFilter")) {
            this.showRemoteFileFilter();
        } else if (command.equals("cmd.clearRemoteFileFilter")) {
            this.clearRemoteFileFilter();
        } else if (command.equals("cmd.localSelectAll")) {
            this.selectAllLocalFiles();
        } else if (command.equals("cmd.localInvertSelection")) {
            this.invertLocalFileSelection();
        } else if (command.equals("cmd.remoteSelectAll")) {
            this.selectAllRemoteFiles();
        } else if (command.equals("cmd.remoteInvertSelection")) {
            this.invertRemoteFileSelection();
        }
    }

    private void executeCustomCommand() {
        FTPSession session = this.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        ExecuteCommandDlg dlg = new ExecuteCommandDlg(this);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        String[] commands = dlg.getCommands();
        dlg.dispose();
        if (commands == null) {
            return;
        }
        session.executeCommands(commands);
    }

    private void executeCommand(String command) {
        FTPSession session = this.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        session.executeCommand(command);
    }

    private void manageCertificates() {
        CertificateManagerDlg dlg = new CertificateManagerDlg(this);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        dlg.dispose();
    }

    private void showRemoteFileProperties() {
        FTPSession session = this.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        RemoteFile selectedFile = session.getSelectedRemoteFile();
        if (selectedFile == null) {
            return;
        }
        FTPClient client = session.getFTPClient();
        RemoteFilePropertiesDlg dlg = new RemoteFilePropertiesDlg((Frame)this, client, selectedFile, session.getRemoteFileFilter());
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        RemoteFile newFile = dlg.getFile();
        dlg.dispose();
        if (newFile != null) {
            session.changeRemoteFilePermissions(selectedFile, newFile, dlg.isRecursive());
        }
    }

    private void showLocalFileProperties() {
        FTPSession session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        LocalFile selectedFile = session.getSelectedLocalFile();
        if (selectedFile == null) {
            return;
        }
        LocalFilePropertiesDlg dlg = new LocalFilePropertiesDlg((Frame)this, selectedFile, session.getLocalFileFilter());
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        dlg.dispose();
    }

    private void showLocalFileFilter() {
        FTPSession session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        LocalFileFilterDlg dlg = new LocalFileFilterDlg(this);
        dlg.setFilter(session.getLocalFileFilter());
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        Filter filter = dlg.getFilter();
        dlg.dispose();
        if (filter != null) {
            session.setLocalFileFilter(filter);
        }
    }

    private void clearLocalFileFilter() {
        FTPSession session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        session.setLocalFileFilter(null);
    }

    private void showRemoteFileFilter() {
        FTPSession session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        RemoteFileFilterDlg dlg = new RemoteFileFilterDlg(this);
        dlg.setFilter(session.getRemoteFileFilter());
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        Filter filter = dlg.getFilter();
        dlg.dispose();
        if (filter != null) {
            session.setRemoteFileFilter(filter);
        }
    }

    private void clearRemoteFileFilter() {
        FTPSession session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        session.setRemoteFileFilter(null);
    }

    private void addToFavorites() {
        FTPSession session = this.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        RemoteHost host = session.getRemoteHost();
        Favorite favorite = new Favorite();
        favorite.setName(host.getName());
        favorite.setHostName(host.getHostName());
        favorite.setPort(host.getPort());
        favorite.setUser(host.getUser());
        favorite.setPassword(host.getPassword());
        favorite.setAccount(host.getAccount());
        favorite.setFTPClientClassName(host.getFTPClientClassName());
        favorite.setListParserClassName(host.getListParserClassName());
        favorite.setInitialLocalDirectory(host.getInitialLocalDirectory());
        favorite.setInitialRemoteDirectory(host.getInitialRemoteDirectory());
        favorite.setPassive(host.isPassive());
        favorite.setCommands(host.getCommands());
        FavoritePropertiesDlg dlg = new FavoritePropertiesDlg((Frame)this, 1);
        dlg.setFavorite(favorite);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        favorite = dlg.getFavorite();
        if (favorite != null) {
            try {
                List favorites = FavoritesManager.getFavorites();
                if (favorites.contains(favorite)) {
                    GUIUtil.showError((Component)this, resources.getString("error.duplicateFavorite"));
                    return;
                }
                FavoritesManager.addFavorite(favorite);
            }
            catch (Exception exp) {
                GUIUtil.showError((Component)this, exp);
            }
        }
    }

    public void showPreferencesDialog() {
        PreferencesDlg dlg = new PreferencesDlg(this);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        dlg.dispose();
    }

    private JMenuBar prepareMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        FTPMenu menuFTP = new FTPMenu(this);
        LocalSystemMenu menuLocalSystem = new LocalSystemMenu(this);
        RemoteSystemMenu menuRemoteSystem = new RemoteSystemMenu(this);
        TransferModeMenu menuTransferTypes = new TransferModeMenu(this);
        ToolsMenu menuTools = new ToolsMenu(this);
        HelpMenu menuHelp = new HelpMenu(this);
        menuBar.add(menuFTP);
        menuBar.add(menuLocalSystem);
        menuBar.add(menuRemoteSystem);
        menuBar.add(menuTransferTypes);
        menuBar.add(menuTools);
        menuBar.add(menuHelp);
        return menuBar;
    }

    private Rectangle getPreferredBounds() {
        Rectangle windowBounds = prefs.getWindowBounds();
        if (windowBounds == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension preferredSize = new Dimension(screenSize.width - 100, screenSize.height - 100);
            windowBounds = new Rectangle((screenSize.width - preferredSize.width) / 2, (screenSize.height - preferredSize.height) / 2, preferredSize.width, preferredSize.height);
        }
        return windowBounds;
    }

    public FTPSession getCurrentSession() {
        int selectedTabIndex = this.tabs.getSelectedIndex();
        if (selectedTabIndex >= 0) {
            return (FTPSession)this.tabs.getComponentAt(selectedTabIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void savePreferences(JFTPPreferences prefs) throws IOException {
        ObjectOutputStream out = null;
        try {
            File prefsFile = new File(DATA_HOME, "preferences.ser");
            out = new ObjectOutputStream(new FileOutputStream(prefsFile));
            out.writeObject(prefs);
            transferTypes = prefs.getTransferTypes();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JFTPPreferences loadPreferences() throws IOException {
        FileInputStream fin = null;
        ObjectInputStream in = null;
        JFTPPreferences prefs = new JFTPPreferences();
        try {
            File prefsFile;
            if (!DATA_HOME.exists()) {
                DATA_HOME.mkdirs();
            }
            if (!(prefsFile = new File(DATA_HOME, "preferences.ser")).exists()) {
                prefsFile.createNewFile();
                JFTP.savePreferences(new JFTPPreferences());
            }
            fin = new FileInputStream(prefsFile);
            in = new ObjectInputStream(fin);
            if (fin.available() != 0) {
                try {
                    prefs = (JFTPPreferences)in.readObject();
                }
                catch (ClassNotFoundException exp) {
                }
                catch (ClassCastException exp) {
                    // empty catch block
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fin != null) {
                fin.close();
            }
            return prefs;
        }
    }

    public static String[] getInstalledThemes() {
        Object[] themes = new String[THEMES.size()];
        themes = THEMES.keySet().toArray(themes);
        Arrays.sort(themes);
        return themes;
    }

    public static String getThemeClassName(String themeName) {
        return (String)THEMES.get(themeName);
    }

    public static String[] getInstalledParsers() {
        String[] parsers = new String[PARSERS.size()];
        parsers = PARSERS.keySet().toArray(parsers);
        return parsers;
    }

    public static String getParserClassName(String parserName) {
        return (String)PARSERS.get(parserName);
    }

    public static String getParserName(String parserClassName) {
        Set keySet = PARSERS.keySet();
        for (String key : keySet) {
            if (!parserClassName.equals(PARSERS.get(key))) continue;
            return key;
        }
        return null;
    }

    public static String[] getInstalledClients() {
        String[] clients = new String[CLIENTS.size()];
        clients = CLIENTS.keySet().toArray(clients);
        return clients;
    }

    public static String getClientClassName(String clientName) {
        return (String)CLIENTS.get(clientName);
    }

    public static String getClientName(String clientClassName) {
        Set keySet = CLIENTS.keySet();
        for (String key : keySet) {
            if (!clientClassName.equals(CLIENTS.get(key))) continue;
            return key;
        }
        return null;
    }

    public void updateSessionTitle(FTPSession session) {
        int index = this.tabs.indexOfComponent(session);
        if (index < 0) {
            return;
        }
        String title = resources.getString("text.notConnected");
        String tooltip = null;
        if (session.isConnected()) {
            title = session.getRemoteHost().getName();
            tooltip = session.getRemoteHost().getHostName();
            if (title == null || title.trim().length() == 0) {
                title = tooltip;
            }
        }
        this.tabs.setTitleAt(index, title);
        this.tabs.setToolTipTextAt(index, tooltip);
    }

    public void showAboutDialog() {
        AboutDlg dlg = new AboutDlg(this);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    public void updateToolBar() {
        this.toolBar.updateButtons();
    }

    private void showLicenseAgreement() {
        String licenseAgreedForVersion = prefs.getLicenseAgreedForVersion();
        if (!"5.0.1".equals(licenseAgreedForVersion)) {
            LicenseAgreementDlg dlg = new LicenseAgreementDlg(this);
            dlg.setURL(this.getClass().getResource("license.html"));
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            boolean licenseAgreed = dlg.isLicenseAgreed();
            dlg.dispose();
            System.gc();
            if (!licenseAgreed) {
                System.exit(1);
            }
            prefs.setLicenseAgreedForVersion("5.0.1");
            try {
                JFTP.savePreferences(prefs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void selectAllLocalFiles() {
        FTPSession session = this.getCurrentSession();
        if (session != null) {
            session.selectAllLocalFiles();
        }
    }

    private void invertLocalFileSelection() {
        FTPSession session = this.getCurrentSession();
        if (session != null) {
            session.invertLocalFileSelection();
        }
    }

    private void selectAllRemoteFiles() {
        FTPSession session = this.getCurrentSession();
        if (session != null && session.isConnected()) {
            session.selectAllRemoteFiles();
        }
    }

    private void invertRemoteFileSelection() {
        FTPSession session = this.getCurrentSession();
        if (session != null && session.isConnected()) {
            session.invertRemoteFileSelection();
        }
    }

    static {
        transferTypes = null;
        THEMES = new TreeMap();
        THEMES.put("Default", "com.myjavaworld.gui.DefaultTheme");
        THEMES.put("Default - Large", "com.myjavaworld.gui.DefaultLargeTheme");
        THEMES.put("Green", "com.myjavaworld.gui.GreenMetalTheme");
        THEMES.put("Green - Large", "com.myjavaworld.gui.GreenMetalLargeTheme");
        THEMES.put("Sandstone", "com.myjavaworld.gui.SandstoneTheme");
        THEMES.put("Sandstone - Large", "com.myjavaworld.gui.SandstoneLargeTheme");
        THEMES.put("High Contrast", "com.myjavaworld.gui.HighContrastTheme");
        THEMES.put("High Contrast - Large", "com.myjavaworld.gui.HighContrastLargeTheme");
        CLIENTS = new TreeMap();
        CLIENTS.put("Default FTP Client", "com.myjavaworld.ftp.DefaultFTPClient");
        CLIENTS.put("AS/400 FTP Client", "com.myjavaworld.ftp.AS400FTPClient");
        PARSERS = new TreeMap();
        PARSERS.put("Default List Parser (Unix)", "com.myjavaworld.ftp.DefaultListParser");
        PARSERS.put("MS-DOS List Parser", "com.myjavaworld.ftp.DosListParser");
        try {
            prefs = JFTP.loadPreferences();
            transferTypes = prefs.getTransferTypes();
            JFTPUtil.updateProxySettings();
        }
        catch (IOException exp) {
            System.err.println("Failed to load the preferences. Using Defaults. ");
        }
    }
}

