/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.OSXAdapter;
import com.myjavaworld.util.SystemUtil;
import java.util.Locale;
import javax.swing.UIManager;

public class JFTPApplication {
    private JFTP jftp = null;

    public JFTPApplication() {
        if (SystemUtil.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JFTP");
            this.registerForMacOSXEvents();
        }
        Locale.setDefault(JFTP.prefs.getLocale());
        try {
            UIManager.setLookAndFeel(JFTP.prefs.getLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jftp = new JFTP();
        if (SystemUtil.isMac()) {
            OSXAdapter.enableFullScreenMode(this.jftp);
        }
        this.jftp.setVisible(true);
        this.jftp.newSession();
    }

    public static void main(String[] args) {
        new JFTPApplication();
    }

    public void showAboutDialog() {
        if (this.jftp != null) {
            this.jftp.showAboutDialog();
        }
    }

    public void showPreferencesDialog() {
        if (this.jftp != null) {
            this.jftp.showPreferencesDialog();
        }
    }

    public void quit() {
        if (this.jftp != null) {
            this.jftp.exit();
        }
    }

    private void registerForMacOSXEvents() {
        OSXAdapter.init(this);
    }
}

