/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.util.SystemUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class JFTPPreferences
implements Serializable {
    private static final long serialVersionUID = 4316033315068041786L;
    private static final String DEFAULT_SERVER_CERTIFICATE_STORE = JFTP.DATA_HOME + File.separator + "serverCertificates.jks";
    private static final String DEFAULT_CLIENT_CERTIFICATE_STORE = JFTP.DATA_HOME + File.separator + "clientCertificates.jks";
    private static final char[] DEFAULT_CERTIFICATE_STORE_PASSWORD = "changeit".toCharArray();
    private static final int DEFAULT_SOCKS_PROXY_PORT = 1080;
    private Locale locale = Locale.getDefault();
    private String laf = SystemUtil.isMac() || SystemUtil.getOSName().toUpperCase().startsWith("WIN") ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName();
    private String theme = "Default";
    private String localDirectory = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    private String email = "you@yourcompany.com";
    private String client = "com.myjavaworld.ftp.DefaultFTPClient";
    private String listParser = "com.myjavaworld.ftp.DefaultListParser";
    private int timeout = 300000;
    private int bufferSize = 65536;
    private int dateFormat = 3;
    private int timeFormat = 3;
    private int defaultTransferType = 2;
    private Map transferTypes = new TreeMap();
    private boolean passive = true;
    private boolean useJavaWindows = false;
    private int toolBarType = 0;
    private String serverCertificateStore = null;
    private String clientCertificateStore = null;
    private char[] serverCertificateStorePassword = null;
    private char[] clientCertificateStorePassword = null;
    private Boolean useProxy = null;
    private String proxyHost = null;
    private Integer proxyPort = null;
    private String proxyUser = null;
    private char[] proxyPassword = null;
    private Integer sslUsage = null;
    private Integer implicitSSLPort = null;
    private Boolean dataChannelUnencrypted = null;
    private Rectangle windowBounds = null;
    private Boolean licenseAgreed = null;
    private String licenseAgreedForVersion = null;
    private Boolean checkForUpdates = null;

    public JFTPPreferences() {
        this.transferTypes.put("ASP", new Integer(1));
        this.transferTypes.put("BAT", new Integer(1));
        this.transferTypes.put("C", new Integer(1));
        this.transferTypes.put("CONF", new Integer(1));
        this.transferTypes.put("CGI", new Integer(1));
        this.transferTypes.put("CPP", new Integer(1));
        this.transferTypes.put("CSS", new Integer(1));
        this.transferTypes.put("DHTML", new Integer(1));
        this.transferTypes.put("DTD", new Integer(1));
        this.transferTypes.put("H", new Integer(1));
        this.transferTypes.put("HTM", new Integer(1));
        this.transferTypes.put("HTML", new Integer(1));
        this.transferTypes.put("INI", new Integer(1));
        this.transferTypes.put("JAVA", new Integer(1));
        this.transferTypes.put("JHTML", new Integer(1));
        this.transferTypes.put("JS", new Integer(1));
        this.transferTypes.put("JSP", new Integer(1));
        this.transferTypes.put("LOG", new Integer(1));
        this.transferTypes.put("MV", new Integer(1));
        this.transferTypes.put("PHP", new Integer(1));
        this.transferTypes.put("PHTML", new Integer(1));
        this.transferTypes.put("PL", new Integer(1));
        this.transferTypes.put("SH", new Integer(1));
        this.transferTypes.put("SHTML", new Integer(1));
        this.transferTypes.put("TXT", new Integer(1));
        this.transferTypes.put("VBS", new Integer(1));
        this.transferTypes.put("XML", new Integer(1));
        this.transferTypes.put("XSD", new Integer(1));
        this.passive = true;
        this.useJavaWindows = false;
        this.toolBarType = 0;
        this.serverCertificateStore = DEFAULT_SERVER_CERTIFICATE_STORE;
        this.clientCertificateStore = DEFAULT_CLIENT_CERTIFICATE_STORE;
        this.serverCertificateStorePassword = DEFAULT_CERTIFICATE_STORE_PASSWORD;
        this.clientCertificateStorePassword = DEFAULT_CERTIFICATE_STORE_PASSWORD;
        this.useProxy = Boolean.FALSE;
        this.proxyHost = "";
        this.proxyPort = new Integer(1080);
        this.proxyUser = "";
        this.proxyPassword = new char[0];
        this.sslUsage = new Integer(0);
        this.implicitSSLPort = new Integer(990);
        this.dataChannelUnencrypted = Boolean.FALSE;
        this.checkForUpdates = Boolean.TRUE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLookAndFeelClassName(String laf) {
        this.laf = laf;
    }

    public String getLookAndFeelClassName() {
        return this.laf;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClient() {
        return this.client;
    }

    public void setListParser(String listParser) {
        this.listParser = listParser;
    }

    public String getListParser() {
        return this.listParser;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setDateFormat(int dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(int timeFormat) {
        this.timeFormat = timeFormat;
    }

    public int getTimeFormat() {
        return this.timeFormat;
    }

    public void setDefaultTransferType(int defaultTransferType) {
        this.defaultTransferType = defaultTransferType;
    }

    public int getDefaultTransferType() {
        return this.defaultTransferType;
    }

    public void setTransferTypes(Map transferTypes) {
        this.transferTypes = transferTypes;
    }

    public Map getTransferTypes() {
        return this.transferTypes;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setUseJavaWindows(boolean useJavaWindows) {
        this.useJavaWindows = useJavaWindows;
    }

    public boolean getUseJavaWindows() {
        return this.useJavaWindows;
    }

    public void setToolBarType(int toolBarType) {
        this.toolBarType = toolBarType;
    }

    public int getToolBarType() {
        return this.toolBarType;
    }

    public void setServerCertificateStore(String fileName) {
        this.serverCertificateStore = fileName;
    }

    public String getServerCertificateStore() {
        if (this.serverCertificateStore == null) {
            return DEFAULT_SERVER_CERTIFICATE_STORE;
        }
        return this.serverCertificateStore;
    }

    public void setClientCertificateStore(String fileName) {
        this.clientCertificateStore = fileName;
    }

    public String getClientCertificateStore() {
        if (this.clientCertificateStore == null) {
            return DEFAULT_CLIENT_CERTIFICATE_STORE;
        }
        return this.clientCertificateStore;
    }

    public void setServerCertificateStorePassword(char[] password) {
        this.serverCertificateStorePassword = password;
    }

    public char[] getServerCertificateStorePassword() {
        if (this.serverCertificateStorePassword == null) {
            return DEFAULT_CERTIFICATE_STORE_PASSWORD;
        }
        return this.serverCertificateStorePassword;
    }

    public void setClientCertificateStorePassword(char[] password) {
        this.clientCertificateStorePassword = password;
    }

    public char[] getClientCertificateStorePassword() {
        if (this.clientCertificateStorePassword == null) {
            return DEFAULT_CERTIFICATE_STORE_PASSWORD;
        }
        return this.clientCertificateStorePassword;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = new Boolean(useProxy);
    }

    public boolean isUseProxy() {
        if (this.useProxy != null) {
            return this.useProxy;
        }
        return false;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost;
        }
        return "";
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = new Integer(proxyPort);
    }

    public int getProxyPort() {
        if (this.proxyPort != null) {
            return this.proxyPort;
        }
        return 1080;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyUser() {
        if (this.proxyUser != null) {
            return this.proxyUser;
        }
        return "";
    }

    public void setProxyPassword(char[] proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public char[] getProxyPassword() {
        if (this.proxyPassword != null) {
            return this.proxyPassword;
        }
        return new char[0];
    }

    public void setSSLUsage(int sslUsage) {
        this.sslUsage = new Integer(sslUsage);
    }

    public int getSSLUsage() {
        if (this.sslUsage != null) {
            return this.sslUsage;
        }
        return 0;
    }

    public void setImplicitSSLPort(int implicitSSLPort) {
        this.implicitSSLPort = new Integer(implicitSSLPort);
    }

    public int getImplicitSSLPort() {
        if (this.implicitSSLPort != null) {
            return this.implicitSSLPort;
        }
        return 990;
    }

    public void setDataChannelUnencrypted(boolean dataChannelUnencrypted) {
        this.dataChannelUnencrypted = new Boolean(dataChannelUnencrypted);
    }

    public boolean isDataChannelUnencrypted() {
        if (this.dataChannelUnencrypted != null) {
            return this.dataChannelUnencrypted;
        }
        return false;
    }

    public void setWindowBounds(Rectangle windowBounds) {
        this.windowBounds = windowBounds;
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public void setLicenseAgreed(boolean licenseAgreed) {
        this.licenseAgreed = new Boolean(licenseAgreed);
    }

    public boolean isLicenseAgreed() {
        if (this.licenseAgreed == null) {
            return false;
        }
        return this.licenseAgreed;
    }

    public String getLicenseAgreedForVersion() {
        if (this.licenseAgreedForVersion == null) {
            return "";
        }
        return this.licenseAgreedForVersion;
    }

    public void setLicenseAgreedForVersion(String licenseAgreedForVersion) {
        this.licenseAgreedForVersion = licenseAgreedForVersion;
    }

    public boolean getCheckForUpdates() {
        if (this.checkForUpdates == null) {
            return true;
        }
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = new Boolean(checkForUpdates);
    }
}

