/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MButton;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.actions.AbortAction;
import com.myjavaworld.jftp.actions.ChangeLocalDirectoryAction;
import com.myjavaworld.jftp.actions.ChangeRemoteDirectoryAction;
import com.myjavaworld.jftp.actions.ConnectAction;
import com.myjavaworld.jftp.actions.DeleteLocalFileAction;
import com.myjavaworld.jftp.actions.DeleteRemoteFileAction;
import com.myjavaworld.jftp.actions.DisconnectAction;
import com.myjavaworld.jftp.actions.DownloadAction;
import com.myjavaworld.jftp.actions.ManageCertificatesAction;
import com.myjavaworld.jftp.actions.ManageFavoritesAction;
import com.myjavaworld.jftp.actions.NewLocalDirectoryAction;
import com.myjavaworld.jftp.actions.NewLocalFileAction;
import com.myjavaworld.jftp.actions.NewRemoteDirectoryAction;
import com.myjavaworld.jftp.actions.NewRemoteFileAction;
import com.myjavaworld.jftp.actions.NewSessionAction;
import com.myjavaworld.jftp.actions.ReconnectAction;
import com.myjavaworld.jftp.actions.RenameLocalFileAction;
import com.myjavaworld.jftp.actions.RenameRemoteFileAction;
import com.myjavaworld.jftp.actions.UploadAction;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class JFTPToolBar
extends JToolBar {
    private static final String HELP_ID_HOME = "index";
    private JFTP jftp = null;
    private MButton butNewSession = null;
    private MButton butConnect = null;
    private MButton butDisconnect = null;
    private MButton butReconnect = null;
    private MButton butAbort = null;
    private MButton butUpload = null;
    private MButton butDownload = null;
    private MButton butNewLocalFile = null;
    private MButton butNewLocalDirectory = null;
    private MButton butChangeLocalDirectory = null;
    private MButton butRenameLocalFile = null;
    private MButton butDeleteLocalFile = null;
    private MButton butNewRemoteFile = null;
    private MButton butNewRemoteDirectory = null;
    private MButton butChangeRemoteDirectory = null;
    private MButton butRenameRemoteFile = null;
    private MButton butDeleteRemoteFile = null;
    private MButton butManageFavorites = null;
    private MButton butManageCertificates = null;
    private MButton butHelp = null;

    public JFTPToolBar(JFTP jftp) {
        super(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jftp = jftp;
        this.setFloatable(false);
        this.setRollover(true);
        this.prepareToolBar();
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    private void prepareToolBar() {
        ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.JFTPToolBar");
        this.butNewSession = new MButton();
        this.butNewSession.setIcon(JFTPUtil.getIcon("newSession16.gif"));
        this.butNewSession.setToolTipText(resources.getString("tooltip.newSession"));
        this.butNewSession.addActionListener(NewSessionAction.getInstance(this.jftp));
        this.butConnect = new MButton();
        this.butConnect.setIcon(JFTPUtil.getIcon("connect16.gif"));
        this.butConnect.setToolTipText(resources.getString("tooltip.connect"));
        this.butConnect.addActionListener(ConnectAction.getInstance(this.jftp));
        this.butDisconnect = new MButton();
        this.butDisconnect.setIcon(JFTPUtil.getIcon("disconnect16.gif"));
        this.butDisconnect.setToolTipText(resources.getString("tooltip.disconnect"));
        this.butDisconnect.addActionListener(DisconnectAction.getInstance(this.jftp));
        this.butReconnect = new MButton();
        this.butReconnect.setIcon(JFTPUtil.getIcon("reconnect16.gif"));
        this.butReconnect.setToolTipText(resources.getString("tooltip.reconnect"));
        this.butReconnect.addActionListener(ReconnectAction.getInstance(this.jftp));
        this.butAbort = new MButton();
        this.butAbort.setIcon(JFTPUtil.getIcon("abort16.gif"));
        this.butAbort.setToolTipText(resources.getString("tooltip.abort"));
        this.butAbort.addActionListener(AbortAction.getInstance(this.jftp));
        this.butUpload = new MButton();
        this.butUpload.setIcon(JFTPUtil.getIcon("upload16.gif"));
        this.butUpload.setToolTipText(resources.getString("tooltip.upload"));
        this.butUpload.addActionListener(UploadAction.getInstance(this.jftp));
        this.butDownload = new MButton();
        this.butDownload.setIcon(JFTPUtil.getIcon("download16.gif"));
        this.butDownload.setToolTipText(resources.getString("tooltip.download"));
        this.butDownload.addActionListener(DownloadAction.getInstance(this.jftp));
        this.butNewLocalFile = new MButton();
        this.butNewLocalFile.setIcon(JFTPUtil.getIcon("newLocalFile16.gif"));
        this.butNewLocalFile.setToolTipText(resources.getString("tooltip.newLocalFile"));
        this.butNewLocalFile.addActionListener(NewLocalFileAction.getInstance(this.jftp));
        this.butNewLocalDirectory = new MButton();
        this.butNewLocalDirectory.setIcon(JFTPUtil.getIcon("newLocalDirectory16.gif"));
        this.butNewLocalDirectory.setToolTipText(resources.getString("tooltip.newLocalDirectory"));
        this.butNewLocalDirectory.addActionListener(NewLocalDirectoryAction.getInstance(this.jftp));
        this.butChangeLocalDirectory = new MButton();
        this.butChangeLocalDirectory.setIcon(JFTPUtil.getIcon("changeLocalDirectory16.gif"));
        this.butChangeLocalDirectory.setToolTipText(resources.getString("tooltip.changeLocalDirectory"));
        this.butChangeLocalDirectory.addActionListener(ChangeLocalDirectoryAction.getInstance(this.jftp));
        this.butRenameLocalFile = new MButton();
        this.butRenameLocalFile.setIcon(JFTPUtil.getIcon("renameLocalFile16.gif"));
        this.butRenameLocalFile.setToolTipText(resources.getString("tooltip.renameLocalFile"));
        this.butRenameLocalFile.addActionListener(RenameLocalFileAction.getInstance(this.jftp));
        this.butDeleteLocalFile = new MButton();
        this.butDeleteLocalFile.setIcon(JFTPUtil.getIcon("deleteLocalFile16.gif"));
        this.butDeleteLocalFile.setToolTipText(resources.getString("tooltip.deleteLocalFiles"));
        this.butDeleteLocalFile.addActionListener(DeleteLocalFileAction.getInstance(this.jftp));
        this.butNewRemoteFile = new MButton();
        this.butNewRemoteFile.setIcon(JFTPUtil.getIcon("newRemoteFile16.gif"));
        this.butNewRemoteFile.setToolTipText(resources.getString("tooltip.newRemoteFile"));
        this.butNewRemoteFile.addActionListener(NewRemoteFileAction.getInstance(this.jftp));
        this.butNewRemoteDirectory = new MButton();
        this.butNewRemoteDirectory.setIcon(JFTPUtil.getIcon("newRemoteDirectory16.gif"));
        this.butNewRemoteDirectory.setToolTipText(resources.getString("tooltip.newRemoteDirectory"));
        this.butNewRemoteDirectory.addActionListener(NewRemoteDirectoryAction.getInstance(this.jftp));
        this.butChangeRemoteDirectory = new MButton();
        this.butChangeRemoteDirectory.setIcon(JFTPUtil.getIcon("changeRemoteDirectory16.gif"));
        this.butChangeRemoteDirectory.setToolTipText(resources.getString("tooltip.changeRemoteDirectory"));
        this.butChangeRemoteDirectory.addActionListener(ChangeRemoteDirectoryAction.getInstance(this.jftp));
        this.butRenameRemoteFile = new MButton();
        this.butRenameRemoteFile.setIcon(JFTPUtil.getIcon("renameRemoteFile16.gif"));
        this.butRenameRemoteFile.setToolTipText(resources.getString("tooltip.renameRemoteFile"));
        this.butRenameRemoteFile.addActionListener(RenameRemoteFileAction.getInstance(this.jftp));
        this.butDeleteRemoteFile = new MButton();
        this.butDeleteRemoteFile.setIcon(JFTPUtil.getIcon("deleteRemoteFile16.gif"));
        this.butDeleteRemoteFile.setToolTipText(resources.getString("tooltip.deleteRemoteFiles"));
        this.butDeleteRemoteFile.addActionListener(DeleteRemoteFileAction.getInstance(this.jftp));
        this.butManageFavorites = new MButton();
        this.butManageFavorites.setIcon(JFTPUtil.getIcon("favorites16.gif"));
        this.butManageFavorites.setToolTipText(resources.getString("tooltip.manageFavorites"));
        this.butManageFavorites.addActionListener(ManageFavoritesAction.getInstance(this.jftp));
        this.butManageCertificates = new MButton();
        this.butManageCertificates.setIcon(JFTPUtil.getIcon("certificate16.gif"));
        this.butManageCertificates.setToolTipText(resources.getString("tooltip.manageCertificates"));
        this.butManageCertificates.addActionListener(ManageCertificatesAction.getInstance(this.jftp));
        this.butHelp = new MButton();
        this.butHelp.setIcon(JFTPUtil.getIcon("help16.gif"));
        this.butHelp.setToolTipText(resources.getString("tooltip.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID_HOME);
        this.add(this.butNewSession);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butConnect);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butDisconnect);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butReconnect);
        this.addSeparator();
        this.add(this.butDownload);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butUpload);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butAbort);
        this.addSeparator();
        this.add(this.butNewLocalFile);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butNewLocalDirectory);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butChangeLocalDirectory);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butRenameLocalFile);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butDeleteLocalFile);
        this.addSeparator();
        this.add(this.butNewRemoteFile);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butNewRemoteDirectory);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butChangeRemoteDirectory);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butRenameRemoteFile);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.butDeleteRemoteFile);
        this.addSeparator();
        this.add(this.butManageFavorites);
        this.add(this.butManageCertificates);
        this.addSeparator();
        this.add(this.butHelp);
    }

    public JButton add(Action action) {
        JButton b = super.add(action);
        b.setFocusPainted(false);
        return b;
    }

    protected JButton createActionComponent(Action a) {
        JButton b = super.createActionComponent(a);
        return b;
    }

    public void updateButtons() {
        FTPSession session = this.jftp.getCurrentSession();
        boolean nullSession = session == null;
        boolean connected = !nullSession && session.isConnected();
        int localFileSelectionCount = 0;
        if (!nullSession) {
            localFileSelectionCount = session.getLocalFileSelectionCount();
        }
        int remoteFileSelectionCount = 0;
        if (connected) {
            remoteFileSelectionCount = session.getRemoteFileSelectionCount();
        }
        this.butConnect.setEnabled(!nullSession && !connected);
        this.butDisconnect.setEnabled(connected);
        this.butReconnect.setEnabled(!nullSession && session.getRemoteHost() != null);
        this.butAbort.setEnabled(connected);
        this.butDownload.setEnabled(connected && remoteFileSelectionCount > 0);
        this.butUpload.setEnabled(connected && localFileSelectionCount > 0);
        this.butNewLocalFile.setEnabled(!nullSession);
        this.butNewLocalDirectory.setEnabled(!nullSession);
        this.butChangeLocalDirectory.setEnabled(!nullSession);
        this.butRenameLocalFile.setEnabled(!nullSession && localFileSelectionCount == 1);
        this.butDeleteLocalFile.setEnabled(!nullSession && localFileSelectionCount > 0);
        this.butNewRemoteFile.setEnabled(connected);
        this.butNewRemoteDirectory.setEnabled(connected);
        this.butChangeRemoteDirectory.setEnabled(connected);
        this.butRenameRemoteFile.setEnabled(connected && remoteFileSelectionCount == 1);
        this.butDeleteRemoteFile.setEnabled(connected && remoteFileSelectionCount > 0);
    }
}

