/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.util.Filter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class LocalFile
implements Serializable {
    private static final long serialVersionUID = -3450118298480840794L;
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    private File file = null;
    private String name = null;
    private String extension = null;
    private long size = 0L;
    private long lastModified = 0L;
    private boolean dir = false;
    private String displayName = null;

    public LocalFile(File file) {
        int index;
        this.file = file;
        this.name = file.getName();
        this.displayName = fsv.getSystemDisplayName(file);
        this.size = file.length();
        this.lastModified = file.lastModified();
        this.dir = file.isDirectory();
        this.extension = this.dir ? null : ((index = this.name.lastIndexOf(".")) < 0 || index == this.name.length() - 1 ? "" : this.name.substring(index + 1).toUpperCase());
    }

    public File getFile() {
        return this.file;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public LocalFile getAbsoluteFile() {
        return new LocalFile(this.file.getAbsoluteFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public LocalFile getCanonicalFile() throws IOException {
        return new LocalFile(this.file.getCanonicalFile());
    }

    public String getNameOld() {
        return this.file.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getTypeOld() {
        if (this.extension == null) {
            return "Directory";
        }
        if (this.extension.length() > 0) {
            return this.extension + " File";
        }
        return "File";
    }

    public String getType() {
        String type = fsv.getSystemTypeDescription(this.file);
        if (type == null) {
            return this.getTypeOld();
        }
        return type;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isDirectory() {
        return this.dir;
    }

    public boolean isFile() {
        return !this.dir;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public LocalFile getParentOld() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return null;
        }
        return new LocalFile(parent);
    }

    public LocalFile getParent() {
        File parent = fsv.getParentDirectory(this.file);
        if (parent == null) {
            return null;
        }
        return new LocalFile(parent);
    }

    public LocalFile[] listOld() {
        File[] f = this.file.listFiles();
        if (f == null) {
            return null;
        }
        LocalFile[] children = new LocalFile[f.length];
        for (int i = 0; i < f.length; ++i) {
            children[i] = new LocalFile(f[i]);
        }
        return children;
    }

    public LocalFile[] list() {
        File[] f = fsv.getFiles(this.file, false);
        if (f == null) {
            return null;
        }
        LocalFile[] children = new LocalFile[f.length];
        for (int i = 0; i < f.length; ++i) {
            children[i] = new LocalFile(f[i]);
        }
        return children;
    }

    public LocalFile[] listOld(Filter filter) {
        if (filter == null) {
            return this.list();
        }
        LocalFile[] f = this.list();
        if (f == null) {
            return null;
        }
        ArrayList<LocalFile> list = new ArrayList<LocalFile>(f.length);
        for (int i = 0; i < f.length; ++i) {
            if (!filter.accept(f[i])) continue;
            list.add(f[i]);
        }
        LocalFile[] children = new LocalFile[list.size()];
        children = list.toArray(children);
        return children;
    }

    public LocalFile[] list(Filter filter) {
        if (filter == null) {
            return this.list();
        }
        LocalFile[] f = this.list();
        if (f == null) {
            return null;
        }
        ArrayList<LocalFile> list = new ArrayList<LocalFile>(f.length);
        for (int i = 0; i < f.length; ++i) {
            if (!filter.accept(f[i])) continue;
            list.add(f[i]);
        }
        LocalFile[] children = new LocalFile[list.size()];
        children = list.toArray(children);
        return children;
    }

    public static LocalFile[] listRoots() {
        File[] f = fsv.getRoots();
        if (f == null) {
            return null;
        }
        LocalFile[] roots = new LocalFile[f.length];
        for (int i = 0; i < f.length; ++i) {
            roots[i] = new LocalFile(f[i]);
        }
        return roots;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalFile)) {
            return false;
        }
        LocalFile that = (LocalFile)obj;
        return this.file.equals(that.file);
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        LocalFile that = (LocalFile)obj;
        return this.name.toUpperCase().compareTo(that.name.toUpperCase());
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public Icon getIcon() {
        return fsv.getSystemIcon(this.file);
    }

    public boolean isTraversable() {
        return fsv.isTraversable(this.file);
    }

    public boolean delete() {
        return this.file.delete();
    }

    public boolean isDrive() {
        return fsv.isFileSystemRoot(this.file);
    }
}

