/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.LocalFile;
import java.util.Comparator;

public class LocalFileComparator
implements Comparator {
    public static final int COMPARE_BY_NAME = 1;
    public static final int COMPARE_BY_TYPE = 2;
    public static final int COMPARE_BY_SIZE = 3;
    public static final int COMPARE_BY_DATE = 4;
    public static final int ASC_ORDER = 1;
    public static final int DESC_ORDER = 2;
    private int compareBy = 0;
    private int order = 0;

    public LocalFileComparator() {
        this(1, 1);
    }

    public LocalFileComparator(int compareBy) {
        this(compareBy, 1);
    }

    public LocalFileComparator(int compareBy, int order) {
        this.setCompareBy(compareBy);
        this.setOrder(order);
    }

    public void setCompareBy(int compareBy) {
        this.compareBy = compareBy;
    }

    public int getCompareBy() {
        return this.compareBy;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public int compare(Object o1, Object o2) {
        LocalFile l1 = (LocalFile)o1;
        LocalFile l2 = (LocalFile)o2;
        if (this.compareBy == 1) {
            return this.compareByName(l1, l2);
        }
        if (this.compareBy == 3) {
            return this.compareBySize(l1, l2);
        }
        if (this.compareBy == 4) {
            return this.compareByDate(l1, l2);
        }
        return this.compareByType(l1, l2);
    }

    private int compareByName(LocalFile l1, LocalFile l2) {
        int retVal = 0;
        if (l1.isDrive() && !l2.isDrive()) {
            retVal = -1;
        } else if (!l1.isDrive() && l2.isDrive()) {
            retVal = 1;
        } else if (l1.isDirectory() && !l2.isDirectory()) {
            retVal = -1;
        } else if (!l1.isDirectory() && l2.isDirectory()) {
            retVal = 1;
        } else {
            String name1 = l1.isDrive() ? l1.getAbsolutePath() : l1.getDisplayName();
            String name2 = l2.isDrive() ? l2.getAbsolutePath() : l2.getDisplayName();
            retVal = name1.toUpperCase().compareTo(name2.toUpperCase());
        }
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareBySize(LocalFile l1, LocalFile l2) {
        int retVal = 0;
        if (l1.isDirectory() && !l2.isDirectory()) {
            retVal = -1;
        } else if (!l1.isDirectory() && l2.isDirectory()) {
            retVal = 1;
        } else {
            if (l1.getSize() == l2.getSize()) {
                retVal = 0;
            } else {
                int n = retVal = l1.getSize() < l2.getSize() ? -1 : 1;
            }
            if (retVal == 0) {
                String name1 = l1.isDrive() ? l1.getAbsolutePath() : l1.getDisplayName();
                String name2 = l2.isDrive() ? l2.getAbsolutePath() : l2.getDisplayName();
                retVal = name1.toUpperCase().compareTo(name2.toUpperCase());
            }
        }
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareByDate(LocalFile l1, LocalFile l2) {
        int retVal = 0;
        retVal = l1.isDirectory() && !l2.isDirectory() ? -1 : (!l1.isDirectory() && l2.isDirectory() ? 1 : (l1.getLastModified() == l2.getLastModified() ? 0 : (l1.getLastModified() < l2.getLastModified() ? -1 : 1)));
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareByType(LocalFile l1, LocalFile l2) {
        int retVal = 0;
        if (l1.isDirectory() && !l2.isDirectory()) {
            retVal = -1;
        } else if (!l1.isDirectory() && l2.isDirectory()) {
            retVal = 1;
        } else {
            retVal = l1.getType().compareTo(l2.getType());
            if (retVal == 0) {
                String name1 = l1.isDrive() ? l1.getAbsolutePath() : l1.getDisplayName();
                String name2 = l2.isDrive() ? l2.getAbsolutePath() : l2.getDisplayName();
                retVal = name1.toUpperCase().compareTo(name2.toUpperCase());
            }
        }
        return this.order == 1 ? retVal : -retVal;
    }
}

