/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.util.DateFilter;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.RegexFilter;

public class LocalFileFilter
implements Filter {
    private RegexFilter regexFilter = null;
    private DateFilter dateFilter = null;
    private boolean showHiddenFiles = true;
    private boolean exclusionFilter = false;

    public LocalFileFilter() {
        this(null, null, true, false);
    }

    public LocalFileFilter(RegexFilter regexFilter, DateFilter dateFilter) {
        this(regexFilter, dateFilter, true, false);
    }

    public LocalFileFilter(RegexFilter regexFilter, DateFilter dateFilter, boolean showHiddenFiles) {
        this(regexFilter, dateFilter, showHiddenFiles, false);
    }

    public LocalFileFilter(RegexFilter regexFilter, DateFilter dateFilter, boolean showHiddenFiles, boolean exclusionFilter) {
        this.setRegexFilter(regexFilter);
        this.setDateFilter(dateFilter);
        this.setShowHiddenFiles(showHiddenFiles);
        this.setExclusionFilter(exclusionFilter);
    }

    public DateFilter getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(DateFilter dateFilter) {
        this.dateFilter = dateFilter;
    }

    public RegexFilter getRegexFilter() {
        return this.regexFilter;
    }

    public void setRegexFilter(RegexFilter regexFilter) {
        this.regexFilter = regexFilter;
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }

    public void setExclusionFilter(boolean exclusionFilter) {
        this.exclusionFilter = exclusionFilter;
    }

    public boolean isExclusionFilter() {
        return this.exclusionFilter;
    }

    public boolean accept(Object value) {
        LocalFile lf = (LocalFile)value;
        if (!this.showHiddenFiles && lf.isHidden()) {
            return this.exclusionFilter;
        }
        if (lf.isFile()) {
            if (this.regexFilter != null && !this.regexFilter.accept(lf.getName())) {
                return this.exclusionFilter;
            }
            if (this.dateFilter != null && !this.dateFilter.accept(new Long(lf.getLastModified()))) {
                return this.exclusionFilter;
            }
            return !this.exclusionFilter;
        }
        return true;
    }
}

