/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MRadioButton;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.LocalFileFilter;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.DateFilter;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.RegexFilter;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class LocalFileFilterDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalFileFilterDlg");
    private static final String HELP_ID = "local.filter";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
    private MRadioButton radioInclusionFilter = null;
    private MRadioButton radioExclusionFilter = null;
    private MTextField tfRegexFilter = null;
    private MCheckBox cbCaseSensitive = null;
    private MTextField tfStartDate = null;
    private MTextField tfEndDate = null;
    private MCheckBox cbShowHiddenFiles = null;
    private MButton butApply = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private boolean approved = false;

    public LocalFileFilterDlg(Frame parent) {
        super(parent);
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setFilter(Filter filter) {
        if (filter != null) {
            LocalFileFilter lff = (LocalFileFilter)filter;
            this.radioExclusionFilter.setSelected(lff.isExclusionFilter());
            RegexFilter regexFilter = lff.getRegexFilter();
            DateFilter dateFilter = lff.getDateFilter();
            if (regexFilter != null) {
                this.tfRegexFilter.setText(regexFilter.getPattern().pattern());
                this.cbCaseSensitive.setSelected((regexFilter.getPattern().flags() & 2) == 0);
            }
            if (dateFilter != null) {
                Date startDate = dateFilter.getStartDate();
                Date endDate = dateFilter.getEndDate();
                if (startDate != null) {
                    this.tfStartDate.setText(SDF.format(startDate));
                }
                if (endDate != null) {
                    this.tfEndDate.setText(SDF.format(endDate));
                }
            }
            this.cbShowHiddenFiles.setSelected(lff.isShowHiddenFiles());
        } else {
            this.cbShowHiddenFiles.setSelected(true);
        }
    }

    public Filter getFilter() {
        if (!this.approved) {
            return null;
        }
        try {
            return new LocalFileFilter(this.getRegexFilter(), this.getDateFilter(), this.cbShowHiddenFiles.isSelected(), this.radioExclusionFilter.isSelected());
        }
        catch (Exception exp) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butCancel) {
            this.setVisible(false);
        } else if (evt.getSource() == this.butApply) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.setVisible(false);
        }
    }

    public void windowOpened(WindowEvent evt) {
        this.tfRegexFilter.requestFocusInWindow();
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private boolean validateInput() {
        String error = null;
        Component errorComponent = null;
        try {
            this.getRegexFilter();
            this.getDateFilter();
        }
        catch (PatternSyntaxException exp) {
            MessageFormat mf = new MessageFormat(resources.getString("error.pattern.invalid"));
            error = mf.format(new Object[]{exp.getMessage()});
            errorComponent = this.tfRegexFilter;
        }
        catch (ParseException exp) {
            MessageFormat mf = new MessageFormat(resources.getString("error.date.invalid"));
            error = mf.format(new Object[]{exp.getMessage()});
            errorComponent = this.tfStartDate;
        }
        if (error != null) {
            GUIUtil.showError((Component)this, error);
            if (errorComponent != null) {
                errorComponent.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private RegexFilter getRegexFilter() {
        String strPattern = this.tfRegexFilter.getText().trim();
        if (strPattern.length() == 0) {
            return null;
        }
        return new RegexFilter(strPattern, this.cbCaseSensitive.isSelected() ? 0 : 2);
    }

    private DateFilter getDateFilter() throws ParseException {
        String strStartDate = this.tfStartDate.getText().trim();
        String strEndDate = this.tfEndDate.getText().trim();
        if (strStartDate.length() == 0 && strEndDate.length() == 0) {
            return null;
        }
        Date startDate = null;
        Date endDate = null;
        if (strStartDate.length() > 0) {
            startDate = SDF.parse(strStartDate);
        }
        if (strEndDate.length() > 0) {
            endDate = SDF.parse(strEndDate);
        }
        return new DateFilter(startDate, endDate);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add(this.getFilterTypePanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getFileNameFilterPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getDateFilterPanel(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getAttributesFilterPanel(), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        c.anchor = 14;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getFilterTypePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.filterType")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.radioInclusionFilter = new MRadioButton(resources.getString("text.inclusionFilter"), true);
        this.radioExclusionFilter = new MRadioButton(resources.getString("text.exclusionFilter"), false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioInclusionFilter);
        bg.add(this.radioExclusionFilter);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)this.radioInclusionFilter, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 0, 6, 6);
        panel.add((Component)this.radioExclusionFilter, c);
        return panel;
    }

    private Component getFileNameFilterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.nameFilter")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MLabel labFileNameFilter = new MLabel(resources.getString("text.regexFilter"));
        this.tfRegexFilter = new MTextField(30);
        this.cbCaseSensitive = new MCheckBox(resources.getString("text.caseSensitive"), false);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)labFileNameFilter, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)this.tfRegexFilter, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)this.cbCaseSensitive, c);
        return panel;
    }

    private Component getDateFilterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.dateFilter")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MessageFormat mf = new MessageFormat(resources.getString("text.dateFilter"));
        MLabel labDateFilter = new MLabel(mf.format(new Object[]{"yyyy-mm-dd"}));
        MLabel labStartDate = new MLabel(resources.getString("text.start"));
        MLabel labEndDate = new MLabel(resources.getString("text.end"));
        this.tfStartDate = new MTextField(10);
        this.tfEndDate = new MTextField(10);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)labDateFilter, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)labStartDate, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)this.tfStartDate, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)labEndDate, c);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)this.tfEndDate, c);
        return panel;
    }

    private Component getAttributesFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.attributesFilter")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.cbShowHiddenFiles = new MCheckBox(resources.getString("text.showHiddenFiles"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)this.cbShowHiddenFiles, c);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butApply = new MButton(CommonResources.getString("text.apply"));
        this.butApply.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butApply);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butApply);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

