/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MLabelTextField;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileSystemView;

public class LocalFilePropertiesDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalFilePropertiesDlg");
    private static final String HELP_ID = "local.properties";
    private LocalFile file = null;
    private MLabelTextField tfFileName = null;
    private MLabelTextField tfFullPath = null;
    private MLabelTextField tfType = null;
    private MLabelTextField tfSize = null;
    private MLabelTextField tfLastModified = null;
    private MLabelTextField tfContents = null;
    private JCheckBox cbRead = null;
    private JCheckBox cbWrite = null;
    private JCheckBox cbHidden = null;
    private MButton butClose = null;
    private MButton butHelp = null;
    private int dirCount = -1;
    private int fileCount = 0;
    private long totalSize = 0L;
    private MessageFormat sizeFormatter = null;
    private MessageFormat contentsFormatter = null;
    private boolean closing = false;
    private Filter filter = null;

    public LocalFilePropertiesDlg(Frame parent, LocalFile file, Filter filter) {
        super(parent, "", true);
        this.file = file;
        this.filter = filter;
        this.totalSize = file.getSize();
        this.getContentPane().setLayout(new GridBagLayout());
        this.sizeFormatter = new MessageFormat(resources.getString("value.size"));
        this.contentsFormatter = new MessageFormat(resources.getString("value.contents"));
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.updateTitle();
        this.populateScreen();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butClose) {
            this.close();
        }
    }

    public void windowClosing(WindowEvent evt) {
        this.close();
    }

    public void windowOpened(WindowEvent evt) {
        if (this.file.isDirectory()) {
            this.start();
        }
    }

    protected void escape() {
        this.close();
    }

    private void start() {
        this.dirCount = -1;
        this.fileCount = 0;
        this.totalSize = 0L;
        this.closing = false;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                LocalFilePropertiesDlg.this.computeSizeAndContents(LocalFilePropertiesDlg.this.file);
                return null;
            }

            public void finished() {
                LocalFilePropertiesDlg.this.updateSizeAndContents();
            }
        };
        worker.start();
    }

    private void updateTitle() {
        MessageFormat titleFormatter = new MessageFormat(resources.getString("title.dialog"));
        String title = titleFormatter.format(new Object[]{this.file.getDisplayName()});
        this.setTitle(title);
    }

    private void close() {
        this.closing = true;
        this.setVisible(false);
    }

    private void populateScreen() {
        this.tfFileName.setText(this.file.getDisplayName());
        try {
            this.tfFullPath.setText(this.file.getFile().getCanonicalPath());
        }
        catch (IOException exp) {
            this.tfFullPath.setText(this.file.getFile().getAbsolutePath());
        }
        this.tfType.setText(this.file.getType());
        String size = this.sizeFormatter.format(new Long[]{new Long(this.totalSize)});
        this.tfSize.setText(size);
        DateFormat df = DateFormat.getDateTimeInstance(0, 2);
        Date lastModified = new Date(this.file.getLastModified());
        this.tfLastModified.setText(df.format(lastModified));
    }

    private void updateSizeAndContents() {
        String size = this.sizeFormatter.format(new Long[]{new Long(this.totalSize)});
        this.tfSize.setText(size);
        if (this.tfContents != null) {
            String contents = this.contentsFormatter.format(new Long[]{new Long(this.dirCount), new Long(this.fileCount)});
            this.tfContents.setText(contents);
        }
    }

    private void computeSizeAndContents(LocalFile file) {
        if (this.closing) {
            return;
        }
        if (file.isFile()) {
            ++this.fileCount;
            this.totalSize += file.getSize();
        } else if (file.isDirectory()) {
            if (this.closing) {
                return;
            }
            ++this.dirCount;
            this.totalSize += file.getSize();
            LocalFile[] children = file.list(this.filter);
            for (int i = 0; i < children.length; ++i) {
                this.computeSizeAndContents(children[i]);
            }
        }
        this.updateSizeAndContents();
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        int row = 0;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        MLabel labIcon = new MLabel();
        labIcon.setHorizontalAlignment(2);
        FileSystemView view = FileSystemView.getFileSystemView();
        labIcon.setIcon(view.getSystemIcon(this.file.getFile()));
        this.getContentPane().add((Component)labIcon, c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.tfFileName = new MLabelTextField(30);
        this.tfFileName.setText(this.file.getDisplayName());
        this.getContentPane().add((Component)this.tfFileName, c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.fullPath")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfFullPath = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfFullPath, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.type")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfType = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfType, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.size")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfSize = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfSize, c);
        if (this.file.isDirectory()) {
            c.gridx = 0;
            c.gridy = row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 12, 12, 12);
            this.getContentPane().add((Component)new MLabel(resources.getString("text.contents")), c);
            c.gridx = 1;
            c.gridy = row++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 12, 12);
            this.tfContents = new MLabelTextField(20);
            this.getContentPane().add((Component)this.tfContents, c);
        }
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.lastModified")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfLastModified = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfLastModified, c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getAttributesPanel(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(6, 12, 11, 11);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getAttributesPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 3, 10, 3));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("title.attributes")));
        this.cbRead = new JCheckBox(resources.getString("text.read"), this.file.canRead());
        this.cbWrite = new JCheckBox(resources.getString("text.write"), this.file.canWrite());
        this.cbHidden = new JCheckBox(resources.getString("text.hidden"), this.file.isHidden());
        this.cbRead.setEnabled(false);
        this.cbWrite.setEnabled(false);
        this.cbHidden.setEnabled(false);
        panel.add(this.cbRead);
        panel.add(this.cbWrite);
        panel.add(this.cbHidden);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butClose = new MButton(CommonResources.getString("text.close"));
        this.butClose.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butClose);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butClose);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

