/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.util.ResourceLoader;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class LocalFileTableModel
extends AbstractTableModel {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalFileTableModel");
    private static final String[] COLUMN_NAMES = new String[]{resources.getString("text.name"), resources.getString("text.type"), resources.getString("text.size"), resources.getString("text.lastModified")};
    private LocalFile[] data = null;

    public LocalFileTableModel() {
        this(new LocalFile[0]);
    }

    public LocalFileTableModel(LocalFile[] data) {
        this.setData(data);
    }

    public void setData(LocalFile[] data) {
        if (data == null) {
            data = new LocalFile[]{};
        }
        this.data = data;
        this.fireTableDataChanged();
    }

    public LocalFile[] getData() {
        return this.data;
    }

    public LocalFile getFileAt(int row) {
        return this.data[row];
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public int getRowCount() {
        return this.data.length;
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.data[row];
        }
        if (col == 1) {
            return this.data[row].getType();
        }
        if (col == 2) {
            return new Long(this.data[row].getSize());
        }
        return new Date(this.data[row].getLastModified());
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return LocalFile.class;
        }
        if (col == 2) {
            return Long.class;
        }
        if (col == 3) {
            return Date.class;
        }
        return Object.class;
    }
}

