/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.DateCellRenderer;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.IndentIcon;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTable;
import com.myjavaworld.gui.MTableCellRenderer;
import com.myjavaworld.gui.MTableHeaderRenderer;
import com.myjavaworld.gui.NumericCellRenderer;
import com.myjavaworld.jftp.DnDTransferHandler;
import com.myjavaworld.jftp.DriveCellRenderer;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.LocalFileCellRenderer;
import com.myjavaworld.jftp.LocalFileComparator;
import com.myjavaworld.jftp.LocalFileTableModel;
import com.myjavaworld.jftp.LocalSystemPopupMenu;
import com.myjavaworld.jftp.actions.DeleteLocalFileAction;
import com.myjavaworld.jftp.actions.OpenLocalFileAction;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocalPane
extends JPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalPane");
    private static final Icon UP_ARROW_ICON = JFTPUtil.getIcon("upArrow16.gif");
    private static final Icon DOWN_ARROW_ICON = JFTPUtil.getIcon("downArrow16.gif");
    private FTPSession session = null;
    private MComboBox comboRoots = null;
    private MComboBox comboWorkingDirectory = null;
    private MButton butUp = null;
    private LocalFileTableModel model = null;
    private MTable table = null;
    private MScrollPane scroller = null;
    private MLabel labStatus = null;
    private LocalFileComparator comparator = null;
    private boolean updateComboWorkingDirectory = true;
    private MessageFormat statusFormat1 = null;
    private MessageFormat statusFormat2 = null;
    private Object[] statusArgs = null;
    private DirectoryComboBoxModel dcm = null;

    public LocalPane(FTPSession session) {
        this.session = session;
        this.comparator = new LocalFileComparator();
        this.statusFormat1 = new MessageFormat(resources.getString("status.objectCount"));
        this.statusFormat2 = new MessageFormat(resources.getString("status.selectedObjectCount"));
        this.statusFormat1.setLocale(Locale.getDefault());
        this.statusFormat2.setLocale(Locale.getDefault());
        this.statusArgs = new Object[2];
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.configureTable();
        this.updateTableHeader();
    }

    public void setData(LocalFile dir, LocalFile[] data) {
        if (data == null) {
            return;
        }
        if (this.dcm == null) {
            this.dcm = new DirectoryComboBoxModel(dir);
            this.comboWorkingDirectory.setModel(this.dcm);
            this.comboWorkingDirectory.setRenderer(new DirectoryCellRenderer());
        }
        Arrays.sort(data, this.comparator);
        this.model.setData(data);
        if (this.updateComboWorkingDirectory) {
            this.updateComboWorkingDirectory(dir);
        }
        if (data.length > 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(0, 0, true));
        }
        this.updateStatus();
    }

    public LocalFile[] getData() {
        return this.model.getData();
    }

    public int getSelectionCount() {
        return this.table.getSelectedRowCount();
    }

    public LocalFile getSelectedFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.model.getFileAt(row);
    }

    public LocalFile[] getSelectedFiles() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows == null) {
            return new LocalFile[0];
        }
        LocalFile[] selectedFiles = new LocalFile[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedFiles[i] = this.model.getFileAt(selectedRows[i]);
        }
        return selectedFiles;
    }

    public void refresh() {
        this.session.setLocalWorkingDirectory(this.session.getLocalWorkingDirectory());
        this.comboRoots.setModel(new DefaultComboBoxModel<LocalFile>(this.getRoots()));
    }

    public void valueChanged(ListSelectionEvent evt) {
        this.updateStatus();
        this.session.updateToolBar();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butUp) {
            this.session.upLocalWorkingDirectory();
        } else if (evt.getSource() == this.comboRoots) {
            LocalFile root = (LocalFile)this.comboRoots.getSelectedItem();
            if (root == null) {
                return;
            }
            this.session.setLocalWorkingDirectory(root);
        } else if (evt.getSource() == this.comboWorkingDirectory) {
            LocalFile selectedFile = (LocalFile)this.comboWorkingDirectory.getSelectedItem();
            this.updateComboWorkingDirectory = false;
            this.session.setLocalWorkingDirectory(selectedFile);
            this.updateComboWorkingDirectory = true;
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (evt.getSource() == this.table) {
                this.tableRightClicked(evt);
            } else if (evt.getSource() == this.scroller) {
                this.scrollerRightClicked(evt);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
        Cursor cursor;
        if (evt.isPopupTrigger()) {
            if (evt.getSource() == this.table) {
                this.tableRightClicked(evt);
            } else if (evt.getSource() == this.scroller) {
                this.scrollerRightClicked(evt);
            }
        } else if (evt.getSource() == this.table) {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() >= 2) {
                this.doubleClicked(evt);
            }
        } else if (evt.getSource() == this.table.getTableHeader() && SwingUtilities.isLeftMouseButton(evt) && (cursor = this.table.getTableHeader().getCursor()).equals(Cursor.getPredefinedCursor(0))) {
            int column = this.table.columnAtPoint(evt.getPoint());
            column = this.table.convertColumnIndexToModel(column);
            this.sort(column);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    private void tableRightClicked(MouseEvent evt) {
        LocalSystemPopupMenu popup = LocalSystemPopupMenu.getInstance(this.session.getJFTP());
        ((JPopupMenu)popup).show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    private void scrollerRightClicked(MouseEvent evt) {
        this.table.clearSelection();
        LocalSystemPopupMenu popup = LocalSystemPopupMenu.getInstance(this.session.getJFTP());
        ((JPopupMenu)popup).show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    private void doubleClicked(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row < 0) {
            return;
        }
        LocalFile file = this.model.getFileAt(row);
        OpenLocalFileAction.getInstance(this.session.getJFTP()).actionPerformed(null);
    }

    private LocalFile[] getRoots() {
        LocalFile[] roots = LocalFile.listRoots();
        if (roots == null) {
            roots = new LocalFile[]{};
        }
        return roots;
    }

    private void updateComboWorkingDirectory(LocalFile dir) {
        this.comboWorkingDirectory.removeActionListener(this);
        this.dcm.addItem(dir);
        this.dcm.setSelectedItem(dir);
        this.comboWorkingDirectory.addActionListener(this);
    }

    private void updateStatus() {
        long size = 0L;
        int count = this.table.getSelectedRowCount();
        if (count > 0) {
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                size += this.model.getFileAt(selectedRows[i]).getSize();
            }
            this.statusArgs[0] = new Integer(count);
            this.statusArgs[1] = new Long(size);
            this.labStatus.setText(this.statusFormat2.format(this.statusArgs));
            return;
        }
        count = this.model.getRowCount();
        for (int i = 0; i < count; ++i) {
            size += this.model.getFileAt(i).getSize();
        }
        this.statusArgs[0] = new Integer(count);
        this.statusArgs[1] = new Long(size);
        this.labStatus.setText(this.statusFormat1.format(this.statusArgs));
    }

    private void sort(int col) {
        int compareBy = this.comparator.getCompareBy();
        int order = this.comparator.getOrder();
        if (compareBy == col + 1) {
            order = order == 1 ? 2 : 1;
        } else {
            compareBy = col + 1;
            order = 1;
        }
        this.comparator.setCompareBy(compareBy);
        this.comparator.setOrder(order);
        LocalFile[] data = this.model.getData();
        Arrays.sort(this.model.getData(), this.comparator);
        this.model.setData(data);
        this.updateTableHeader();
    }

    private void updateTableHeader() {
        int compareBy = this.comparator.getCompareBy();
        int order = this.comparator.getOrder();
        Icon icon = order == 1 ? UP_ARROW_ICON : DOWN_ARROW_ICON;
        for (int i = 0; i < 4; ++i) {
            MTableHeaderRenderer r = new MTableHeaderRenderer();
            if (compareBy - 1 == i) {
                r.setIcon(icon);
            } else {
                r.setIcon(null);
            }
            this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(i)).setHeaderRenderer(r);
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.comboRoots = new MComboBox(this.getRoots());
        this.comboRoots.setRenderer(new DriveCellRenderer());
        this.comboRoots.setToolTipText(resources.getString("tooltip.roots"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.comboRoots, c);
        this.comboWorkingDirectory = new MComboBox();
        this.comboWorkingDirectory.setToolTipText(resources.getString("tooltip.workingDirectory"));
        this.comboWorkingDirectory.addActionListener(this);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.comboWorkingDirectory, c);
        this.butUp = new MButton(JFTPUtil.getIcon("upDirectory16.gif"));
        this.butUp.setToolTipText(resources.getString("tooltip.up"));
        this.butUp.addActionListener(this);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.butUp, c);
        this.model = new LocalFileTableModel();
        this.table = new MTable(this.model){

            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.scroller = new MScrollPane(this.table);
        if (this.table.isBackgroundSet()) {
            this.scroller.getViewport().setBackground(this.table.getBackground());
        }
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.scroller, c);
        this.labStatus = new MLabel("Status Bar");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.labStatus, c);
        this.comboRoots.addActionListener(this);
    }

    private void configureTable() {
        this.table.setName("localPane");
        this.scroller.setName("localPane");
        DnDTransferHandler th = new DnDTransferHandler(this.session.getJFTP());
        this.table.setDragEnabled(true);
        this.scroller.setTransferHandler(th);
        this.table.setTransferHandler(th);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.setDefaultRenderer(LocalFile.class, new LocalFileCellRenderer());
        this.table.setDefaultRenderer(Long.class, new NumericCellRenderer());
        int dateFormat = JFTP.prefs.getDateFormat();
        int timeFormat = JFTP.prefs.getTimeFormat();
        this.table.setDefaultRenderer(Date.class, new DateCellRenderer(dateFormat, timeFormat));
        this.table.setDefaultRenderer(Object.class, new MTableCellRenderer());
        this.table.addMouseListener(this);
        this.scroller.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getTableHeader().setDefaultRenderer(new MTableHeaderRenderer());
        this.table.getTableHeader().addMouseListener(this);
        this.table.registerKeyboardAction(DeleteLocalFileAction.getInstance(this.session.getJFTP()), "cmd.deleteLocalFile", KeyStroke.getKeyStroke(GUIUtil.getDeleteKey(), 0), 0);
        this.table.registerKeyboardAction(OpenLocalFileAction.getInstance(this.session.getJFTP()), "cmd.openLocalFile", KeyStroke.getKeyStroke(10, 0), 0);
    }

    public void selectAll() {
        this.table.selectAll();
    }

    public void invertSelection() {
        int rowCount = this.model.getRowCount();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        for (int i = 0; i < rowCount; ++i) {
            if (selectionModel.isSelectedIndex(i)) {
                selectionModel.removeSelectionInterval(i, i);
                continue;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }

    class DirectoryCellRenderer
    extends MLabel
    implements ListCellRenderer {
        private IndentIcon indentIcon = null;

        public DirectoryCellRenderer() {
            this.setOpaque(true);
            this.indentIcon = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            LocalFile lf = (LocalFile)value;
            this.setText(lf.getDisplayName());
            this.indentIcon.setIcon(lf.getIcon());
            this.indentIcon.setDepth(index + 1);
            this.setIcon(this.indentIcon);
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setFont(list.getFont());
            return this;
        }
    }

    class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private LocalFile selectedDir = null;
        private Vector dirs = new Vector(10);

        public DirectoryComboBoxModel(LocalFile dir) {
            this.selectedDir = dir;
        }

        public Object getSelectedItem() {
            return this.selectedDir;
        }

        public void setSelectedItem(Object selectedDir) {
            this.selectedDir = (LocalFile)selectedDir;
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.dirs.size();
        }

        public Object getElementAt(int index) {
            return this.dirs.get(index);
        }

        private void addItem(LocalFile dir) {
            if (dir == null) {
                return;
            }
            LocalFile cdir = dir;
            try {
                cdir = dir.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dirs.clear();
            do {
                this.dirs.add(0, cdir);
            } while ((cdir = cdir.getParent()) != null);
        }
    }
}

