/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.actions.ChangeLocalDirectoryAction;
import com.myjavaworld.jftp.actions.DeleteLocalFileAction;
import com.myjavaworld.jftp.actions.EditLocalFileAction;
import com.myjavaworld.jftp.actions.NewLocalDirectoryAction;
import com.myjavaworld.jftp.actions.NewLocalFileAction;
import com.myjavaworld.jftp.actions.OpenLocalFileAction;
import com.myjavaworld.jftp.actions.PrintLocalFileAction;
import com.myjavaworld.jftp.actions.RenameLocalFileAction;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Desktop;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class LocalSystemMenu
extends MMenu
implements MenuListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalSystemMenu");
    private static final ResourceBundle ftpMenuResources = ResourceLoader.getBundle("com.myjavaworld.jftp.FTPMenu");
    private JFTP jftp = null;
    private MMenuItem miOpenFile = null;
    private MMenuItem miEditFile = null;
    private MMenuItem miPrintFile = null;
    private MMenu menuNew = null;
    private MMenuItem miFile = null;
    private MMenuItem miDirectory = null;
    private MMenuItem miChangeDirectory = null;
    private MMenuItem miRename = null;
    private MMenuItem miDelete = null;
    private MMenuItem miApplyFilter = null;
    private MMenuItem miClearFilter = null;
    private MMenuItem miRefresh = null;
    private MMenuItem miProperties = null;
    private MMenuItem miSelectAll = null;
    private MMenuItem miInvertSelection = null;
    private boolean openSupported = false;
    private boolean editSupported = false;
    private boolean printSupported = false;

    public LocalSystemMenu(JFTP jftp) {
        this.jftp = jftp;
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            this.openSupported = desktop.isSupported(Desktop.Action.OPEN);
            this.editSupported = desktop.isSupported(Desktop.Action.EDIT);
            this.printSupported = desktop.isSupported(Desktop.Action.PRINT);
        }
        this.setText(resources.getString("text.localSystem"));
        this.setMnemonic(resources.getString("mnemonic.localSystem"), resources.getString("mnemonicIndex.localSystem"));
        this.prepareMenuItems();
        this.addMenuListener(this);
    }

    private void prepareMenuItems() {
        this.miOpenFile = new MMenuItem();
        this.miOpenFile.setText(resources.getString("text.open"));
        this.miOpenFile.setActionCommand("cmd.openLocalFile");
        this.miOpenFile.setAccelerator(KeyStroke.getKeyStroke(79, GUIUtil.ACCELERATOR_MASK + 1));
        this.miOpenFile.setMnemonic(resources.getString("mnemonic.open"), resources.getString("mnemonicIndex.open"));
        this.miOpenFile.addActionListener(OpenLocalFileAction.getInstance(this.jftp));
        this.add(this.miOpenFile);
        this.miEditFile = new MMenuItem();
        this.miEditFile.setText(resources.getString("text.edit"));
        this.miEditFile.setActionCommand("cmd.editLocalFile");
        this.miEditFile.setAccelerator(KeyStroke.getKeyStroke(69, GUIUtil.ACCELERATOR_MASK + 1));
        this.miEditFile.setMnemonic(resources.getString("mnemonic.edit"), resources.getString("mnemonicIndex.edit"));
        this.miEditFile.addActionListener(EditLocalFileAction.getInstance(this.jftp));
        this.add(this.miEditFile);
        this.miPrintFile = new MMenuItem();
        this.miPrintFile.setText(resources.getString("text.print"));
        this.miPrintFile.setActionCommand("cmd.printLocalFile");
        this.miPrintFile.setAccelerator(KeyStroke.getKeyStroke(80, GUIUtil.ACCELERATOR_MASK + 1));
        this.miPrintFile.setMnemonic(resources.getString("mnemonic.print"), resources.getString("mnemonicIndex.print"));
        this.miPrintFile.addActionListener(PrintLocalFileAction.getInstance(this.jftp));
        this.add(this.miPrintFile);
        this.addSeparator();
        this.menuNew = new MMenu(resources.getString("text.new"), true);
        this.menuNew.setMnemonic(resources.getString("mnemonic.new"), resources.getString("mnemonicIndex.new"));
        this.add(this.menuNew);
        this.miFile = new MMenuItem();
        this.miFile.setText(resources.getString("text.file"));
        this.miFile.setAccelerator(KeyStroke.getKeyStroke(70, GUIUtil.ACCELERATOR_MASK + 1));
        this.miFile.setMnemonic(resources.getString("mnemonic.file"), resources.getString("mnemonicIndex.file"));
        this.miFile.addActionListener(NewLocalFileAction.getInstance(this.jftp));
        this.menuNew.add(this.miFile);
        this.miDirectory = new MMenuItem();
        this.miDirectory.setText(resources.getString("text.directory"));
        this.miDirectory.setAccelerator(KeyStroke.getKeyStroke(68, GUIUtil.ACCELERATOR_MASK + 1));
        this.miDirectory.setMnemonic(resources.getString("mnemonic.directory"), resources.getString("mnemonicIndex.directory"));
        this.miDirectory.addActionListener(NewLocalDirectoryAction.getInstance(this.jftp));
        this.menuNew.add(this.miDirectory);
        this.miChangeDirectory = new MMenuItem();
        this.miChangeDirectory.setText(resources.getString("text.changeDirectory"));
        this.miChangeDirectory.setMnemonic(resources.getString("mnemonic.changeDirectory"), resources.getString("mnemonicIndex.changeDirectory"));
        this.miChangeDirectory.addActionListener(ChangeLocalDirectoryAction.getInstance(this.jftp));
        this.add(this.miChangeDirectory);
        this.miRename = new MMenuItem();
        this.miRename.setText(resources.getString("text.rename"));
        this.miRename.setAccelerator(KeyStroke.getKeyStroke(82, GUIUtil.ACCELERATOR_MASK + 1));
        this.miRename.setMnemonic(resources.getString("mnemonic.rename"), resources.getString("mnemonicIndex.rename"));
        this.miRename.addActionListener(RenameLocalFileAction.getInstance(this.jftp));
        this.add(this.miRename);
        this.miDelete = new MMenuItem();
        this.miDelete.setText(resources.getString("text.delete"));
        this.miDelete.setAccelerator(KeyStroke.getKeyStroke(GUIUtil.getDeleteKey(), GUIUtil.ACCELERATOR_MASK + 1));
        this.miDelete.setMnemonic(resources.getString("mnemonic.delete"), resources.getString("mnemonicIndex.delete"));
        this.miDelete.addActionListener(DeleteLocalFileAction.getInstance(this.jftp));
        this.add(this.miDelete);
        this.addSeparator();
        this.miApplyFilter = new MMenuItem();
        this.miApplyFilter.setText(resources.getString("text.applyFilter"));
        this.miApplyFilter.setMnemonic(resources.getString("mnemonic.applyFilter"), resources.getString("mnemonicIndex.applyFilter"));
        this.miApplyFilter.setActionCommand("cmd.applyLocalFileFilter");
        this.miApplyFilter.addActionListener(this.jftp);
        this.add(this.miApplyFilter);
        this.miClearFilter = new MMenuItem();
        this.miClearFilter.setText(resources.getString("text.clearFilter"));
        this.miClearFilter.setMnemonic(resources.getString("mnemonic.clearFilter"), resources.getString("mnemonicIndex.clearFilter"));
        this.miClearFilter.setActionCommand("cmd.clearLocalFileFilter");
        this.miClearFilter.addActionListener(this.jftp);
        this.add(this.miClearFilter);
        this.addSeparator();
        this.miRefresh = new MMenuItem();
        this.miRefresh.setText(resources.getString("text.refresh"));
        this.miRefresh.setMnemonic(resources.getString("mnemonic.refresh"), resources.getString("mnemonicIndex.refresh"));
        this.miRefresh.setActionCommand("cmd.refreshLocalPane");
        this.miRefresh.addActionListener(this.jftp);
        this.miRefresh.setAccelerator(KeyStroke.getKeyStroke(116, GUIUtil.ACCELERATOR_MASK + 1));
        this.add(this.miRefresh);
        this.addSeparator();
        this.miProperties = new MMenuItem();
        this.miProperties.setText(resources.getString("text.properties"));
        this.miProperties.setMnemonic(resources.getString("mnemonic.properties"), resources.getString("mnemonicIndex.properties"));
        this.miProperties.setActionCommand("cmd.localFileProperties");
        this.miProperties.addActionListener(this.jftp);
        this.miProperties.setAccelerator(KeyStroke.getKeyStroke(73, GUIUtil.ACCELERATOR_MASK + 1));
        this.add(this.miProperties);
        this.addSeparator();
        this.miSelectAll = new MMenuItem();
        this.miSelectAll.setText(resources.getString("text.selectAll"));
        this.miSelectAll.setMnemonic(resources.getString("mnemonic.selectAll"), resources.getString("mnemonicIndex.selectAll"));
        this.miSelectAll.setActionCommand("cmd.localSelectAll");
        this.miSelectAll.addActionListener(this.jftp);
        this.add(this.miSelectAll);
        this.miInvertSelection = new MMenuItem();
        this.miInvertSelection.setText(resources.getString("text.invertSelection"));
        this.miInvertSelection.setMnemonic(resources.getString("mnemonic.invertSelection"), resources.getString("mnemonicIndex.invertSelection"));
        this.miInvertSelection.setActionCommand("cmd.localInvertSelection");
        this.miInvertSelection.addActionListener(this.jftp);
        this.add(this.miInvertSelection);
    }

    public void menuCanceled(MenuEvent menuEvent) {
        this.miOpenFile.setEnabled(true);
        this.miEditFile.setEnabled(true);
        this.miPrintFile.setEnabled(true);
        this.menuNew.setEnabled(true);
        this.miChangeDirectory.setEnabled(true);
        this.miRename.setEnabled(true);
        this.miDelete.setEnabled(true);
        this.miApplyFilter.setEnabled(true);
        this.miClearFilter.setEnabled(true);
        this.miRefresh.setEnabled(true);
        this.miProperties.setEnabled(true);
        this.miSelectAll.setEnabled(true);
        this.miInvertSelection.setEnabled(true);
    }

    public void menuDeselected(MenuEvent menuEvent) {
        this.miOpenFile.setEnabled(true);
        this.miEditFile.setEnabled(true);
        this.miPrintFile.setEnabled(true);
        this.menuNew.setEnabled(true);
        this.miChangeDirectory.setEnabled(true);
        this.miRename.setEnabled(true);
        this.miDelete.setEnabled(true);
        this.miApplyFilter.setEnabled(true);
        this.miClearFilter.setEnabled(true);
        this.miRefresh.setEnabled(true);
        this.miProperties.setEnabled(true);
        this.miSelectAll.setEnabled(true);
        this.miInvertSelection.setEnabled(true);
    }

    public void menuSelected(MenuEvent menuEvent) {
        FTPSession session = this.jftp.getCurrentSession();
        boolean nullSession = session == null;
        boolean connected = !nullSession && session.isConnected();
        int selectionCount = 0;
        boolean isFile = false;
        if (!nullSession && (selectionCount = session.getLocalFileSelectionCount()) == 1) {
            LocalFile selectedFile = session.getSelectedLocalFile();
            isFile = selectedFile.isFile();
        }
        if (isFile) {
            this.miOpenFile.setEnabled(!nullSession && selectionCount == 1 && this.openSupported);
        } else {
            this.miOpenFile.setEnabled(!nullSession && selectionCount == 1);
        }
        this.miEditFile.setEnabled(!nullSession && selectionCount == 1 && isFile && this.editSupported);
        this.miPrintFile.setEnabled(!nullSession && selectionCount == 1 && isFile && this.printSupported);
        this.menuNew.setEnabled(!nullSession);
        this.miChangeDirectory.setEnabled(!nullSession);
        this.miRename.setEnabled(!nullSession && selectionCount == 1);
        this.miDelete.setEnabled(!nullSession && selectionCount > 0);
        this.miApplyFilter.setEnabled(!nullSession);
        this.miClearFilter.setEnabled(!nullSession && session.getLocalFileFilter() != null);
        this.miRefresh.setEnabled(!nullSession);
        this.miProperties.setEnabled(!nullSession && selectionCount == 1);
        this.miSelectAll.setEnabled(!nullSession);
        this.miInvertSelection.setEnabled(!nullSession);
    }
}

