/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.gui.MPopupMenu;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.actions.ChangeLocalDirectoryAction;
import com.myjavaworld.jftp.actions.DeleteLocalFileAction;
import com.myjavaworld.jftp.actions.EditLocalFileAction;
import com.myjavaworld.jftp.actions.NewLocalDirectoryAction;
import com.myjavaworld.jftp.actions.NewLocalFileAction;
import com.myjavaworld.jftp.actions.OpenLocalFileAction;
import com.myjavaworld.jftp.actions.PrintLocalFileAction;
import com.myjavaworld.jftp.actions.RenameLocalFileAction;
import com.myjavaworld.jftp.actions.UploadAction;
import com.myjavaworld.jftp.actions.UploadAsAction;
import com.myjavaworld.jftp.actions.ZipAndUploadAction;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Desktop;
import java.util.ResourceBundle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class LocalSystemPopupMenu
extends MPopupMenu
implements PopupMenuListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalSystemMenu");
    private static final ResourceBundle ftpMenuResources = ResourceLoader.getBundle("com.myjavaworld.jftp.FTPMenu");
    private JFTP jftp = null;
    private MMenuItem miUpload = null;
    private MMenuItem miUploadAs = null;
    private MMenuItem miZipAndUpload = null;
    private MMenuItem miOpenFile = null;
    private MMenuItem miEditFile = null;
    private MMenuItem miPrintFile = null;
    private MMenu menuNew = null;
    private MMenuItem miFile = null;
    private MMenuItem miDirectory = null;
    private MMenuItem miChangeDirectory = null;
    private MMenuItem miRename = null;
    private MMenuItem miDelete = null;
    private MMenuItem miApplyFilter = null;
    private MMenuItem miClearFilter = null;
    private MMenuItem miRefresh = null;
    private MMenuItem miProperties = null;
    private MMenuItem miSelectAll = null;
    private MMenuItem miInvertSelection = null;
    private static LocalSystemPopupMenu instance = null;
    private boolean openSupported = false;
    private boolean editSupported = false;
    private boolean printSupported = false;

    private LocalSystemPopupMenu(JFTP jftp) {
        this.jftp = jftp;
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            this.openSupported = desktop.isSupported(Desktop.Action.OPEN);
            this.editSupported = desktop.isSupported(Desktop.Action.EDIT);
            this.printSupported = desktop.isSupported(Desktop.Action.PRINT);
        }
        this.preparePopupMenu();
        this.addPopupMenuListener(this);
    }

    public static LocalSystemPopupMenu getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new LocalSystemPopupMenu(jftp);
        }
        return instance;
    }

    private void preparePopupMenu() {
        this.miUpload = new MMenuItem();
        this.miUpload.setText(ftpMenuResources.getString("text.upload"));
        this.miUpload.addActionListener(UploadAction.getInstance(this.jftp));
        this.add(this.miUpload);
        this.miUploadAs = new MMenuItem(ftpMenuResources.getString("text.uploadAs"));
        this.miUploadAs.addActionListener(UploadAsAction.getInstance(this.jftp));
        this.add(this.miUploadAs);
        this.miZipAndUpload = new MMenuItem();
        this.miZipAndUpload.setText(ftpMenuResources.getString("text.zipAndUpload"));
        this.miZipAndUpload.setMnemonic(ftpMenuResources.getString("mnemonic.zipAndUpload"), ftpMenuResources.getString("mnemonicIndex.zipAndUpload"));
        this.miZipAndUpload.addActionListener(ZipAndUploadAction.getInstance(this.jftp));
        this.add(this.miZipAndUpload);
        this.addSeparator();
        this.miOpenFile = new MMenuItem(resources.getString("text.open"));
        this.miOpenFile.setActionCommand("cmd.openLocalFile");
        this.miOpenFile.addActionListener(OpenLocalFileAction.getInstance(this.jftp));
        this.add(this.miOpenFile);
        this.miEditFile = new MMenuItem(resources.getString("text.edit"));
        this.miEditFile.setActionCommand("cmd.editLocalFile");
        this.miEditFile.addActionListener(EditLocalFileAction.getInstance(this.jftp));
        this.add(this.miEditFile);
        this.miPrintFile = new MMenuItem(resources.getString("text.print"));
        this.miPrintFile.setActionCommand("cmd.printLocalFile");
        this.miPrintFile.addActionListener(PrintLocalFileAction.getInstance(this.jftp));
        this.add(this.miPrintFile);
        this.addSeparator();
        this.menuNew = new MMenu(resources.getString("text.new"), true);
        this.add(this.menuNew);
        this.miFile = new MMenuItem();
        this.miFile.setText(resources.getString("text.file"));
        this.miFile.addActionListener(NewLocalFileAction.getInstance(this.jftp));
        this.menuNew.add(this.miFile);
        this.miDirectory = new MMenuItem();
        this.miDirectory.setText(resources.getString("text.directory"));
        this.miDirectory.addActionListener(NewLocalDirectoryAction.getInstance(this.jftp));
        this.menuNew.add(this.miDirectory);
        this.miChangeDirectory = new MMenuItem();
        this.miChangeDirectory.setText(resources.getString("text.changeDirectory"));
        this.miChangeDirectory.addActionListener(ChangeLocalDirectoryAction.getInstance(this.jftp));
        this.add(this.miChangeDirectory);
        this.miRename = new MMenuItem();
        this.miRename.setText(resources.getString("text.rename"));
        this.miRename.addActionListener(RenameLocalFileAction.getInstance(this.jftp));
        this.add(this.miRename);
        this.miDelete = new MMenuItem();
        this.miDelete.setText(resources.getString("text.delete"));
        this.miDelete.addActionListener(DeleteLocalFileAction.getInstance(this.jftp));
        this.add(this.miDelete);
        this.addSeparator();
        this.miApplyFilter = new MMenuItem(resources.getString("text.applyFilter"));
        this.miApplyFilter.setActionCommand("cmd.applyLocalFileFilter");
        this.miApplyFilter.addActionListener(this.jftp);
        this.add(this.miApplyFilter);
        this.miClearFilter = new MMenuItem(resources.getString("text.clearFilter"));
        this.miClearFilter.setActionCommand("cmd.clearLocalFileFilter");
        this.miClearFilter.addActionListener(this.jftp);
        this.add(this.miClearFilter);
        this.addSeparator();
        this.miRefresh = new MMenuItem(resources.getString("text.refresh"));
        this.miRefresh.setActionCommand("cmd.refreshLocalPane");
        this.miRefresh.addActionListener(this.jftp);
        this.add(this.miRefresh);
        this.addSeparator();
        this.miProperties = new MMenuItem(resources.getString("text.properties"));
        this.miProperties.setActionCommand("cmd.localFileProperties");
        this.miProperties.addActionListener(this.jftp);
        this.add(this.miProperties);
        this.addSeparator();
        this.miSelectAll = new MMenuItem();
        this.miSelectAll.setText(resources.getString("text.selectAll"));
        this.miSelectAll.setMnemonic(resources.getString("mnemonic.selectAll"), resources.getString("mnemonicIndex.selectAll"));
        this.miSelectAll.setActionCommand("cmd.localSelectAll");
        this.miSelectAll.addActionListener(this.jftp);
        this.add(this.miSelectAll);
        this.miInvertSelection = new MMenuItem();
        this.miInvertSelection.setText(resources.getString("text.invertSelection"));
        this.miInvertSelection.setMnemonic(resources.getString("mnemonic.invertSelection"), resources.getString("mnemonicIndex.invertSelection"));
        this.miInvertSelection.setActionCommand("cmd.localInvertSelection");
        this.miInvertSelection.addActionListener(this.jftp);
        this.add(this.miInvertSelection);
        this.miUpload.setMnemonic(ftpMenuResources.getString("mnemonic.upload"), ftpMenuResources.getString("mnemonicIndex.upload"));
        this.miUploadAs.setMnemonic(ftpMenuResources.getString("mnemonic.uploadAs"), ftpMenuResources.getString("mnemonicIndex.uploadAs"));
        this.miOpenFile.setMnemonic(resources.getString("mnemonic.open"), resources.getString("mnemonicIndex.open"));
        this.miEditFile.setMnemonic(resources.getString("mnemonic.edit"), resources.getString("mnemonicIndex.edit"));
        this.miPrintFile.setMnemonic(resources.getString("mnemonic.print"), resources.getString("mnemonicIndex.print"));
        this.menuNew.setMnemonic(resources.getString("mnemonic.new"), resources.getString("mnemonicIndex.new"));
        this.miFile.setMnemonic(resources.getString("mnemonic.file"), resources.getString("mnemonicIndex.file"));
        this.miDirectory.setMnemonic(resources.getString("mnemonic.directory"), resources.getString("mnemonicIndex.directory"));
        this.miChangeDirectory.setMnemonic(resources.getString("mnemonic.changeDirectory"), resources.getString("mnemonicIndex.changeDirectory"));
        this.miRename.setMnemonic(resources.getString("mnemonic.rename"), resources.getString("mnemonicIndex.rename"));
        this.miDelete.setMnemonic(resources.getString("mnemonic.delete"), resources.getString("mnemonicIndex.delete"));
        this.miApplyFilter.setMnemonic(resources.getString("mnemonic.applyFilter"), resources.getString("mnemonicIndex.applyFilter"));
        this.miClearFilter.setMnemonic(resources.getString("mnemonic.clearFilter"), resources.getString("mnemonicIndex.clearFilter"));
        this.miRefresh.setMnemonic(resources.getString("mnemonic.refresh"), resources.getString("mnemonicIndex.refresh"));
        this.miProperties.setMnemonic(resources.getString("mnemonic.properties"), resources.getString("mnemonicIndex.properties"));
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        FTPSession session = this.jftp.getCurrentSession();
        boolean nullSession = session == null;
        boolean connected = !nullSession && session.isConnected();
        int selectionCount = 0;
        boolean isFile = false;
        if (!nullSession && (selectionCount = session.getLocalFileSelectionCount()) == 1) {
            LocalFile selectedFile = session.getSelectedLocalFile();
            isFile = selectedFile.isFile();
        }
        this.miUpload.setEnabled(connected && selectionCount > 0);
        this.miUploadAs.setEnabled(connected && selectionCount == 1);
        this.miZipAndUpload.setEnabled(connected && selectionCount > 0);
        if (isFile) {
            this.miOpenFile.setEnabled(selectionCount == 1 && this.openSupported);
        } else {
            this.miOpenFile.setEnabled(selectionCount == 1);
        }
        this.miEditFile.setEnabled(selectionCount == 1 && isFile && this.editSupported);
        this.miPrintFile.setEnabled(selectionCount == 1 && isFile && this.printSupported);
        this.miRename.setEnabled(selectionCount == 1);
        this.miDelete.setEnabled(selectionCount > 0);
        this.miClearFilter.setEnabled(session.getLocalFileFilter() != null);
        this.miProperties.setEnabled(selectionCount == 1);
    }
}

